/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.matching.ExactMatchMultiValuePattern;
import com.github.tomakehurst.wiremock.matching.IncludesMatchMultiValuePattern;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.SingleMatchMultiValuePattern;
import java.io.IOException;
import wiremock.com.fasterxml.jackson.core.JsonParser;
import wiremock.com.fasterxml.jackson.core.TreeNode;
import wiremock.com.fasterxml.jackson.databind.DeserializationContext;
import wiremock.com.fasterxml.jackson.databind.JsonDeserializer;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.ObjectMapper;

public class MultiValuePatternDeserializer
extends JsonDeserializer<MultiValuePattern> {
    @Override
    public MultiValuePattern deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        JsonNode rootNode = (JsonNode)parser.readValueAsTree();
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        if (rootNode.has("hasExactly")) {
            return mapper.treeToValue((TreeNode)rootNode, ExactMatchMultiValuePattern.class);
        }
        if (rootNode.has("includes")) {
            return mapper.treeToValue((TreeNode)rootNode, IncludesMatchMultiValuePattern.class);
        }
        return mapper.treeToValue((TreeNode)rootNode, SingleMatchMultiValuePattern.class);
    }
}

