/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.HashMap;
import java.util.Map;
import wiremock.com.fasterxml.jackson.databind.node.ObjectNode;
import wiremock.com.networknt.schema.SchemaLocation;

public class DiscriminatorContext {
    private final Map<String, ObjectNode> discriminators = new HashMap<String, ObjectNode>();
    private boolean discriminatorMatchFound = false;
    private boolean discriminatorIgnore = false;

    public void registerDiscriminator(SchemaLocation schemaLocation, ObjectNode discriminator) {
        this.discriminators.put("#" + schemaLocation.getFragment().toString(), discriminator);
    }

    public ObjectNode getDiscriminatorForPath(SchemaLocation schemaLocation) {
        return this.discriminators.get("#" + schemaLocation.getFragment().toString());
    }

    public ObjectNode getDiscriminatorForPath(String schemaLocation) {
        return this.discriminators.get(schemaLocation);
    }

    public void markMatch() {
        this.discriminatorMatchFound = true;
    }

    public void markIgnore() {
        this.discriminatorIgnore = true;
    }

    public boolean isDiscriminatorMatchFound() {
        return this.discriminatorMatchFound;
    }

    public boolean isDiscriminatorIgnore() {
        return this.discriminatorIgnore;
    }

    public boolean isActive() {
        return !this.discriminators.isEmpty();
    }
}

