/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestSuite;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.DefaultRedirectHandler;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.wiztools.commons.Implementation;
import org.wiztools.commons.MultiValueMap;
import org.wiztools.commons.StreamUtil;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.HTTPAuthMethod;
import org.wiztools.restclient.HTTPMethod;
import org.wiztools.restclient.HTTPVersion;
import org.wiztools.restclient.IGlobalOptions;
import org.wiztools.restclient.MultipleRequestInSameRequestExecuterException;
import org.wiztools.restclient.ProxyConfig;
import org.wiztools.restclient.ReqEntity;
import org.wiztools.restclient.Request;
import org.wiztools.restclient.RequestExecuter;
import org.wiztools.restclient.ResponseBean;
import org.wiztools.restclient.SSLHostnameVerifier;
import org.wiztools.restclient.TestException;
import org.wiztools.restclient.TestResult;
import org.wiztools.restclient.TestUtil;
import org.wiztools.restclient.Util;
import org.wiztools.restclient.View;

public class HTTPClientRequestExecuter
implements RequestExecuter {
    private static final Logger LOG = Logger.getLogger(HTTPClientRequestExecuter.class.getName());
    private DefaultHttpClient httpclient;
    private boolean interruptedShutdown = false;
    private boolean isRequestCompleted = false;
    private boolean isRequestStarted = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Request request, View ... views) {
        boolean authEnabled;
        if (this.isRequestStarted) {
            throw new MultipleRequestInSameRequestExecuterException("A RequestExecuter object can be used only once!");
        }
        this.isRequestStarted = true;
        for (View view : views) {
            view.doStart(request);
        }
        URL url = request.getUrl();
        String urlHost = url.getHost();
        int urlPort = url.getPort() == -1 ? url.getDefaultPort() : url.getPort();
        String urlProtocol = url.getProtocol();
        String urlStr = url.toString();
        BasicHttpContext httpContext = null;
        this.httpclient = new DefaultHttpClient();
        HTTPVersion httpVersion = request.getHttpVersion();
        ProtocolVersion protocolVersion = httpVersion == HTTPVersion.HTTP_1_1 ? new ProtocolVersion("HTTP", 1, 1) : new ProtocolVersion("HTTP", 1, 0);
        this.httpclient.getParams().setParameter("http.protocol.version", (Object)protocolVersion);
        IGlobalOptions options = (IGlobalOptions)Implementation.of(IGlobalOptions.class);
        options.acquire();
        HttpConnectionParams.setConnectionTimeout((HttpParams)this.httpclient.getParams(), (int)Integer.parseInt(options.getProperty("request-timeout-in-millis")));
        options.release();
        ProxyConfig proxy = ProxyConfig.getInstance();
        proxy.acquire();
        if (proxy.isEnabled()) {
            HttpHost proxyHost = new HttpHost(proxy.getHost(), proxy.getPort(), "http");
            if (proxy.isAuthEnabled()) {
                this.httpclient.getCredentialsProvider().setCredentials(new AuthScope(proxy.getHost(), proxy.getPort()), (Credentials)new UsernamePasswordCredentials(proxy.getUsername(), new String(proxy.getPassword())));
            }
            this.httpclient.getParams().setParameter("http.route.default-proxy", (Object)proxyHost);
        }
        proxy.release();
        boolean bl = authEnabled = request.getAuthMethods().size() > 0;
        if (authEnabled) {
            String uid = request.getAuthUsername();
            String pwd = new String(request.getAuthPassword());
            String host = StringUtil.isStrEmpty((String)request.getAuthHost()) ? urlHost : request.getAuthHost();
            String realm = StringUtil.isStrEmpty((String)request.getAuthRealm()) ? AuthScope.ANY_REALM : request.getAuthRealm();
            ArrayList<String> authPrefs = new ArrayList<String>(2);
            List<HTTPAuthMethod> authMethods = request.getAuthMethods();
            for (HTTPAuthMethod authMethod : authMethods) {
                switch (authMethod) {
                    case BASIC: {
                        authPrefs.add("Basic");
                        break;
                    }
                    case DIGEST: {
                        authPrefs.add("Digest");
                    }
                }
            }
            this.httpclient.getParams().setParameter("http.auth.scheme-pref", authPrefs);
            this.httpclient.getCredentialsProvider().setCredentials(new AuthScope(host, urlPort, realm), (Credentials)new UsernamePasswordCredentials(uid, pwd));
            if (request.isAuthPreemptive()) {
                BasicHttpContext localcontext = new BasicHttpContext();
                BasicScheme basicAuth = new BasicScheme();
                localcontext.setAttribute("preemptive-auth", (Object)basicAuth);
                this.httpclient.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuth(), 0);
                httpContext = localcontext;
            }
        }
        HttpGet method = null;
        HTTPMethod httpMethod = request.getMethod();
        try {
            ResponseBean response;
            block74: {
                Charset c;
                X509HostnameVerifier hcVerifier;
                switch (httpMethod) {
                    case GET: {
                        method = new HttpGet(urlStr);
                        break;
                    }
                    case POST: {
                        method = new HttpPost(urlStr);
                        break;
                    }
                    case PUT: {
                        method = new HttpPut(urlStr);
                        break;
                    }
                    case DELETE: {
                        method = new HttpDelete(urlStr);
                        break;
                    }
                    case HEAD: {
                        method = new HttpHead(urlStr);
                        break;
                    }
                    case OPTIONS: {
                        method = new HttpOptions(urlStr);
                        break;
                    }
                    case TRACE: {
                        method = new HttpTrace(urlStr);
                    }
                }
                method.setParams(new BasicHttpParams().setParameter(urlStr, (Object)url));
                MultiValueMap<String, String> header_data = request.getHeaders();
                for (String key : header_data.keySet()) {
                    for (String value : header_data.get((Object)key)) {
                        BasicHeader header = new BasicHeader(key, value);
                        method.addHeader((Header)header);
                    }
                }
                if (method instanceof HttpEntityEnclosingRequest) {
                    HttpEntityEnclosingRequest eeMethod = (HttpEntityEnclosingRequest)method;
                    ReqEntity bean = request.getBody();
                    if (bean != null) {
                        try {
                            ByteArrayEntity entity = new ByteArrayEntity(bean.getBody().getBytes(bean.getCharSet()));
                            entity.setContentType(bean.getContentTypeCharsetFormatted());
                            eeMethod.setEntity((HttpEntity)entity);
                        }
                        catch (UnsupportedEncodingException ex) {
                            for (View view : views) {
                                view.doError(Util.getStackTrace(ex));
                                view.doEnd();
                            }
                            if (method != null && !this.interruptedShutdown) {
                                this.httpclient.getConnectionManager().shutdown();
                            }
                            for (View view : views) {
                                view.doEnd();
                            }
                            this.isRequestCompleted = true;
                            return;
                        }
                    }
                }
                SSLHostnameVerifier verifier = request.getSslHostNameVerifier();
                switch (verifier) {
                    case STRICT: {
                        hcVerifier = SSLSocketFactory.STRICT_HOSTNAME_VERIFIER;
                        break;
                    }
                    case BROWSER_COMPATIBLE: {
                        hcVerifier = SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
                        break;
                    }
                    case ALLOW_ALL: {
                        hcVerifier = SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
                        break;
                    }
                    default: {
                        hcVerifier = SSLSocketFactory.STRICT_HOSTNAME_VERIFIER;
                    }
                }
                Scheme s = this.httpclient.getConnectionManager().getSchemeRegistry().getScheme("https");
                SSLSocketFactory sslFac = (SSLSocketFactory)s.getSocketFactory();
                sslFac.setHostnameVerifier(hcVerifier);
                String trustStorePath = request.getSslTrustStore();
                char[] trustStorePassword = request.getSslTrustStorePassword();
                if (urlProtocol.equalsIgnoreCase("https") && !StringUtil.isStrEmpty((String)trustStorePath)) {
                    KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    if (!StringUtil.isStrEmpty((String)trustStorePath)) {
                        FileInputStream instream = new FileInputStream(new File(trustStorePath));
                        try {
                            trustStore.load(instream, trustStorePassword);
                        }
                        finally {
                            instream.close();
                        }
                    }
                    SSLSocketFactory socketFactory = new SSLSocketFactory(trustStore);
                    socketFactory.setHostnameVerifier(hcVerifier);
                    Scheme sch = new Scheme(urlProtocol, (SocketFactory)socketFactory, urlPort);
                    this.httpclient.getConnectionManager().getSchemeRegistry().register(sch);
                }
                this.httpclient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler());
                this.httpclient.setRedirectHandler((RedirectHandler)new DefaultRedirectHandler(){

                    public URI getLocationURI(HttpResponse response, HttpContext context) throws ProtocolException {
                        URI uri = super.getLocationURI(response, context);
                        LOG.log(Level.INFO, "Redirect response status: {0}", response.getStatusLine());
                        LOG.log(Level.INFO, "Redirect: {0}", uri);
                        return uri;
                    }
                });
                long startTime = System.currentTimeMillis();
                HttpResponse http_res = this.httpclient.execute((HttpUriRequest)method, (HttpContext)httpContext);
                long endTime = System.currentTimeMillis();
                response = new ResponseBean();
                response.setExecutionTime(endTime - startTime);
                response.setStatusCode(http_res.getStatusLine().getStatusCode());
                response.setStatusLine(http_res.getStatusLine().toString());
                Header[] responseHeaders = http_res.getAllHeaders();
                String contentType = null;
                for (Header header : responseHeaders) {
                    response.addHeader(header.getName(), header.getValue());
                    if (!header.getName().equalsIgnoreCase("content-type")) continue;
                    contentType = header.getValue();
                }
                if (contentType != null) {
                    String charsetStr = Util.getCharsetFromContentType(contentType);
                    try {
                        c = Charset.forName(charsetStr);
                    }
                    catch (IllegalCharsetNameException ex) {
                        LOG.log(Level.WARNING, "Charset name is illegal: {0}", charsetStr);
                        c = Charset.defaultCharset();
                    }
                    catch (UnsupportedCharsetException ex) {
                        LOG.log(Level.WARNING, "Charset {0} is not supported in this JVM.", charsetStr);
                        c = Charset.defaultCharset();
                    }
                    catch (IllegalArgumentException ex) {
                        LOG.log(Level.WARNING, "Charset parameter is not available in Content-Type header!");
                        c = Charset.defaultCharset();
                    }
                } else {
                    c = Charset.defaultCharset();
                    LOG.log(Level.WARNING, "Content-Type header not available in response. Using platform default encoding: {0}", c.name());
                }
                Charset charset = c;
                HttpEntity entity = http_res.getEntity();
                if (entity != null) {
                    InputStream is = entity.getContent();
                    try {
                        String responseBody = StreamUtil.inputStream2String((InputStream)is, (Charset)charset);
                        if (responseBody != null) {
                            response.setResponseBody(responseBody);
                        }
                    }
                    catch (IOException ex) {
                        String msg = "Response body conversion to string using " + charset.displayName() + " encoding failed. Response body not set!";
                        for (View view : views) {
                            view.doError(msg);
                        }
                        LOG.log(Level.WARNING, msg);
                    }
                }
                try {
                    TestSuite suite = TestUtil.getTestSuite(request, response);
                    if (suite == null) break block74;
                    TestResult testResult = TestUtil.execute(suite);
                    response.setTestResult(testResult);
                }
                catch (TestException ex) {
                    for (View view : views) {
                        view.doError(Util.getStackTrace(ex));
                    }
                }
            }
            for (View view : views) {
                view.doResponse(response);
            }
        }
        catch (IOException ex) {
            if (!this.interruptedShutdown) {
                for (View view : views) {
                    view.doError(Util.getStackTrace(ex));
                }
            } else {
                for (View view : views) {
                    view.doCancelled();
                }
            }
        }
        catch (Exception ex) {
            if (!this.interruptedShutdown) {
                for (View view : views) {
                    view.doError(Util.getStackTrace(ex));
                }
            } else {
                for (View view : views) {
                    view.doCancelled();
                }
            }
        }
        finally {
            if (method != null && !this.interruptedShutdown) {
                this.httpclient.getConnectionManager().shutdown();
            }
            for (View view : views) {
                view.doEnd();
            }
            this.isRequestCompleted = true;
        }
    }

    @Override
    public void abortExecution() {
        if (!this.isRequestCompleted) {
            ClientConnectionManager conMgr = this.httpclient.getConnectionManager();
            this.interruptedShutdown = true;
            conMgr.shutdown();
        } else {
            LOG.info("Request already completed. Doing nothing.");
        }
    }

    private static final class PreemptiveAuth
    implements HttpRequestInterceptor {
        private PreemptiveAuth() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                AuthScheme authScheme = (AuthScheme)context.getAttribute("preemptive-auth");
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
                if (authScheme != null) {
                    Credentials creds = credsProvider.getCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()));
                    if (creds == null) {
                        throw new HttpException("No credentials for preemptive authentication");
                    }
                    authState.setAuthScheme(authScheme);
                    authState.setCredentials(creds);
                }
            }
        }
    }
}

