/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient;

import org.wiztools.restclient.ReqEntity;
import org.wiztools.restclient.Util;

public final class ReqEntityBean
implements ReqEntity {
    private String contentType;
    private String charSet;
    private String body;

    public ReqEntityBean(String body, String contentType, String charSet) {
        this.body = body;
        this.contentType = contentType;
        this.charSet = charSet;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    @Override
    public String getCharSet() {
        return this.charSet;
    }

    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public String getContentTypeCharsetFormatted() {
        return Util.getFormattedContentType(this.contentType, this.charSet);
    }

    @Override
    public Object clone() {
        ReqEntityBean cloned = new ReqEntityBean(this.body, this.contentType, this.charSet);
        return cloned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ReqEntityBean) {
            ReqEntityBean bean = (ReqEntityBean)o;
            boolean isEqual = true;
            boolean bl = isEqual && (this.body == null ? bean.body == null : this.body.equals(bean.body)) ? true : (isEqual = false);
            boolean bl2 = isEqual && (this.charSet == null ? bean.charSet == null : this.charSet.equals(bean.charSet)) ? true : (isEqual = false);
            isEqual = isEqual && (this.contentType == null ? bean.contentType == null : this.contentType.equals(bean.contentType));
            return isEqual;
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + (this.contentType != null ? this.contentType.hashCode() : 0);
        hash = 29 * hash + (this.charSet != null ? this.charSet.hashCode() : 0);
        hash = 29 * hash + (this.body != null ? this.body.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("@RequestBody[");
        sb.append(this.contentType).append(", ");
        sb.append(this.charSet).append(", ");
        sb.append(this.body);
        sb.append("]");
        return sb.toString();
    }
}

