/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.wiztools.commons.CollectionsUtil;
import org.wiztools.commons.MultiValueMap;
import org.wiztools.commons.MultiValueMapArrayList;
import org.wiztools.restclient.HTTPAuthMethod;
import org.wiztools.restclient.HTTPMethod;
import org.wiztools.restclient.HTTPVersion;
import org.wiztools.restclient.ReqEntity;
import org.wiztools.restclient.ReqEntityBean;
import org.wiztools.restclient.Request;
import org.wiztools.restclient.SSLHostnameVerifier;

public final class RequestBean
implements Request {
    private URL url;
    private HTTPMethod method;
    private boolean authPreemptive;
    private List<HTTPAuthMethod> authMethods;
    private String authHost;
    private String authRealm;
    private String authUsername;
    private char[] authPassword;
    private MultiValueMap<String, String> headers;
    private ReqEntity body;
    private String testScript;
    private String sslTrustStore;
    private char[] sslTrustStorePassword;
    private SSLHostnameVerifier sslHostNameVerifier = SSLHostnameVerifier.STRICT;
    private HTTPVersion httpVersion = HTTPVersion.getDefault();

    @Override
    public HTTPVersion getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(HTTPVersion httpVersion) {
        this.httpVersion = httpVersion;
    }

    @Override
    public String getSslTrustStore() {
        return this.sslTrustStore;
    }

    public void setSslTrustStore(String sslKeyStore) {
        this.sslTrustStore = sslKeyStore;
    }

    @Override
    public char[] getSslTrustStorePassword() {
        return this.sslTrustStorePassword;
    }

    public void setSslTrustStorePassword(char[] sslKeyStorePassword) {
        this.sslTrustStorePassword = sslKeyStorePassword;
    }

    @Override
    public SSLHostnameVerifier getSslHostNameVerifier() {
        return this.sslHostNameVerifier;
    }

    public void setSslHostNameVerifier(SSLHostnameVerifier sslHostNameVerifier) {
        this.sslHostNameVerifier = sslHostNameVerifier;
    }

    @Override
    public String getTestScript() {
        return this.testScript;
    }

    public void setTestScript(String testScript) {
        this.testScript = testScript;
    }

    @Override
    public ReqEntity getBody() {
        return this.body;
    }

    public void setBody(ReqEntity body) {
        this.body = body;
    }

    @Override
    public boolean isAuthPreemptive() {
        return this.authPreemptive;
    }

    public void setAuthPreemptive(boolean authPreemptive) {
        this.authPreemptive = authPreemptive;
    }

    @Override
    public List<HTTPAuthMethod> getAuthMethods() {
        return Collections.unmodifiableList(this.authMethods);
    }

    public void addAuthMethod(HTTPAuthMethod authMethod) {
        this.authMethods.add(authMethod);
    }

    @Override
    public String getAuthHost() {
        return this.authHost;
    }

    public void setAuthHost(String authHost) {
        this.authHost = authHost;
    }

    @Override
    public char[] getAuthPassword() {
        return this.authPassword;
    }

    public void setAuthPassword(char[] authPassword) {
        this.authPassword = authPassword;
    }

    @Override
    public String getAuthRealm() {
        return this.authRealm;
    }

    public void setAuthRealm(String authRealm) {
        this.authRealm = authRealm;
    }

    @Override
    public String getAuthUsername() {
        return this.authUsername;
    }

    public void setAuthUsername(String authUsername) {
        this.authUsername = authUsername;
    }

    @Override
    public MultiValueMap<String, String> getHeaders() {
        return CollectionsUtil.unmodifiableMultiValueMap(this.headers);
    }

    public void addHeader(String key, String value) {
        this.headers.put((Object)key, (Object)value);
    }

    @Override
    public HTTPMethod getMethod() {
        return this.method;
    }

    public void setMethod(HTTPMethod method) {
        this.method = method;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public RequestBean() {
        this.headers = new MultiValueMapArrayList();
        this.authMethods = new ArrayList<HTTPAuthMethod>();
    }

    @Override
    public Object clone() {
        RequestBean cloned = new RequestBean();
        cloned.setAuthHost(this.authHost);
        cloned.setAuthPassword(this.authPassword);
        cloned.setAuthPreemptive(this.authPreemptive);
        cloned.setAuthRealm(this.authRealm);
        cloned.setAuthUsername(this.authUsername);
        cloned.setSslTrustStore(this.sslTrustStore);
        cloned.setSslTrustStorePassword(this.sslTrustStorePassword);
        cloned.setHttpVersion(this.httpVersion);
        if (this.body != null) {
            cloned.setBody((ReqEntityBean)this.body.clone());
        }
        if (this.headers.size() != 0) {
            for (String header : this.headers.keySet()) {
                for (String value : this.headers.get((Object)header)) {
                    cloned.addHeader(header, value);
                }
            }
        }
        cloned.setMethod(this.method);
        cloned.setTestScript(this.testScript);
        cloned.setUrl(this.url);
        return cloned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Request) {
            Request bean = (Request)o;
            boolean isEqual = true;
            boolean bl = isEqual && (this.method == null ? bean.getMethod() == null : this.method.equals((Object)bean.getMethod())) ? true : (isEqual = false);
            boolean bl2 = isEqual && (this.headers == null ? bean.getHeaders() == null : this.headers.equals(bean.getHeaders())) ? true : (isEqual = false);
            boolean bl3 = isEqual && (this.body == null ? bean.getBody() == null : this.body.equals(bean.getBody())) ? true : (isEqual = false);
            boolean bl4 = isEqual && (this.authHost == null ? bean.getAuthHost() == null : this.authHost.equals(bean.getAuthHost())) ? true : (isEqual = false);
            boolean bl5 = isEqual && (this.authMethods == null ? bean.getAuthMethods() == null : ((Object)this.authMethods).equals(bean.getAuthMethods())) ? true : (isEqual = false);
            isEqual = isEqual && (this.authPassword == null ? bean.getAuthPassword() == null : Arrays.equals(this.authPassword, bean.getAuthPassword()));
            boolean bl6 = isEqual = isEqual && this.authPreemptive == bean.isAuthPreemptive();
            boolean bl7 = isEqual && (this.authRealm == null ? bean.getAuthRealm() == null : this.authRealm.equals(bean.getAuthRealm())) ? true : (isEqual = false);
            boolean bl8 = isEqual && (this.authUsername == null ? bean.getAuthUsername() == null : this.authUsername.equals(bean.getAuthUsername())) ? true : (isEqual = false);
            boolean bl9 = isEqual && (this.sslTrustStore == null ? bean.getSslTrustStore() == null : this.sslTrustStore.equals(bean.getSslTrustStore())) ? true : (isEqual = false);
            boolean bl10 = isEqual && (this.sslTrustStorePassword == null ? bean.getSslTrustStorePassword() == null : Arrays.equals(this.sslTrustStorePassword, bean.getSslTrustStorePassword())) ? true : (isEqual = false);
            boolean bl11 = isEqual && (this.sslHostNameVerifier == null ? bean.getSslHostNameVerifier() == null : this.sslHostNameVerifier == bean.getSslHostNameVerifier()) ? true : (isEqual = false);
            boolean bl12 = isEqual && (this.httpVersion == null ? bean.getHttpVersion() == null : this.httpVersion == bean.getHttpVersion()) ? true : (isEqual = false);
            boolean bl13 = isEqual && (this.testScript == null ? bean.getTestScript() == null : this.testScript.equals(bean.getTestScript())) ? true : (isEqual = false);
            isEqual = isEqual && (this.url == null ? bean.getUrl() == null : this.url.equals(bean.getUrl()));
            return isEqual;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + (this.url != null ? this.url.hashCode() : 0);
        hash = 61 * hash + (this.method != null ? this.method.hashCode() : 0);
        hash = 61 * hash + (this.authPreemptive ? 1 : 0);
        hash = 61 * hash + (this.authMethods != null ? ((Object)this.authMethods).hashCode() : 0);
        hash = 61 * hash + (this.authHost != null ? this.authHost.hashCode() : 0);
        hash = 61 * hash + (this.authRealm != null ? this.authRealm.hashCode() : 0);
        hash = 61 * hash + (this.authUsername != null ? this.authUsername.hashCode() : 0);
        hash = 61 * hash + (this.authPassword != null ? this.authPassword.hashCode() : 0);
        hash = 61 * hash + (this.headers != null ? this.headers.hashCode() : 0);
        hash = 61 * hash + (this.body != null ? this.body.hashCode() : 0);
        hash = 61 * hash + (this.testScript != null ? this.testScript.hashCode() : 0);
        hash = 61 * hash + (this.sslTrustStore != null ? this.sslTrustStore.hashCode() : 0);
        hash = 61 * hash + (this.sslTrustStorePassword != null ? this.sslTrustStorePassword.hashCode() : 0);
        hash = 61 * hash + (this.sslHostNameVerifier != null ? this.sslHostNameVerifier.hashCode() : 0);
        hash = 61 * hash + (this.httpVersion != null ? this.httpVersion.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("@Request[");
        sb.append(this.url).append(", ");
        sb.append((Object)this.method).append(", ");
        sb.append(this.headers.toString()).append(", ");
        sb.append(this.body).append(", ");
        sb.append(this.authMethods).append(", ");
        sb.append(this.authPreemptive).append(", ");
        sb.append(this.authHost).append(", ");
        sb.append(this.authRealm).append(", ");
        sb.append(this.authUsername).append(", ");
        sb.append(this.authPassword == null ? "null" : new String(this.authPassword).replaceAll(".", "X")).append(", ");
        sb.append(this.sslTrustStore).append(", ");
        sb.append(this.sslTrustStorePassword == null ? "null" : new String(this.sslTrustStorePassword).replaceAll(".", "X")).append(", ");
        sb.append((Object)this.sslHostNameVerifier).append(", ");
        sb.append((Object)this.httpVersion).append(", ");
        sb.append(this.testScript);
        sb.append("]");
        return sb.toString();
    }
}

