/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.server;

import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.wiztools.restclient.server.TraceServlet;

public class TraceServer {
    private static final Logger LOG = Logger.getLogger(TraceServer.class.getName());
    public static final String SYS_PROPERTY_PORT = "rc:trace-server-port";
    public static final int DEFAULT_PORT = 10101;
    public static final int PORT;
    private static final Server server;

    public static synchronized void start() throws Exception {
        if (!server.isStarted() && !server.isRunning()) {
            server.start();
        }
    }

    public static boolean isRunning() {
        return server.isRunning() || server.isStarted();
    }

    public static synchronized void stop() throws Exception {
        server.stop();
    }

    static {
        int port = 0;
        try {
            String t = System.getProperty(SYS_PROPERTY_PORT);
            if (t != null) {
                int t_port = Integer.parseInt(t);
                if (t_port > 65535 || t_port < 0) {
                    LOG.warning("rc:trace-server-port is not in valid port range. Reverting to default:10101");
                    port = 10101;
                } else {
                    port = t_port;
                }
            } else {
                port = 10101;
            }
        }
        catch (NumberFormatException ex) {
            LOG.warning("rc:trace-server-port is not a number. Reverting to default: 10101");
            port = 10101;
        }
        PORT = port;
        server = new Server(PORT);
        Context root = new Context((HandlerContainer)server, "/", 1);
        root.addServlet(new ServletHolder((Servlet)new TraceServlet()), "/*");
        server.setStopAtShutdown(true);
    }
}

