/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.commons;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;

public class Event
implements Serializable {
    private String streamId;
    private long timeStamp;
    private Object[] metaData;
    private Object[] correlationData;
    private Object[] payloadData;
    private Map<String, String> arbitraryDataMap = null;

    public Event() {
    }

    public Event(String streamId, long timeStamp, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray) {
        this.streamId = streamId;
        this.timeStamp = timeStamp;
        this.metaData = metaDataArray;
        this.correlationData = correlationDataArray;
        this.payloadData = payloadDataArray;
    }

    public Event(String streamId, long timeStamp, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray, Map<String, String> arbitraryDataMap) {
        this(streamId, timeStamp, metaDataArray, correlationDataArray, payloadDataArray);
        this.arbitraryDataMap = arbitraryDataMap;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public Object[] getMetaData() {
        return this.metaData;
    }

    public void setMetaData(Object[] metaData) {
        this.metaData = metaData;
    }

    public Object[] getCorrelationData() {
        return this.correlationData;
    }

    public void setCorrelationData(Object[] correlationData) {
        this.correlationData = correlationData;
    }

    public Object[] getPayloadData() {
        return this.payloadData;
    }

    public void setPayloadData(Object[] payloadData) {
        this.payloadData = payloadData;
    }

    public Map<String, String> getArbitraryDataMap() {
        return this.arbitraryDataMap;
    }

    public void setArbitraryDataMap(Map<String, String> arbitraryDataMap) {
        this.arbitraryDataMap = arbitraryDataMap;
    }

    public void setData(String key, Object[] dataObjArray) {
        if (key.equals("metaData")) {
            this.metaData = dataObjArray;
        } else if (key.equals("correlationData")) {
            this.correlationData = dataObjArray;
        } else if (key.equals("payloadData")) {
            this.payloadData = dataObjArray;
        }
    }

    public String toString() {
        return "\nEvent{\n  streamId='" + this.streamId + "',\n  " + "timeStamp" + "=" + this.timeStamp + ",\n  " + "metaData" + "=" + (this.metaData == null ? null : Arrays.asList(this.metaData)) + ",\n  " + "correlationData" + "=" + (this.correlationData == null ? null : Arrays.asList(this.correlationData)) + ",\n  " + "payloadData" + "=" + (this.payloadData == null ? null : Arrays.asList(this.payloadData)) + ",\n  " + "arbitraryDataMap" + "=" + this.arbitraryDataMap + ",\n}\n";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event event = (Event)o;
        if (this.timeStamp != event.timeStamp) {
            return false;
        }
        if (this.arbitraryDataMap != null ? !this.arbitraryDataMap.equals(event.arbitraryDataMap) : event.arbitraryDataMap != null) {
            return false;
        }
        if (!Arrays.deepEquals(this.correlationData, event.correlationData)) {
            return false;
        }
        if (!Arrays.deepEquals(this.metaData, event.metaData)) {
            return false;
        }
        if (!Arrays.deepEquals(this.payloadData, event.payloadData)) {
            return false;
        }
        return !(this.streamId != null ? !this.streamId.equals(event.streamId) : event.streamId != null);
    }

    public int hashCode() {
        int result = this.streamId != null ? this.streamId.hashCode() : 0;
        result = 31 * result + (int)(this.timeStamp ^ this.timeStamp >>> 32);
        result = 31 * result + (this.metaData != null ? Arrays.hashCode(this.metaData) : 0);
        result = 31 * result + (this.correlationData != null ? Arrays.hashCode(this.correlationData) : 0);
        result = 31 * result + (this.payloadData != null ? Arrays.hashCode(this.payloadData) : 0);
        result = 31 * result + (this.arbitraryDataMap != null ? this.arbitraryDataMap.hashCode() : 0);
        return result;
    }
}

