/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.cache.Cache;
import javax.cache.CacheBuilder;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.OptionalFeature;
import javax.cache.Status;
import javax.transaction.UserTransaction;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.caching.impl.CacheBuilderImpl;
import org.wso2.carbon.caching.impl.CacheImpl;
import org.wso2.carbon.caching.impl.CacheManagerFactoryImpl;
import org.wso2.carbon.caching.impl.DataHolder;
import org.wso2.carbon.caching.impl.DistributedMapProvider;
import org.wso2.carbon.caching.impl.Util;
import org.wso2.carbon.context.CarbonContext;

public class CarbonCacheManager
implements CacheManager {
    private Map<String, Cache<?, ?>> caches = new ConcurrentHashMap();
    private volatile Status status;
    private String name;
    private String ownerTenantDomain;
    private int ownerTenantId;
    private CacheManagerFactoryImpl cacheManagerFactory;
    private long lastAccessed = -1L;

    public CarbonCacheManager(String name, CacheManagerFactoryImpl cacheManagerFactory) {
        this.cacheManagerFactory = cacheManagerFactory;
        CarbonContext carbonContext = CarbonContext.getThreadLocalCarbonContext();
        if (carbonContext == null) {
            throw new IllegalStateException("CarbonContext cannot be null");
        }
        this.ownerTenantDomain = carbonContext.getTenantDomain();
        if (this.ownerTenantDomain == null) {
            throw new IllegalStateException("Tenant domain cannot be " + this.ownerTenantDomain);
        }
        this.ownerTenantId = carbonContext.getTenantId();
        if (this.ownerTenantId == -1) {
            throw new IllegalStateException("Tenant ID cannot be " + this.ownerTenantId);
        }
        this.name = name;
        this.touch();
        this.status = Status.STARTED;
    }

    public int getOwnerTenantId() {
        return this.ownerTenantId;
    }

    @Override
    public String getName() {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        return this.name;
    }

    @Override
    public Status getStatus() {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        return this.status;
    }

    @Override
    public <K, V> CacheBuilder<K, V> createCacheBuilder(String cacheName) {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        if (cacheName == null) {
            throw new NullPointerException("A cache name must not be null.");
        }
        if (this.caches.get(cacheName = this.getCacheName(cacheName)) != null) {
            throw new CacheException("Cache " + cacheName + " already exists");
        }
        Pattern searchPattern = Pattern.compile("\\S+");
        Matcher matcher = searchPattern.matcher(cacheName);
        if (!matcher.find()) {
            throw new IllegalArgumentException("A cache name must contain one or more non-whitespace characters");
        }
        return new CacheBuilderImpl(cacheName, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> Cache<K, V> getCache(String cacheName) {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        if (this.status != Status.STARTED) {
            throw new IllegalStateException();
        }
        this.touch();
        cacheName = this.getCacheName(cacheName);
        Cache<?, ?> cache = this.caches.get(cacheName);
        if (cache == null) {
            String string = cacheName.intern();
            synchronized (string) {
                cache = this.caches.get(cacheName);
                if (cache == null) {
                    cache = new CacheImpl(cacheName, this);
                    this.caches.put(cacheName, cache);
                }
            }
        }
        return cache;
    }

    void switchToDistributedMode() {
        for (Cache<?, ?> cache : this.caches.values()) {
            ((CacheImpl)cache).switchToDistributedMode();
        }
    }

    final <K, V> Cache<K, V> getExistingCache(String cacheName) {
        this.touch();
        cacheName = this.getCacheName(cacheName);
        return this.caches.get(cacheName);
    }

    @Override
    public Iterable<Cache<?, ?>> getCaches() {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        if (this.status != Status.STARTED) {
            throw new IllegalStateException();
        }
        this.touch();
        HashSet set = new HashSet();
        for (Cache<?, ?> cache : this.caches.values()) {
            set.add(cache);
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public boolean removeCache(String cacheName) {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        if (this.status != Status.STARTED) {
            throw new IllegalStateException();
        }
        if (cacheName == null) {
            throw new NullPointerException("Cache name cannot be null");
        }
        CacheImpl oldCache = (CacheImpl)this.caches.remove(cacheName = this.getCacheName(cacheName));
        if (oldCache != null) {
            oldCache.stop();
        }
        this.cacheManagerFactory.removeCacheFromMonitoring(oldCache);
        DistributedMapProvider distributedMapProvider = DataHolder.getInstance().getDistributedMapProvider();
        if (distributedMapProvider != null) {
            distributedMapProvider.removeMap(Util.getDistributedMapNameOfCache(cacheName, this.ownerTenantDomain, this.getName()));
        }
        if (this.caches.isEmpty() && this.isIdle()) {
            this.cacheManagerFactory.removeCacheManager(this, this.ownerTenantDomain);
        }
        this.touch();
        return oldCache != null;
    }

    boolean removeLocalCaches() {
        for (Cache<?, ?> cache : this.caches.values()) {
            boolean isLocalCache = cache.getName().startsWith("$__local__$.");
            if (!isLocalCache) continue;
            this.removeCache(cache.getName());
        }
        return this.caches.isEmpty();
    }

    @Override
    public UserTransaction getUserTransaction() {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        this.touch();
        return null;
    }

    @Override
    public boolean isSupported(OptionalFeature optionalFeature) {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        return false;
    }

    @Override
    public void shutdown() {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        for (Cache<?, ?> cache : this.caches.values()) {
            try {
                cache.stop();
            }
            catch (Exception exception) {}
        }
        this.caches.clear();
        this.status = Status.STOPPED;
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        if (cls.isAssignableFrom(this.getClass())) {
            return cls.cast(this);
        }
        throw new IllegalArgumentException("Unwrapping to " + cls + " is not a supported by this implementation");
    }

    void addCache(CacheImpl cache) {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        String cacheName = cache.getName();
        cacheName = this.getCacheName(cacheName);
        this.caches.put(cacheName, cache);
        this.touch();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CarbonCacheManager that = (CarbonCacheManager)o;
        if (this.ownerTenantId != that.ownerTenantId) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.ownerTenantDomain != null ? !this.ownerTenantDomain.equals(that.ownerTenantDomain) : that.ownerTenantDomain != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.ownerTenantDomain != null ? this.ownerTenantDomain.hashCode() : 0);
        result = 31 * result + this.ownerTenantId;
        return result;
    }

    private void checkStatusStarted() {
        if (!this.status.equals((Object)Status.STARTED)) {
            throw new IllegalStateException("The cache status is not STARTED");
        }
    }

    private void touch() {
        this.lastAccessed = System.currentTimeMillis();
    }

    private boolean isIdle() {
        long timeDiff = System.currentTimeMillis() - this.lastAccessed;
        return this.caches.isEmpty() && timeDiff >= 900000L;
    }

    private String getCacheName(String cacheName) {
        if (Boolean.parseBoolean(ServerConfiguration.getInstance().getFirstProperty("Cache.ForceLocalCache")) && !cacheName.startsWith("$__local__$.")) {
            return "$__local__$." + cacheName;
        }
        return cacheName;
    }
}

