/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.impl.clustering;

import javax.cache.CacheEntryInfo;
import javax.cache.CacheInvalidationRequestSender;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.caching.impl.DataHolder;
import org.wso2.carbon.caching.impl.Util;
import org.wso2.carbon.caching.impl.clustering.ClusterCacheInvalidationRequest;

public class ClusterCacheInvalidationRequestSender
implements CacheEntryRemovedListener,
CacheEntryUpdatedListener,
CacheEntryCreatedListener,
CacheInvalidationRequestSender {
    private static final Log log = LogFactory.getLog(ClusterCacheInvalidationRequestSender.class);

    public void entryRemoved(CacheEntryEvent event) throws CacheEntryListenerException {
        this.send(Util.createCacheInfo(event));
    }

    public void entryUpdated(CacheEntryEvent event) throws CacheEntryListenerException {
        this.send(Util.createCacheInfo(event));
    }

    public void entryCreated(CacheEntryEvent event) throws CacheEntryListenerException {
    }

    private ClusteringAgent getClusteringAgent() {
        return DataHolder.getInstance().getClusteringAgent();
    }

    @Override
    public void send(CacheEntryInfo cacheEntryInfo) {
        String tenantDomain = cacheEntryInfo.getTenantDomain();
        int tenantId = cacheEntryInfo.getTenantId();
        if (-1 == tenantId) {
            if (log.isDebugEnabled()) {
                String stackTrace = ExceptionUtils.getStackTrace((Throwable)new Throwable());
                log.debug((Object)("Tenant information cannot be found in the request. This originated from: \n" + stackTrace));
            }
            return;
        }
        if (!cacheEntryInfo.getCacheName().startsWith("$__local__$.") || this.getClusteringAgent() == null) {
            return;
        }
        int numberOfRetries = 0;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending cache invalidation message to other cluster nodes for '" + cacheEntryInfo.getCacheKey() + "' of the cache '" + cacheEntryInfo.getCacheName() + "' of the cache manager '" + cacheEntryInfo.getCacheManagerName() + "'"));
        }
        ClusterCacheInvalidationRequest.CacheInfo cacheInfo = new ClusterCacheInvalidationRequest.CacheInfo(cacheEntryInfo.getCacheManagerName(), cacheEntryInfo.getCacheName(), cacheEntryInfo.getCacheKey());
        ClusterCacheInvalidationRequest clusterCacheInvalidationRequest = new ClusterCacheInvalidationRequest(cacheInfo, tenantDomain, tenantId);
        while (numberOfRetries < 60) {
            try {
                this.getClusteringAgent().sendMessage((ClusteringMessage)clusterCacheInvalidationRequest, true);
                log.debug((Object)("Sent [" + (Object)((Object)clusterCacheInvalidationRequest) + "]"));
                break;
            }
            catch (ClusteringFault e) {
                if (++numberOfRetries < 60) {
                    log.warn((Object)("Could not send CacheInvalidationMessage for tenant " + tenantId + ". Retry will be attempted in 2s. Request: " + (Object)((Object)clusterCacheInvalidationRequest)), (Throwable)e);
                } else {
                    log.error((Object)("Could not send CacheInvalidationMessage for tenant " + tenantId + ". Several retries failed. Request:" + (Object)((Object)clusterCacheInvalidationRequest)), (Throwable)e);
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

