/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.impl;

import java.io.Serializable;
import javax.cache.Cache;

public class CacheEntry<K, V>
implements Cache.Entry<K, V>,
Serializable {
    private static final long serialVersionUID = 1996179870860085427L;
    private K key;
    private V value;
    private long lastAccessed;
    private long lastModified;

    public CacheEntry(K key, V value) {
        long now;
        this.key = key;
        this.value = value;
        this.lastAccessed = now = System.currentTimeMillis();
        this.lastModified = now;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    public void setValue(V value) {
        this.lastModified = System.currentTimeMillis();
        this.value = value;
    }

    @Override
    public V getValue() {
        this.lastAccessed = System.currentTimeMillis();
        return this.value;
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastAccessed(Long lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheEntry that = (CacheEntry)o;
        return this.key.equals(that.key) && this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }
}

