/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.inbound.endpoint.inboundfactory.InboundRequestProcessorFactoryImpl;
import org.wso2.carbon.inbound.endpoint.internal.http.api.ConfigurationLoader;
import org.wso2.carbon.inbound.endpoint.persistence.InboundEndpointInfoDTO;
import org.wso2.carbon.inbound.endpoint.persistence.InboundEndpointsDataStore;
import org.wso2.carbon.inbound.endpoint.persistence.PersistenceUtils;
import org.wso2.carbon.inbound.endpoint.persistence.service.InboundEndpointPersistenceServiceDSComponent;
import org.wso2.carbon.inbound.endpoint.protocol.generic.GenericInboundListener;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.management.HL7EndpointManager;
import org.wso2.carbon.inbound.endpoint.protocol.http.management.HTTPEndpointManager;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.management.WebsocketEndpointManager;
import org.wso2.carbon.utils.ConfigurationContextService;

public class EndpointListenerLoader {
    private static Log log = LogFactory.getLog(EndpointListenerLoader.class);

    public static void loadListeners() {
        Map tenantData = InboundEndpointsDataStore.getInstance().getAllListeningEndpointData();
        for (Map.Entry tenantInfoEntry : tenantData.entrySet()) {
            InboundEndpointInfoDTO inboundEndpointInfoDTO = (InboundEndpointInfoDTO)((ArrayList)tenantInfoEntry.getValue()).get(0);
            int port = (Integer)tenantInfoEntry.getKey() + PersistenceUtils.getPortOffset((Properties)inboundEndpointInfoDTO.getInboundParams().getProperties());
            if (inboundEndpointInfoDTO.getProtocol().equals("http")) {
                HTTPEndpointManager.getInstance().startListener(port, inboundEndpointInfoDTO.getEndpointName(), inboundEndpointInfoDTO.getInboundParams());
                continue;
            }
            if (inboundEndpointInfoDTO.getProtocol().equals("https")) {
                HTTPEndpointManager.getInstance().startSSLListener(port, inboundEndpointInfoDTO.getEndpointName(), inboundEndpointInfoDTO.getSslConfiguration(), inboundEndpointInfoDTO.getInboundParams());
                continue;
            }
            if (inboundEndpointInfoDTO.getProtocol().equals(InboundRequestProcessorFactoryImpl.Protocols.ws.toString())) {
                WebsocketEndpointManager.getInstance().startListener(port, inboundEndpointInfoDTO.getEndpointName(), inboundEndpointInfoDTO.getInboundParams());
                continue;
            }
            if (inboundEndpointInfoDTO.getProtocol().equals(InboundRequestProcessorFactoryImpl.Protocols.wss.toString())) {
                WebsocketEndpointManager.getInstance().startSSLListener(port, inboundEndpointInfoDTO.getEndpointName(), inboundEndpointInfoDTO.getInboundParams());
                continue;
            }
            if (inboundEndpointInfoDTO.getProtocol().equals(InboundRequestProcessorFactoryImpl.Protocols.hl7.toString())) {
                HL7EndpointManager.getInstance().startListener(port, inboundEndpointInfoDTO.getEndpointName(), inboundEndpointInfoDTO.getInboundParams());
                continue;
            }
            InboundProcessorParams inboundParams = inboundEndpointInfoDTO.getInboundParams();
            if (!GenericInboundListener.isListeningInboundEndpoint(inboundParams)) continue;
            GenericInboundListener.getInstance(inboundParams).init();
        }
        EndpointListenerLoader.loadInternalInboundApis();
        Map mPollingEndpoints = InboundEndpointsDataStore.getInstance().getAllPollingingEndpointData();
        ConfigurationContextService configurationContext = InboundEndpointPersistenceServiceDSComponent.getConfigContextService();
        ConfigurationContext mainConfigCtx = configurationContext.getServerConfigContext();
        for (String tenantDomain : mPollingEndpoints.keySet()) {
            TenantAxisUtils.getTenantConfigurationContext((String)tenantDomain, (ConfigurationContext)mainConfigCtx);
        }
    }

    private static void loadInternalInboundApis() {
        HTTPEndpointManager manager = HTTPEndpointManager.getInstance();
        if (manager.isAnyInternalHttpApiEnabled()) {
            HTTPEndpointManager.getInstance().startListener(manager.getInternalInboundHttpPort(), "EI_INTERNAL_HTTP_INBOUND_ENDPOINT", null);
        }
        if (manager.isAnyInternalHttpsApiEnabled()) {
            if (ConfigurationLoader.isSslConfiguredSuccessfully()) {
                manager.startSSLListener(manager.getInternalInboundHttpsPort(), "EI_INTERNAL_HTTPS_INBOUND_ENDPOINT", ConfigurationLoader.getSslConfiguration(), null);
            } else {
                log.error((Object)"SSL is not configured for Internal apis. Hence Internal Apis will not be available via https.");
            }
        }
    }
}

