/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.common;

import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.task.Task;
import org.wso2.carbon.inbound.endpoint.common.PinnedPollingTask;

public abstract class InboundTask
implements Task,
ManagedLifecycle,
PinnedPollingTask {
    private static final Log logger = LogFactory.getLog((String)InboundTask.class.getName());
    protected long interval;
    public static final int TASK_THRESHOLD_INTERVAL = 1000;

    public void execute() {
        logger.debug((Object)"Common Inbound Task executing.");
        if (this.interval >= 1000L) {
            this.taskExecute();
        } else {
            long lStartTime;
            long lCurrentTime = lStartTime = new Date().getTime();
            while (lCurrentTime - lStartTime < 1000L) {
                this.taskExecute();
                long lEndTime = new Date().getTime();
                long lRequiredSleep = this.interval - (lEndTime - lCurrentTime);
                if (lRequiredSleep > 0L) {
                    try {
                        Thread.sleep(lRequiredSleep);
                    }
                    catch (InterruptedException e) {
                        logger.debug((Object)"Unable to sleep the inbound thread less than 1 second");
                    }
                }
                lCurrentTime = new Date().getTime();
            }
        }
    }

    protected abstract void taskExecute();

    @Override
    public abstract Properties getInboundProperties();
}

