/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.hl7.util;

import ca.uhn.hl7v2.AcknowledgmentCode;
import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.v22.message.ACK;
import ca.uhn.hl7v2.parser.DefaultXMLParser;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.parser.XMLParser;
import ca.uhn.hl7v2.util.idgenerator.IDGenerator;
import ca.uhn.hl7v2.util.idgenerator.UUIDGenerator;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.impl.DefaultValidation;
import ca.uhn.hl7v2.validation.impl.NoValidation;
import java.io.IOException;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.dom.factory.OMDOMFactory;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.axis2.MessageContextCreatorForAxis2;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.inbound.endpoint.osgi.service.ServiceReferenceHolder;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.core.MLLProtocolException;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.util.HL7Configuration;

public class HL7MessageUtils {
    private static final Log log = LogFactory.getLog(HL7MessageUtils.class);
    private static HapiContext validationContext = new DefaultHapiContext();
    private static HapiContext noValidationContext = new DefaultHapiContext();
    private static ConfigurationContext context;
    private static PipeParser noValidationPipeParser;
    private static XMLParser noValidationXmlParser;
    private static PipeParser pipeParser;
    private static XMLParser xmlParser;
    private static SOAPFactory fac;
    private static OMNamespace ns;
    private static OMFactory omFactory;

    public static Message parse(String msg, boolean validate) throws HL7Exception {
        if (validate) {
            return pipeParser.parse(msg);
        }
        return noValidationPipeParser.parse(msg);
    }

    public static Message parse(String msg, Parser preProcessor) throws HL7Exception {
        return preProcessor.parse(msg);
    }

    public static org.apache.synapse.MessageContext createSynapseMessageContext(Message message, InboundProcessorParams params) throws HL7Exception, AxisFault {
        org.apache.synapse.MessageContext synCtx = HL7MessageUtils.createSynapseMessageContext(params.getProperties().getProperty("HL7_INBOUND_TENANT_DOMAIN"));
        if (params.getProperties().getProperty("HL7_VALIDATION_PASSED") != null) {
            synCtx.setProperty("HL7_VALIDATION_PASSED", (Object)params.getProperties().getProperty("HL7_VALIDATION_PASSED"));
        }
        try {
            synCtx.setEnvelope(HL7MessageUtils.createEnvelope(synCtx, message, params));
        }
        catch (Exception e) {
            throw new HL7Exception((Throwable)e);
        }
        return synCtx;
    }

    public static org.apache.synapse.MessageContext createErrorMessageContext(String rawMessage, Exception errorMsg, InboundProcessorParams params) throws AxisFault, HL7Exception {
        org.apache.synapse.MessageContext synCtx = HL7MessageUtils.createSynapseMessageContext(params.getProperties().getProperty("HL7_INBOUND_TENANT_DOMAIN"));
        if (params.getProperties().getProperty("HL7_VALIDATION_PASSED") != null) {
            synCtx.setProperty("HL7_VALIDATION_PASSED", (Object)params.getProperties().getProperty("HL7_VALIDATION_PASSED"));
        }
        try {
            synCtx.setProperty("ERROR_CODE", (Object)101001);
            synCtx.setProperty("ERROR_MESSAGE", (Object)errorMsg.getMessage());
            synCtx.setProperty("ERROR_DETAIL", (Object)(errorMsg.getCause() == null ? "null" : errorMsg.getCause().getMessage()));
            synCtx.setProperty("ERROR_EXCEPTION", (Object)errorMsg);
            synCtx.setEnvelope(HL7MessageUtils.createErrorEnvelope(synCtx, rawMessage, errorMsg.getMessage(), params));
        }
        catch (Exception e) {
            throw new HL7Exception((Throwable)e);
        }
        return synCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static org.apache.synapse.MessageContext createSynapseMessageContext(String tenantDomain) throws AxisFault {
        MessageContext axis2MsgCtx = HL7MessageUtils.createAxis2MessageContext();
        ServiceContext svcCtx = new ServiceContext();
        OperationContext opCtx = new OperationContext((AxisOperation)new InOutAxisOperation(), svcCtx);
        axis2MsgCtx.setServiceContext(svcCtx);
        axis2MsgCtx.setOperationContext(opCtx);
        if (!tenantDomain.equals("carbon.super")) {
            ConfigurationContext tenantConfigCtx = null;
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                privilegedCarbonContext.setTenantDomain(tenantDomain, true);
                tenantConfigCtx = TenantAxisUtils.getTenantConfigurationContext((String)tenantDomain, (ConfigurationContext)axis2MsgCtx.getConfigurationContext());
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
            axis2MsgCtx.setConfigurationContext(tenantConfigCtx);
            axis2MsgCtx.setProperty("tenantDomain", (Object)tenantDomain);
        }
        return MessageContextCreatorForAxis2.getSynapseMessageContext((MessageContext)axis2MsgCtx);
    }

    private static MessageContext createAxis2MessageContext() {
        MessageContext axis2MsgCtx = new MessageContext();
        axis2MsgCtx.setMessageID(UIDGenerator.generateURNString());
        axis2MsgCtx.setConfigurationContext(ServiceReferenceHolder.getInstance().getConfigurationContextService().getServerConfigContext());
        axis2MsgCtx.setProperty("ClientApiNonBlocking", (Object)Boolean.FALSE);
        axis2MsgCtx.setServerSide(true);
        return axis2MsgCtx;
    }

    private static String getTenantDomain() {
        return PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
    }

    private static SOAPEnvelope createEnvelope(org.apache.synapse.MessageContext synCtx, Message message, InboundProcessorParams params) throws HL7Exception, XMLStreamException, MLLProtocolException {
        SOAPEnvelope envelope = fac.getDefaultEnvelope();
        boolean rawMessage = false;
        String xmlDoc = "";
        try {
            xmlDoc = xmlParser.encode(message);
            synCtx.setProperty("HL7_VALIDATION_PASSED", (Object)new Boolean(true));
        }
        catch (HL7Exception e) {
            synCtx.setProperty("HL7_VALIDATION_PASSED", (Object)new Boolean(false));
            if (params.getProperties().getProperty("inbound.hl7.BuildInvalidMessages") != null && params.getProperties().getProperty("inbound.hl7.BuildInvalidMessages").equals("true")) {
                xmlDoc = message.encode();
                rawMessage = true;
            }
            log.error((Object)"Could not encode HL7 message into XML. Set inbound.hl7.BuildInvalidMessages to build invalid HL7 messages containing raw HL7 message.", (Throwable)e);
            throw new HL7Exception("Could not encode HL7 message into XML", (Throwable)e);
        }
        OMElement messageEl = !rawMessage ? HL7MessageUtils.generateHL7MessageElement(xmlDoc) : HL7MessageUtils.generateHL7RawMessaegElement(xmlDoc);
        envelope.getBody().addChild((OMNode)messageEl);
        return envelope;
    }

    private static SOAPEnvelope createErrorEnvelope(org.apache.synapse.MessageContext synCtx, String rawMsg, String erroMsg, InboundProcessorParams params) {
        SOAPEnvelope envelope = fac.getDefaultEnvelope();
        boolean rawMessage = false;
        if (params.getProperties().getProperty("inbound.hl7.BuildInvalidMessages") != null && params.getProperties().getProperty("inbound.hl7.BuildInvalidMessages").equals("true")) {
            rawMessage = true;
        }
        if (rawMessage) {
            OMElement messageEl = HL7MessageUtils.generateHL7RawMessaegElement(rawMsg);
            envelope.getBody().addChild((OMNode)messageEl);
        }
        return envelope;
    }

    public static OMElement generateHL7MessageElement(String hl7XmlMessage) throws XMLStreamException {
        OMElement hl7Element = AXIOMUtil.stringToOM((String)hl7XmlMessage);
        OMElement messageEl = fac.createOMElement("message", ns);
        messageEl.addChild((OMNode)hl7Element);
        return messageEl;
    }

    public static OMElement generateHL7RawMessaegElement(String hl7XmlMessage) {
        OMElement hl7Element = omFactory.createOMElement(new QName("rawMessage"));
        OMText rawMessage = hl7Element.getOMFactory().createOMText((OMContainer)hl7Element, hl7XmlMessage, 12);
        hl7Element.addChild((OMNode)rawMessage);
        OMElement messageEl = fac.createOMElement("message", ns);
        messageEl.addChild((OMNode)hl7Element);
        return messageEl;
    }

    public static Message createNack(Message hl7Msg, String errorMsg) throws HL7Exception {
        if (errorMsg == null) {
            errorMsg = "";
        }
        if (hl7Msg == null) {
            return HL7MessageUtils.createDefaultNackMessage(errorMsg);
        }
        try {
            return hl7Msg.generateACK(AcknowledgmentCode.AE, new HL7Exception(errorMsg));
        }
        catch (IOException e) {
            throw new HL7Exception((Throwable)e);
        }
    }

    public static Message createDefaultNack(String errorMsg) {
        try {
            return HL7MessageUtils.createDefaultNackMessage(errorMsg);
        }
        catch (DataTypeException e) {
            log.error((Object)"Error while creating default NACK message.", (Throwable)e);
            return null;
        }
    }

    private static Message createDefaultNackMessage(String errorMsg) throws DataTypeException {
        ACK ack = new ACK();
        ack.getMSH().getFieldSeparator().setValue("|");
        ack.getMSH().getEncodingCharacters().setValue("^~\\&");
        ack.getMSH().getReceivingApplication().setValue(" ");
        ack.getMSH().getReceivingFacility().setValue(" ");
        ack.getMSH().getProcessingID().setValue("P");
        ack.getMSA().getAcknowledgementCode().setValue("AR");
        ack.getMSA().getMessageControlID().setValue("123456789");
        ack.getERR().getErrorCodeAndLocation(0).getCodeIdentifyingError().getIdentifier().setValue(errorMsg);
        return ack;
    }

    public static int getInt(String key, InboundProcessorParams params) throws NumberFormatException {
        return Integer.valueOf(params.getProperties().getProperty(key));
    }

    public static boolean getBoolean(String key, InboundProcessorParams params) {
        return Boolean.valueOf(params.getProperties().getProperty(key));
    }

    public static Message payloadToHL7Message(org.apache.synapse.MessageContext ctx, InboundProcessorParams params) throws HL7Exception, NoSuchElementException {
        OMElement hl7MsgEl = (OMElement)ctx.getEnvelope().getBody().getChildrenWithName(new QName("http://wso2.org/hl7", "message")).next();
        String hl7XMLPayload = hl7MsgEl.getFirstElement().toString();
        Message msg = null;
        try {
            msg = xmlParser.parse(hl7XMLPayload);
            String pipeMsg = pipeParser.encode(msg);
            msg = pipeParser.parse(pipeMsg);
            return msg;
        }
        catch (EncodingNotSupportedException e) {
            log.error((Object)"Encoding error in the message", (Throwable)e);
            throw new HL7Exception("Encoding error in the message: " + e.getMessage(), (Throwable)e);
        }
        catch (DataTypeException e) {
            log.warn((Object)"Rule validation fails.", (Throwable)e);
            if (!params.getProperties().getProperty("transport.hl7.ValidateMessage").equals("false")) {
                msg = noValidationXmlParser.parse(hl7XMLPayload);
                return msg;
            }
        }
        catch (HL7Exception e) {
            log.error((Object)"Error in the Message :", (Throwable)e);
            throw new HL7Exception("Encoding error in the message: " + e.getMessage(), (Throwable)e);
        }
        return msg;
    }

    static {
        noValidationContext.setValidationContext((ValidationContext)new NoValidation());
        validationContext.setValidationContext((ValidationContext)new DefaultValidation());
        noValidationPipeParser = new PipeParser(noValidationContext);
        noValidationXmlParser = new DefaultXMLParser(noValidationContext);
        pipeParser = new PipeParser(validationContext);
        xmlParser = new DefaultXMLParser(validationContext);
        fac = OMAbstractFactory.getSOAP11Factory();
        ns = fac.createOMNamespace("http://wso2.org/hl7", "hl7");
        omFactory = new OMDOMFactory();
        if (HL7Configuration.getInstance().getStringProperty("hl7_id_generator", "file").equals("uuid")) {
            validationContext.getParserConfiguration().setIdGenerator((IDGenerator)new UUIDGenerator());
            noValidationContext.getParserConfiguration().setIdGenerator((IDGenerator)new UUIDGenerator());
        }
    }
}

