/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.http;

public class InboundHttpConfiguration {
    private final int port;
    private final String name;
    private final String coreSize;
    private final String maxSize;
    private final String keepAlive;
    private final String queueLength;
    private final String threadGroup;
    private final String threadID;
    private final String dispatchPattern;

    private InboundHttpConfiguration(InboundHttpConfigurationBuilder builder) {
        this.port = builder.port;
        this.name = builder.name;
        this.coreSize = builder.coreSize;
        this.maxSize = builder.maxSize;
        this.keepAlive = builder.keepAlive;
        this.queueLength = builder.queueLength;
        this.threadGroup = builder.threadGroup;
        this.threadID = builder.threadID;
        this.dispatchPattern = builder.dispatchPattern;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.getName();
    }

    public String getCoresize() {
        return this.coreSize;
    }

    public String getMaxSize() {
        return this.maxSize;
    }

    public String getKeepAlive() {
        return this.keepAlive;
    }

    public String getQueueLength() {
        return this.queueLength;
    }

    public String getThreadGroup() {
        return this.threadGroup;
    }

    public String getThreadID() {
        return this.threadID;
    }

    public String getDispatchPattern() {
        return this.dispatchPattern;
    }

    public static class InboundHttpConfigurationBuilder {
        private final int port;
        private final String name;
        private String coreSize;
        private String maxSize;
        private String keepAlive;
        private String queueLength;
        private String threadGroup;
        private String threadID;
        private String dispatchPattern;

        public InboundHttpConfigurationBuilder(int port, String name) {
            this.port = port;
            this.name = name;
        }

        public InboundHttpConfiguration build() {
            return new InboundHttpConfiguration(this);
        }

        public InboundHttpConfigurationBuilder workerPoolCoreSize(String coreSize) {
            this.coreSize = coreSize;
            return this;
        }

        public InboundHttpConfigurationBuilder workerPoolMaxSize(String maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public InboundHttpConfigurationBuilder workerPoolKeepAlive(String keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        public InboundHttpConfigurationBuilder workerPoolQueueLength(String queueLength) {
            this.queueLength = queueLength;
            return this;
        }

        public InboundHttpConfigurationBuilder workerPoolThreadGroup(String threadGroup) {
            this.threadGroup = threadGroup;
            return this;
        }

        public InboundHttpConfigurationBuilder workerPoolThreadId(String threadID) {
            this.threadID = threadID;
            return this;
        }

        public InboundHttpConfigurationBuilder dispatchPattern(String dispatchPattern) {
            this.dispatchPattern = dispatchPattern;
            return this;
        }
    }
}

