/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.httpwebsocket;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.apache.synapse.inbound.InboundRequestProcessor;
import org.wso2.carbon.inbound.endpoint.protocol.httpwebsocket.management.HttpWebsocketEndpointManager;

public class InboundHttpWebsocketListener
implements InboundRequestProcessor {
    private static final Log LOGGER = LogFactory.getLog(InboundHttpWebsocketListener.class);
    protected final String name;
    protected int port;
    protected InboundProcessorParams processorParams;

    public InboundHttpWebsocketListener(InboundProcessorParams params) {
        this.processorParams = params;
        String portParam = params.getProperties().getProperty("port");
        try {
            this.port = Integer.parseInt(portParam);
        }
        catch (NumberFormatException e) {
            this.handleException("Validation failed for the port parameter " + portParam, e);
        }
        this.name = params.getName();
    }

    public void init() {
        HttpWebsocketEndpointManager.getInstance().startEndpoint(this.port, this.name, this.processorParams);
    }

    public void destroy() {
        HttpWebsocketEndpointManager.getInstance().closeEndpoint(this.port);
    }

    protected void handleException(String msg, Exception e) {
        LOGGER.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, (Throwable)e);
    }
}

