/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.jms;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataSource;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.builder.SOAPBuilder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.format.DataSourceMessageBuilder;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.inbound.InboundEndpoint;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.transport.customlogsetter.CustomLogSetter;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.inbound.endpoint.protocol.jms.BytesMessageDataSource;
import org.wso2.carbon.inbound.endpoint.protocol.jms.BytesMessageInputStream;
import org.wso2.carbon.inbound.endpoint.protocol.jms.JMSConstants;
import org.wso2.carbon.inbound.endpoint.protocol.jms.JMSReplySender;
import org.wso2.carbon.inbound.endpoint.protocol.jms.JMSUtils;
import org.wso2.carbon.inbound.endpoint.protocol.jms.factory.CachedJMSConnectionFactory;

public class JMSInjectHandler {
    private static final Log log = LogFactory.getLog(JMSInjectHandler.class);
    private String injectingSeq;
    private String onErrorSeq;
    private boolean sequential;
    private SynapseEnvironment synapseEnvironment;
    private Properties jmsProperties;
    private Connection connection;
    private Destination replyDestination;

    public JMSInjectHandler(String injectingSeq, String onErrorSeq, boolean sequential, SynapseEnvironment synapseEnvironment, Properties jmsProperties) {
        this.injectingSeq = injectingSeq;
        this.onErrorSeq = onErrorSeq;
        this.sequential = sequential;
        this.synapseEnvironment = synapseEnvironment;
        this.jmsProperties = jmsProperties;
    }

    public boolean invoke(Object object, String name) throws SynapseException {
        Message msg = (Message)object;
        try {
            SequenceMediator faultSequence;
            OMElement documentElement;
            InboundEndpoint inboundEndpoint;
            org.apache.synapse.MessageContext msgCtx;
            block36: {
                SOAPBuilder builder;
                JMSReplySender jmsReplySender;
                String strPassword;
                String strUserName;
                CachedJMSConnectionFactory cachedJMSConnectionFactory;
                String jmsType;
                msgCtx = this.createMessageContext();
                msgCtx.setProperty("inbound.endpoint.name", (Object)name);
                msgCtx.setProperty("ARTIFACT_NAME", (Object)("inboundendpoint" + name));
                msgCtx.setProperty("isInbound", (Object)true);
                inboundEndpoint = msgCtx.getConfiguration().getInboundEndpoint(name);
                Map parametersMap = inboundEndpoint.getParametersMap();
                for (Map.Entry entry : parametersMap.entrySet()) {
                    msgCtx.setProperty((String)entry.getKey(), entry.getValue());
                }
                CustomLogSetter.getInstance().setLogAppender(inboundEndpoint.getArtifactContainerName());
                String contentType = null;
                String contentTypeProperty = this.jmsProperties.getProperty(JMSConstants.CONTENT_TYPE_PROPERTY);
                if (contentTypeProperty != null) {
                    contentType = msg.getStringProperty(contentTypeProperty);
                }
                if (contentType == null || contentType.trim().isEmpty()) {
                    contentType = this.jmsProperties.getProperty(JMSConstants.CONTENT_TYPE);
                }
                if (contentType == null && (jmsType = msg.getJMSType()) != null && !jmsType.trim().isEmpty()) {
                    contentType = jmsType;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Processed JMS Message of Content-type : " + contentType));
                }
                MessageContext axis2MsgCtx = ((Axis2MessageContext)msgCtx).getAxis2MessageContext();
                String hyphenSupport = "none";
                if (inboundEndpoint.getParameter("transport.jms.MessagePropertyHyphens") != null) {
                    hyphenSupport = inboundEndpoint.getParameter("transport.jms.MessagePropertyHyphens");
                }
                axis2MsgCtx.setProperty("transport.jms.MessagePropertyHyphens", (Object)hyphenSupport);
                Map<String, Object> transportHeaders = JMSUtils.getTransportHeaders(msg, axis2MsgCtx);
                transportHeaders.put("JMS_TIMESTAMP", msg.getJMSTimestamp());
                transportHeaders.put("JMS_MESSAGE_ID", msg.getJMSMessageID());
                transportHeaders.put("JMS_PRIORITY", msg.getJMSPriority());
                transportHeaders.put("JMS_EXPIRATION", msg.getJMSExpiration());
                transportHeaders.put("JMS_DELIVERY_MODE", msg.getJMSDeliveryMode());
                transportHeaders.put("JMS_REDELIVERED", msg.getJMSRedelivered());
                transportHeaders.put("JMS_MESSAGE_TYPE", msg.getJMSType());
                transportHeaders.put("JMS_COORELATION_ID", msg.getJMSCorrelationID());
                axis2MsgCtx.setProperty("TRANSPORT_HEADERS", transportHeaders);
                try {
                    msgCtx.setMessageID(msg.getJMSMessageID());
                    String jmsCorrelationID = msg.getJMSCorrelationID();
                    if (jmsCorrelationID != null && !jmsCorrelationID.isEmpty()) {
                        msgCtx.setProperty("JMS_COORELATION_ID", (Object)jmsCorrelationID);
                    } else {
                        msgCtx.setProperty("JMS_COORELATION_ID", (Object)msg.getJMSMessageID());
                    }
                }
                catch (JMSException ignore) {
                    log.warn((Object)"Error getting the COORELATION ID from the message.");
                }
                Destination replyTo = msg.getJMSReplyTo();
                if (replyTo != null) {
                    cachedJMSConnectionFactory = new CachedJMSConnectionFactory(this.jmsProperties, this.connection);
                    strUserName = this.jmsProperties.getProperty("transport.jms.UserName");
                    strPassword = this.jmsProperties.getProperty("transport.jms.Password");
                    jmsReplySender = new JMSReplySender(replyTo, cachedJMSConnectionFactory, strUserName, strPassword);
                    msgCtx.setProperty("inbound-response-worker", (Object)jmsReplySender);
                } else if (this.replyDestination != null) {
                    cachedJMSConnectionFactory = new CachedJMSConnectionFactory(this.jmsProperties, this.connection);
                    strUserName = this.jmsProperties.getProperty("transport.jms.UserName");
                    strPassword = this.jmsProperties.getProperty("transport.jms.Password");
                    jmsReplySender = new JMSReplySender(this.replyDestination, cachedJMSConnectionFactory, strUserName, strPassword);
                    msgCtx.setProperty("inbound-response-worker", (Object)jmsReplySender);
                }
                if (contentType == null) {
                    log.debug((Object)"No content type specified. Using SOAP builder.");
                    builder = new SOAPBuilder();
                } else {
                    int index = contentType.indexOf(59);
                    String type = index > 0 ? contentType.substring(0, index) : contentType;
                    builder = BuilderUtil.getBuilderFromSelector((String)type, (MessageContext)axis2MsgCtx);
                    if (builder == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("No message builder found for type '" + type + "'. Falling back to SOAP."));
                        }
                        builder = new SOAPBuilder();
                    }
                }
                documentElement = null;
                try {
                    if (msg instanceof TextMessage) {
                        String message = ((TextMessage)msg).getText();
                        AutoCloseInputStream in = new AutoCloseInputStream((InputStream)new ByteArrayInputStream(message.getBytes()));
                        documentElement = builder.processDocument((InputStream)in, contentType, axis2MsgCtx);
                    } else if (msg instanceof BytesMessage) {
                        documentElement = builder instanceof DataSourceMessageBuilder ? ((DataSourceMessageBuilder)builder).processDocument((DataSource)new BytesMessageDataSource((BytesMessage)msg), contentType, axis2MsgCtx) : builder.processDocument((InputStream)new BytesMessageInputStream((BytesMessage)msg), contentType, axis2MsgCtx);
                    } else if (msg instanceof MapMessage) {
                        documentElement = JMSInjectHandler.convertJMSMapToXML((MapMessage)msg);
                    }
                }
                catch (Exception ex) {
                    log.error((Object)"Error while building the message", (Throwable)ex);
                    msgCtx.setProperty("ERROR_CODE", (Object)600001);
                    msgCtx.setProperty("ERROR_MESSAGE", (Object)ex.getMessage());
                    faultSequence = this.getFaultSequence(msgCtx, inboundEndpoint);
                    faultSequence.mediate(msgCtx);
                    return !this.isRollback(msgCtx) && !this.isToRecover(msgCtx);
                }
                try {
                    int deliveryCount = msg.getIntProperty("JMSXDeliveryCount");
                    msgCtx.setProperty("jms.message.delivery.count", (Object)deliveryCount);
                }
                catch (NumberFormatException nfe) {
                    if (!log.isDebugEnabled()) break block36;
                    log.debug((Object)"JMSXDeliveryCount is not set in the received message");
                }
            }
            msgCtx.setEnvelope(TransportUtils.createSOAPEnvelope((OMElement)documentElement));
            if (this.injectingSeq == null || this.injectingSeq.equals("")) {
                log.error((Object)("Sequence name not specified. Sequence : " + this.injectingSeq));
                return false;
            }
            SequenceMediator seq = (SequenceMediator)this.synapseEnvironment.getSynapseConfiguration().getSequence(this.injectingSeq);
            if (seq != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("injecting message to sequence : " + this.injectingSeq));
                }
                if (!seq.isInitialized()) {
                    seq.init(this.synapseEnvironment);
                }
                faultSequence = this.getFaultSequence(msgCtx, inboundEndpoint);
                MediatorFaultHandler mediatorFaultHandler = new MediatorFaultHandler((Mediator)faultSequence);
                msgCtx.pushFaultHandler((FaultHandler)mediatorFaultHandler);
                if (!this.synapseEnvironment.injectInbound(msgCtx, seq, this.sequential)) {
                    return false;
                }
            } else {
                log.error((Object)("Sequence: " + this.injectingSeq + " not found"));
            }
            if (this.isRollback(msgCtx) || this.isToRecover(msgCtx)) {
                return false;
            }
        }
        catch (SynapseException se) {
            throw se;
        }
        catch (Exception e) {
            log.error((Object)"Error while processing the JMS Message", (Throwable)e);
            throw new SynapseException("Error while processing the JMS Message", (Throwable)e);
        }
        return true;
    }

    private boolean isRollback(org.apache.synapse.MessageContext msgCtx) {
        return JMSUtils.checkIfBooleanPropertyIsSet("SET_ROLLBACK_ONLY", msgCtx);
    }

    private boolean isToRecover(org.apache.synapse.MessageContext msgCtx) {
        return JMSUtils.checkIfBooleanPropertyIsSet("SET_RECOVER", msgCtx);
    }

    public static OMElement convertJMSMapToXML(MapMessage message) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace jmsMapNS = OMAbstractFactory.getOMFactory().createOMNamespace("http://axis.apache.org/axis2/java/transports/jms/map-payload", "");
        OMElement jmsMap = fac.createOMElement("JMSMap", jmsMapNS);
        try {
            Enumeration names = message.getMapNames();
            while (names.hasMoreElements()) {
                String nextName = names.nextElement().toString();
                String nextVal = message.getString(nextName);
                OMElement next = fac.createOMElement(nextName.replace(" ", ""), jmsMapNS);
                next.setText(nextVal);
                jmsMap.addChild((OMNode)next);
            }
        }
        catch (JMSException e) {
            log.error((Object)("Error while processing the JMS Map Message. " + e.getMessage()));
        }
        return jmsMap;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setReplyDestination(Destination replyDestination) {
        this.replyDestination = replyDestination;
    }

    private org.apache.synapse.MessageContext createMessageContext() {
        org.apache.synapse.MessageContext msgCtx = this.synapseEnvironment.createMessageContext();
        msgCtx.setProperty("INBOUND_JMS_PROTOCOL", (Object)true);
        MessageContext axis2MsgCtx = ((Axis2MessageContext)msgCtx).getAxis2MessageContext();
        axis2MsgCtx.setServerSide(true);
        axis2MsgCtx.setMessageID(UUIDGenerator.getUUID());
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        axis2MsgCtx.setProperty("tenantDomain", (Object)carbonContext.getTenantDomain());
        msgCtx.setProperty("ClientApiNonBlocking", (Object)true);
        return msgCtx;
    }

    private SequenceMediator getFaultSequence(org.apache.synapse.MessageContext synCtx, InboundEndpoint endpoint) {
        SequenceMediator faultSequence = null;
        if (endpoint.getOnErrorSeq() != null) {
            faultSequence = (SequenceMediator)synCtx.getSequence(endpoint.getOnErrorSeq());
        }
        if (faultSequence == null) {
            faultSequence = (SequenceMediator)synCtx.getFaultSequence();
        }
        return faultSequence;
    }
}

