/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.jms;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.apache.synapse.inbound.InboundTaskProcessor;
import org.apache.synapse.task.TaskStartupObserver;
import org.wso2.carbon.inbound.endpoint.common.InboundRequestProcessorImpl;
import org.wso2.carbon.inbound.endpoint.protocol.jms.JMSInjectHandler;
import org.wso2.carbon.inbound.endpoint.protocol.jms.JMSPollingConsumer;
import org.wso2.carbon.inbound.endpoint.protocol.jms.JMSTask;

public class JMSProcessor
extends InboundRequestProcessorImpl
implements TaskStartupObserver,
InboundTaskProcessor {
    private static final Log log = LogFactory.getLog((String)JMSProcessor.class.getName());
    private static final String ENDPOINT_POSTFIX = "JMS--SYNAPSE_INBOUND_ENDPOINT";
    private List<JMSPollingConsumer> pollingConsumers = new ArrayList<JMSPollingConsumer>();
    private Properties jmsProperties;
    private boolean sequential;
    private String injectingSeq;
    private String onErrorSeq;
    private int concurrentConsumers;

    public JMSProcessor(InboundProcessorParams params) {
        this.name = params.getName();
        this.jmsProperties = params.getProperties();
        String inboundEndpointInterval = this.jmsProperties.getProperty("interval");
        if (inboundEndpointInterval != null) {
            try {
                this.interval = Long.parseLong(inboundEndpointInterval);
            }
            catch (NumberFormatException nfe) {
                throw new SynapseException("Invalid numeric value for interval.", (Throwable)nfe);
            }
        }
        this.sequential = true;
        String inboundEndpointSequential = this.jmsProperties.getProperty("sequential");
        if (inboundEndpointSequential != null) {
            this.sequential = Boolean.parseBoolean(inboundEndpointSequential);
        }
        this.coordination = true;
        String inboundCoordination = this.jmsProperties.getProperty("coordination");
        if (inboundCoordination != null) {
            this.coordination = Boolean.parseBoolean(inboundCoordination);
        }
        this.concurrentConsumers = 1;
        String concurrentConsumers = this.jmsProperties.getProperty("concurrent.consumers");
        if (concurrentConsumers != null) {
            if (Integer.parseInt(concurrentConsumers) == 0) {
                throw new SynapseException("Number of Concurrent Consumers should be Greater than 0");
            }
            this.concurrentConsumers = Integer.parseInt(concurrentConsumers);
        }
        this.injectingSeq = params.getInjectingSeq();
        this.onErrorSeq = params.getOnErrorSeq();
        this.synapseEnvironment = params.getSynapseEnvironment();
    }

    public void init() {
        log.info((Object)("Initializing inbound JMS listener for inbound endpoint " + this.name));
        for (int consumers = 0; consumers < this.concurrentConsumers; ++consumers) {
            JMSPollingConsumer jmsPollingConsumer = new JMSPollingConsumer(this.jmsProperties, this.interval, this.name);
            jmsPollingConsumer.registerHandler(new JMSInjectHandler(this.injectingSeq, this.onErrorSeq, this.sequential, this.synapseEnvironment, this.jmsProperties));
            this.pollingConsumers.add(jmsPollingConsumer);
            this.start(jmsPollingConsumer, consumers);
        }
    }

    @Override
    public void destroy() {
        for (JMSPollingConsumer pollingConsumer : this.pollingConsumers) {
            pollingConsumer.destroy();
        }
        super.destroy();
    }

    public void start(JMSPollingConsumer pollingConsumer, int consumer) {
        JMSTask task = new JMSTask(pollingConsumer, this.interval);
        this.start(task, ENDPOINT_POSTFIX + consumer);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void update() {
    }

    public void destroy(boolean removeTask) {
        if (removeTask) {
            this.destroy();
        }
    }
}

