/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.rabbitmq;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQException;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQUtils;

public class RabbitMQConnectionFactory {
    private static final Log log = LogFactory.getLog(RabbitMQConnectionFactory.class);
    private ConnectionFactory connectionFactory;
    private String name;
    private Map<String, String> parameters = new HashMap<String, String>();
    private int retryInterval;
    private int retryCount;
    private Address[] addresses;

    public RabbitMQConnectionFactory(Properties properties) throws RabbitMQException {
        this.name = properties.getProperty("rabbitmq.connection.factory");
        properties.stringPropertyNames().forEach(param -> this.parameters.put((String)param, properties.getProperty((String)param)));
        this.initConnectionFactory(this.parameters);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContent() {
        return this.parameters.get("rabbitmq.message.content.type");
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    private void initConnectionFactory(Map<String, String> parameters) throws RabbitMQException {
        String[] portArray;
        String hostnames = StringUtils.defaultIfEmpty((String)parameters.get("rabbitmq.server.host.name"), (String)"localhost");
        String ports = StringUtils.defaultIfEmpty((String)parameters.get("rabbitmq.server.port"), (String)String.valueOf(5672));
        String username = StringUtils.defaultIfEmpty((String)parameters.get("rabbitmq.server.user.name"), (String)"guest");
        String password = StringUtils.defaultIfEmpty((String)parameters.get("rabbitmq.server.password"), (String)"guest");
        String virtualHost = StringUtils.defaultIfEmpty((String)parameters.get("rabbitmq.server.virtual.host"), (String)"/");
        int heartbeat = NumberUtils.toInt((String)parameters.get("rabbitmq.factory.heartbeat"), (int)60);
        int connectionTimeout = NumberUtils.toInt((String)parameters.get("rabbitmq.factory.connection.timeout"), (int)60000);
        long networkRecoveryInterval = NumberUtils.toLong((String)parameters.get("rabbitmq.connection.factory.network.recovery.interval"), (long)5000L);
        this.retryInterval = NumberUtils.toInt((String)parameters.get("rabbitmq.connection.retry.interval"), (int)30000);
        this.retryCount = NumberUtils.toInt((String)parameters.get("rabbitmq.connection.retry.count"), (int)3);
        boolean sslEnabled = BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)parameters.get("rabbitmq.connection.ssl.enabled")), (boolean)false);
        String[] hostnameArray = hostnames.split(",");
        if (hostnameArray.length == (portArray = ports.split(",")).length) {
            this.addresses = new Address[hostnameArray.length];
            for (int i = 0; i < hostnameArray.length; ++i) {
                try {
                    this.addresses[i] = new Address(hostnameArray[i].trim(), Integer.parseInt(portArray[i].trim()));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new RabbitMQException("Number format error in port number", e);
                }
            }
        } else {
            throw new RabbitMQException("The number of hostnames must be equal to the number of ports");
        }
        this.connectionFactory = new ConnectionFactory();
        this.connectionFactory.setUsername(username);
        this.connectionFactory.setPassword(password);
        this.connectionFactory.setVirtualHost(virtualHost);
        this.connectionFactory.setRequestedHeartbeat(heartbeat);
        this.connectionFactory.setConnectionTimeout(connectionTimeout);
        this.connectionFactory.setNetworkRecoveryInterval(networkRecoveryInterval);
        this.connectionFactory.setAutomaticRecoveryEnabled(true);
        this.connectionFactory.setTopologyRecoveryEnabled(true);
        this.setSSL(parameters, sslEnabled);
    }

    private void setSSL(Map<String, String> parameters, boolean sslEnabled) {
        try {
            if (sslEnabled) {
                String keyStoreLocation = parameters.get("rabbitmq.connection.ssl.keystore.location");
                String keyStoreType = parameters.get("rabbitmq.connection.ssl.keystore.type");
                String keyStorePassword = parameters.get("rabbitmq.connection.ssl.keystore.password");
                String trustStoreLocation = parameters.get("rabbitmq.connection.ssl.truststore.location");
                String trustStoreType = parameters.get("rabbitmq.connection.ssl.truststore.type");
                String trustStorePassword = parameters.get("rabbitmq.connection.ssl.truststore.password");
                String sslVersion = parameters.get("rabbitmq.connection.ssl.version");
                if (StringUtils.isEmpty((String)keyStoreLocation) || StringUtils.isEmpty((String)keyStoreType) || StringUtils.isEmpty((String)keyStorePassword) || StringUtils.isEmpty((String)trustStoreLocation) || StringUtils.isEmpty((String)trustStoreType) || StringUtils.isEmpty((String)trustStorePassword)) {
                    log.info((Object)"Trustore and keystore information is not provided");
                    if (StringUtils.isNotEmpty((String)sslVersion)) {
                        this.connectionFactory.useSslProtocol(sslVersion);
                    } else {
                        log.info((Object)"Proceeding with default SSL configuration");
                        this.connectionFactory.useSslProtocol();
                    }
                } else {
                    char[] keyPassphrase = keyStorePassword.toCharArray();
                    KeyStore ks = KeyStore.getInstance(keyStoreType);
                    ks.load(new FileInputStream(keyStoreLocation), keyPassphrase);
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    kmf.init(ks, keyPassphrase);
                    char[] trustPassphrase = trustStorePassword.toCharArray();
                    KeyStore tks = KeyStore.getInstance(trustStoreType);
                    tks.load(new FileInputStream(trustStoreLocation), trustPassphrase);
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    tmf.init(tks);
                    SSLContext c = SSLContext.getInstance(sslVersion);
                    c.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                    this.connectionFactory.useSslProtocol(c);
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"Format error in SSL enabled value. Proceeding without enabling SSL", (Throwable)e);
        }
    }

    public Connection createConnection() throws RabbitMQException {
        Connection connection;
        block2: {
            connection = null;
            try {
                connection = RabbitMQUtils.createConnection(this.connectionFactory, this.addresses);
                log.info((Object)("[" + this.name + "] Successfully connected to RabbitMQ Broker"));
            }
            catch (IOException e) {
                log.error((Object)("[" + this.name + "] Error creating connection to RabbitMQ Broker. Reattempting to connect."), (Throwable)e);
                connection = this.retry(connection);
                if (connection != null) break block2;
                throw new RabbitMQException("[" + this.name + "] Could not connect to RabbitMQ Broker. Error while creating connection", e);
            }
        }
        return connection;
    }

    private Connection retry(Connection connection) {
        int retryC = 0;
        while (connection == null && (this.retryCount == -1 || retryC < this.retryCount)) {
            log.info((Object)("[" + this.name + "] Attempting to create connection to RabbitMQ Broker in " + this.retryInterval + "ms. Retry attempts: " + ++retryC));
            try {
                Thread.sleep(this.retryInterval);
                connection = RabbitMQUtils.createConnection(this.connectionFactory, this.addresses);
                log.info((Object)("[" + this.name + "] Successfully connected to RabbitMQ Broker"));
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
            }
            catch (IOException e1) {
                log.error((Object)("[" + this.name + "] Error while trying to reconnect to RabbitMQ Broker"), (Throwable)e1);
            }
        }
        return connection;
    }
}

