/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.websocket;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.AbstractSubprotocolHandler;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.InboundWebsocketSourceHandler;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.ssl.InboundWebsocketSSLConfiguration;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.ssl.SSLHandlerFactory;

public class InboundWebsocketChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger log = LoggerFactory.getLogger(InboundWebsocketChannelInitializer.class);
    private InboundWebsocketSSLConfiguration sslConfiguration;
    private int clientBroadcastLevel;
    private String outflowDispatchSequence;
    private String outflowErrorSequence;
    private ChannelHandler pipelineHandler;
    private boolean dispatchToCustomSequence;
    private ArrayList<AbstractSubprotocolHandler> subprotocolHandlers;
    private int portOffset;
    private int inflowIdleTime;
    private int outflowIdleTime;

    public void setSslConfiguration(InboundWebsocketSSLConfiguration sslConfiguration) {
        this.sslConfiguration = sslConfiguration;
    }

    public void setPipelineHandler(ChannelHandler name) {
        this.pipelineHandler = name;
    }

    public void setDispatchToCustomSequence(String dispatchToCustomSequence) {
        this.dispatchToCustomSequence = Boolean.parseBoolean(dispatchToCustomSequence);
    }

    public void setClientBroadcastLevel(int clientBroadcastLevel) {
        this.clientBroadcastLevel = clientBroadcastLevel;
    }

    public void setOutflowDispatchSequence(String outflowDispatchSequence) {
        this.outflowDispatchSequence = outflowDispatchSequence;
    }

    public void setOutflowErrorSequence(String outflowErrorSequence) {
        this.outflowErrorSequence = outflowErrorSequence;
    }

    public void setSubprotocolHandlers(ArrayList<AbstractSubprotocolHandler> subprotocolHandlers) {
        this.subprotocolHandlers = subprotocolHandlers;
    }

    public void setInflowIdleTime(int inflowIdleTime) {
        this.inflowIdleTime = inflowIdleTime;
    }

    public void setOutflowIdleTime(int outflowIdleTime) {
        this.outflowIdleTime = outflowIdleTime;
    }

    protected void initChannel(SocketChannel websocketChannel) throws Exception {
        if (this.sslConfiguration != null) {
            SslHandler sslHandler = new SSLHandlerFactory(this.sslConfiguration).create();
            websocketChannel.pipeline().addLast("ssl", (ChannelHandler)sslHandler);
        }
        ChannelPipeline p = websocketChannel.pipeline();
        p.addLast("codec", (ChannelHandler)new HttpServerCodec());
        p.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
        p.addLast("frameAggregator", (ChannelHandler)new WebSocketFrameAggregator(Integer.MAX_VALUE));
        p.addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(this.inflowIdleTime, this.outflowIdleTime, 0));
        InboundWebsocketSourceHandler sourceHandler = new InboundWebsocketSourceHandler();
        sourceHandler.setClientBroadcastLevel(this.clientBroadcastLevel);
        sourceHandler.setDispatchToCustomSequence(this.dispatchToCustomSequence);
        sourceHandler.setPortOffset(this.portOffset);
        if (this.outflowDispatchSequence != null) {
            sourceHandler.setOutflowDispatchSequence(this.outflowDispatchSequence);
        }
        if (this.outflowErrorSequence != null) {
            sourceHandler.setOutflowErrorSequence(this.outflowErrorSequence);
        }
        if (this.subprotocolHandlers != null) {
            sourceHandler.setSubprotocolHandlers(this.subprotocolHandlers);
        }
        if (this.pipelineHandler != null) {
            p.addLast("pipelineHandler", (ChannelHandler)this.pipelineHandler.getClass().getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        p.addLast("handler", (ChannelHandler)sourceHandler);
    }

    public void setPortOffset(int portOffset) {
        this.portOffset = portOffset;
    }
}

