/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.websocket.management;

import java.util.concurrent.ConcurrentHashMap;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.InboundWebsocketEventExecutor;

public class WebsocketEventExecutorManager {
    private ConcurrentHashMap<Integer, InboundWebsocketEventExecutor> executorPoolMap = new ConcurrentHashMap();
    private static WebsocketEventExecutorManager instance = null;

    public static WebsocketEventExecutorManager getInstance() {
        if (instance == null) {
            instance = new WebsocketEventExecutorManager();
        }
        return instance;
    }

    public void shutdownExecutor(int port) {
        this.executorPoolMap.get(port).shutdownEventExecutor();
        this.executorPoolMap.remove(port);
    }

    public void registerEventExecutor(int port, InboundWebsocketEventExecutor eventExecutor) {
        this.executorPoolMap.put(port, eventExecutor);
    }

    public boolean isRegisteredExecutor(int port) {
        return this.executorPoolMap.containsKey(port);
    }
}

