/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.websocket.ssl;

import io.netty.handler.ssl.SslHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.ssl.InboundWebsocketSSLConfiguration;

public class SSLHandlerFactory {
    private static final String protocol = "TLS";
    private final SSLContext serverContext;
    private boolean needClientAuth;
    private String[] cipherSuites;
    private String[] sslProtocols;

    public SSLHandlerFactory(InboundWebsocketSSLConfiguration sslConfiguration) {
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        try {
            KeyStore keyStore = SSLHandlerFactory.getKeyStore(sslConfiguration.getKeyStore(), sslConfiguration.getKeyStorePass());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(algorithm);
            keyManagerFactory.init(keyStore, sslConfiguration.getCertPass() != null ? sslConfiguration.getCertPass().toCharArray() : sslConfiguration.getKeyStorePass().toCharArray());
            KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
            TrustManager[] trustManagers = null;
            if (sslConfiguration.getTrustStore() != null) {
                this.needClientAuth = true;
                KeyStore trustStore = SSLHandlerFactory.getKeyStore(sslConfiguration.getTrustStore(), sslConfiguration.getTrustStorePass());
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(algorithm);
                trustManagerFactory.init(trustStore);
                trustManagers = trustManagerFactory.getTrustManagers();
            }
            this.serverContext = SSLContext.getInstance(protocol);
            this.serverContext.init(keyManagers, trustManagers, null);
            this.cipherSuites = sslConfiguration.getCipherSuites();
            this.sslProtocols = sslConfiguration.getSslProtocols();
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
            throw new IllegalArgumentException("Failed to initialize the server side SSLContext", ex);
        }
    }

    private static KeyStore getKeyStore(File keyStore, String keyStorePassword) throws IOException {
        KeyStore keyStoreInstance;
        try (FileInputStream is = new FileInputStream(keyStore);){
            keyStoreInstance = KeyStore.getInstance("JKS");
            keyStoreInstance.load(is, keyStorePassword.toCharArray());
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IOException(e);
        }
        return keyStoreInstance;
    }

    public SslHandler create() {
        SSLEngine engine = this.serverContext.createSSLEngine();
        if (this.cipherSuites != null) {
            engine.setEnabledCipherSuites(this.cipherSuites);
        }
        if (this.sslProtocols != null) {
            engine.setEnabledProtocols(this.sslProtocols);
        }
        engine.setNeedClientAuth(this.needClientAuth);
        engine.setUseClientMode(false);
        return new SslHandler(engine);
    }
}

