/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.localentry.service;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.SynapsePropertiesLoader;
import org.apache.synapse.config.xml.EntryFactory;
import org.apache.synapse.config.xml.EntrySerializer;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.localentry.LocalEntryAdminException;
import org.wso2.carbon.localentry.dos.EntryData;
import org.wso2.carbon.localentry.util.ConfigHolder;
import org.wso2.carbon.mediation.dependency.mgt.ConfigurationObject;
import org.wso2.carbon.mediation.dependency.mgt.services.DependencyManagementService;
import org.wso2.carbon.mediation.initializer.AbstractServiceBusAdmin;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;

public class LocalEntryAdmin
extends AbstractServiceBusAdmin {
    private static final Log log = LogFactory.getLog(LocalEntryAdmin.class);
    public static final int LOCAL_ENTRIES_PER_PAGE = 10;
    private boolean saveRuntimeArtifacts = SynapsePropertiesLoader.getBooleanProperty((String)"synapse.artifacts.file.storage.enabled", (Boolean)true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryData[] entryData() throws LocalEntryAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            Map gloabalEntiesMap = synapseConfiguration.getDefinedEntries();
            ArrayList<EntryData> globalEntryList = new ArrayList<EntryData>();
            for (Map.Entry o : gloabalEntiesMap.entrySet()) {
                String s;
                EntryData data = new EntryData();
                Map.Entry entry = o;
                String key = (String)entry.getKey();
                if ("SERVER_IP".equals(key) || "SERVER_HOST".equals(key) || !(entry.getValue() instanceof Entry)) continue;
                Entry value = (Entry)entry.getValue();
                data.setName(key);
                data.setDescription(value.getDescription());
                switch (value.getType()) {
                    case 3: {
                        data.setType("Registry Key");
                        break;
                    }
                    case 0: {
                        data.setType("Inline Text");
                        break;
                    }
                    case 1: {
                        data.setType("Inline XML");
                        break;
                    }
                    case 2: {
                        data.setType("Source URL");
                        break;
                    }
                    default: {
                        data.setType("Unknown");
                    }
                }
                if (value.getValue() instanceof String) {
                    s = (String)value.getValue();
                    data.setValue(s);
                } else if (value.getType() == 2) {
                    s = value.getSrc().toString();
                    data.setValue(s);
                } else if (value.getType() == 3) {
                    data.setValue(value.getKey());
                } else if (value.getValue() != null) {
                    data.setValue(value.getValue().toString());
                } else {
                    data.setValue("");
                }
                if (value.getArtifactContainerName() != null) {
                    data.setArtifactContainerName(value.getArtifactContainerName());
                }
                if (value.getIsEdited()) {
                    data.setIsEdited(true);
                }
                globalEntryList.add(data);
            }
            Collections.sort(globalEntryList, new Comparator<EntryData>(){

                @Override
                public int compare(EntryData o1, EntryData o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            EntryData[] entryDataArray = globalEntryList.toArray(new EntryData[globalEntryList.size()]);
            return entryDataArray;
        }
        finally {
            lock.unlock();
        }
    }

    public EntryData[] paginatedEntryData(int pageNumber) throws LocalEntryAdminException {
        return this.doPaging(pageNumber, this.entryData());
    }

    private EntryData[] doPaging(int pageNumber, EntryData[] entries) {
        if (entries.length == 0) {
            return entries;
        }
        int itemsPerPageInt = 10;
        int numberOfPages = (int)Math.ceil((double)entries.length / (double)itemsPerPageInt);
        if (pageNumber > numberOfPages - 1) {
            pageNumber = numberOfPages - 1;
        }
        int startIndex = pageNumber * itemsPerPageInt;
        int endIndex = (pageNumber + 1) * itemsPerPageInt;
        List<EntryData> entriesList = Arrays.asList(entries);
        ArrayList<EntryData> paginatedEntriesList = new ArrayList<EntryData>();
        for (int i = startIndex; i < endIndex && i < entries.length; ++i) {
            paginatedEntriesList.add(entriesList.get(i));
        }
        return paginatedEntriesList.toArray(new EntryData[paginatedEntriesList.size()]);
    }

    public int getEntryDataCount() throws LocalEntryAdminException {
        int entryDataCount = 0;
        if (this.entryData() != null) {
            entryDataCount = this.entryData().length;
            return entryDataCount;
        }
        return entryDataCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEntryExist(String entryKey) throws LocalEntryAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            this.assertKeyEmpty(entryKey);
            log.debug((Object)("Checking localEntry Exists : " + entryKey));
            boolean bl = this.getSynapseConfiguration().getLocalRegistry().containsKey(entryKey);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEntryExistForTenant(String entryKey, String tenantDomain) throws LocalEntryAdminException {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
            boolean bl = this.isEntryExist(entryKey);
            return bl;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEntry(String ele) throws LocalEntryAdminException {
        Lock lock = this.getLock();
        try {
            OMElement elem;
            lock.lock();
            try {
                elem = this.nonCoalescingStringToOm(ele);
            }
            catch (XMLStreamException e) {
                boolean bl = false;
                lock.unlock();
                return bl;
            }
            if (elem.getQName().getLocalPart().equals(XMLConfigConstants.ENTRY_ELT.getLocalPart())) {
                String entryKey = elem.getAttributeValue(new QName("key"));
                this.assertKeyEmpty(entryKey);
                entryKey = entryKey.trim();
                log.debug((Object)("Adding local entry with key : " + entryKey));
                boolean cont = true;
                if (this.getSynapseConfiguration().getLocalRegistry().containsKey(entryKey)) {
                    Entry e = (Entry)this.getSynapseConfiguration().getLocalRegistry().get(entryKey);
                    if (e.getValue() == null) {
                        this.getSynapseConfiguration().getLocalRegistry().remove(entryKey);
                    } else {
                        cont = false;
                    }
                }
                if (!cont) {
                    this.handleFault(log, "An Entry with key " + entryKey + " is already used within the configuration");
                } else {
                    Entry entry = EntryFactory.createEntry((OMElement)elem, (Properties)this.getSynapseConfiguration().getProperties());
                    entry.setFileName(ServiceBusUtils.generateFileName((String)entry.getKey()));
                    this.getSynapseConfiguration().addEntry(entryKey, entry);
                    if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode")) && this.saveRuntimeArtifacts) {
                        MediationPersistenceManager pm = ServiceBusUtils.getMediationPersistenceManager((AxisConfiguration)this.getAxisConfig());
                        pm.saveItem(entry.getKey(), 4);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Local registry entry : " + entryKey + " added to the configuration"));
                }
                boolean bl = true;
                return bl;
            }
            this.handleFault(log, "Error adding local entry. Invalid definition");
        }
        catch (SynapseException syne) {
            this.handleFault(log, "Unable to add local entry ", (Exception)((Object)syne));
        }
        catch (OMException e) {
            this.handleFault(log, "Unable to add local entry. Invalid XML ", (Exception)((Object)e));
        }
        finally {
            lock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEntryForTenant(String element, String tenantDomain) throws LocalEntryAdminException {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
            boolean bl = this.addEntry(element);
            return bl;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveEntry(String ele) throws LocalEntryAdminException {
        Lock lock = this.getLock();
        try {
            String key;
            OMElement elem;
            lock.lock();
            try {
                elem = this.nonCoalescingStringToOm(ele);
            }
            catch (XMLStreamException e) {
                boolean bl = false;
                lock.unlock();
                return bl;
            }
            if (elem == null) {
                this.handleFault(log, "Unable to save local entry. Null definition");
            }
            if ((key = elem.getAttributeValue(new QName("", "key"))) != null) {
                log.debug((Object)("Saving local entry with key : " + key));
                key = key.trim();
                Entry oldEntry = (Entry)this.getSynapseConfiguration().getDefinedEntries().get(key);
                if (oldEntry == null) {
                    this.handleFault(log, "Unable to update local entry. Non existent");
                } else {
                    Entry entry = EntryFactory.createEntry((OMElement)elem, (Properties)this.getSynapseConfiguration().getProperties());
                    this.getSynapseConfiguration().removeEntry(key);
                    this.getSynapseConfiguration().addEntry(key, entry);
                    entry.setFileName(oldEntry.getFileName());
                    if (oldEntry.getArtifactContainerName() != null) {
                        entry.setArtifactContainerName(oldEntry.getArtifactContainerName());
                        entry.setIsEdited(true);
                    } else if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode")) && this.saveRuntimeArtifacts) {
                        MediationPersistenceManager pm = ServiceBusUtils.getMediationPersistenceManager((AxisConfiguration)this.getAxisConfig());
                        pm.saveItem(key, 4);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Added local entry : " + key + " into the configuration"));
                    }
                }
            }
        }
        catch (SynapseException syne) {
            this.handleFault(log, "Unable to add local entry ", (Exception)((Object)syne));
        }
        catch (OMException e) {
            this.handleFault(log, "Unable to add local entry.Invalid XML ", (Exception)((Object)e));
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveEntryForTenant(String element, String tenantDomain) throws LocalEntryAdminException {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
            boolean bl = this.saveEntry(element);
            return bl;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement getEntry(String entryKey) throws LocalEntryAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            this.assertKeyEmpty(entryKey);
            entryKey = entryKey.trim();
            if (synapseConfiguration.getEntry(entryKey) != null) {
                OMElement elem = EntrySerializer.serializeEntry((Entry)synapseConfiguration.getEntryDefinition(entryKey), null);
                OMFactory fac = elem.getOMFactory();
                OMNamespace nullNS = fac.createOMNamespace("", "ns3");
                elem.declareNamespace(nullNS);
                if (elem.getAttribute(new QName("", "key")) != null) {
                    if (elem.getAttribute(new QName("", "src")) != null) {
                        elem.addAttribute("type", Integer.toString(2), nullNS);
                    } else if (elem.getFirstOMChild() instanceof OMText) {
                        elem.addAttribute("type", Integer.toString(0), nullNS);
                    } else if (elem.getFirstOMChild() instanceof OMElement) {
                        elem.addAttribute("type", Integer.toString(1), nullNS);
                    }
                    OMElement oMElement = elem;
                    return oMElement;
                }
                this.handleFault(log, "Unable to fetch local entry. Key missing");
            } else {
                this.handleFault(log, "Entry with the key " + entryKey + " does not exist");
            }
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement getEntryForTenant(String entryKey, String tenantDomain) throws LocalEntryAdminException {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
            OMElement oMElement = this.getEntry(entryKey);
            return oMElement;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteEntry(String entryKey) throws LocalEntryAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            this.assertKeyEmpty(entryKey);
            log.debug((Object)("Deleting local entry with key : " + entryKey));
            entryKey = entryKey.trim();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            Entry entry = (Entry)synapseConfiguration.getDefinedEntries().get(entryKey);
            if (entry != null) {
                synapseConfiguration.removeEntry(entryKey);
                if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode")) && this.saveRuntimeArtifacts) {
                    MediationPersistenceManager pm = ServiceBusUtils.getMediationPersistenceManager((AxisConfiguration)this.getAxisConfig());
                    pm.deleteItem(entryKey, entry.getFileName(), 4);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleted local entry with key : " + entryKey));
                }
                boolean bl = true;
                return bl;
            }
            log.warn((Object)("No entry exists by the key : " + entryKey));
            boolean bl = false;
            return bl;
        }
        catch (SynapseException syne) {
            this.handleFault(log, "Unable to delete the local entry : " + entryKey, (Exception)((Object)syne));
        }
        finally {
            lock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteEntryForTenant(String entryKey, String tenantDomain) throws LocalEntryAdminException {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
            boolean bl = this.deleteEntry(entryKey);
            return bl;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getEntryNames() throws LocalEntryAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            Map localEntriesMap = synapseConfiguration.getLocalRegistry();
            ArrayList<String> propKeys = new ArrayList<String>();
            if (localEntriesMap != null) {
                for (Object entryValue : localEntriesMap.values()) {
                    String key;
                    if (!(entryValue instanceof Entry) || "SERVER_IP".equals(key = ((Entry)entryValue).getKey()) || "SERVER_HOST".equals(key)) continue;
                    propKeys.add(key);
                }
                String[] stringArray = propKeys.toArray(new String[propKeys.size()]);
                return stringArray;
            }
            String[] stringArray = new String[]{};
            return stringArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEntryNamesString() throws LocalEntryAdminException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            Map gloabalEntriesMap = synapseConfiguration.getLocalRegistry();
            ArrayList<String> sequenceList = new ArrayList<String>();
            ArrayList<String> endpointList = new ArrayList<String>();
            ArrayList<String> entryList = new ArrayList<String>();
            StringBuffer entrySb = new StringBuffer();
            StringBuffer endpointSb = new StringBuffer();
            StringBuffer sequenceSb = new StringBuffer();
            for (Object entryValue : gloabalEntriesMap.values()) {
                String key;
                Entry entry;
                String name;
                if (entryValue instanceof Endpoint) {
                    Endpoint endpoint = (Endpoint)entryValue;
                    name = endpoint.getName();
                    if (name == null) continue;
                    endpointList.add(name);
                    continue;
                }
                if (entryValue instanceof SequenceMediator) {
                    SequenceMediator sequenceMediator = (SequenceMediator)entryValue;
                    name = sequenceMediator.getName();
                    if (name == null) continue;
                    sequenceList.add(name);
                    continue;
                }
                if (!(entryValue instanceof Entry) || (entry = (Entry)entryValue).isDynamic() || entry.isRemote() || "SERVER_IP".equals(key = entry.getKey()) || "SERVER_HOST".equals(key)) continue;
                entryList.add(key);
            }
            if (!sequenceList.isEmpty()) {
                Collections.sort(sequenceList, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareToIgnoreCase(o2);
                    }
                });
                for (String name : sequenceList) {
                    if (name == null) continue;
                    sequenceSb.append("[Sequence]-").append(name).append(" ");
                }
            }
            if (!entryList.isEmpty()) {
                Collections.sort(entryList, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareToIgnoreCase(o2);
                    }
                });
                for (String name : entryList) {
                    if (name == null) continue;
                    entrySb.append("[Entry]-").append(name).append(" ");
                }
            }
            if (!endpointList.isEmpty()) {
                Collections.sort(endpointList, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareToIgnoreCase(o2);
                    }
                });
                for (String name : endpointList) {
                    if (name == null) continue;
                    endpointSb.append("[Enpoint]-").append(name).append(" ");
                }
            }
            String string = endpointSb.toString() + entrySb.toString() + sequenceSb.toString();
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    public ConfigurationObject[] getDependents(String entryName) {
        DependencyManagementService dependencyMgr = ConfigHolder.getInstance().getDependencyManager();
        if (dependencyMgr != null) {
            return dependencyMgr.getDependents(3, entryName);
        }
        return null;
    }

    private void assertKeyEmpty(String entryKey) throws LocalEntryAdminException {
        if (entryKey == null || "".equals(entryKey)) {
            this.handleFault(log, "Entry key cannot be empty");
        }
    }

    private void handleFault(Log log, String message, Exception e) throws LocalEntryAdminException {
        message = message + " :: " + e.getMessage();
        log.error((Object)message, (Throwable)e);
        throw new LocalEntryAdminException(message, e);
    }

    private void handleFault(Log log, String message) throws LocalEntryAdminException {
        log.error((Object)message);
        throw new LocalEntryAdminException(message);
    }

    private OMElement nonCoalescingStringToOm(String xmlStr) throws XMLStreamException {
        StringReader strReader = new StringReader(xmlStr);
        XMLInputFactory xmlInFac = XMLInputFactory.newInstance();
        xmlInFac.setProperty("javax.xml.stream.isCoalescing", false);
        XMLStreamReader parser = xmlInFac.createXMLStreamReader(strReader);
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        return builder.getDocumentElement();
    }
}

