/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.commons.rest.api.swagger;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.SequenceType;
import org.apache.synapse.api.API;
import org.apache.synapse.api.Resource;
import org.apache.synapse.api.dispatch.DispatcherHelper;
import org.apache.synapse.api.dispatch.URITemplateHelper;
import org.apache.synapse.api.dispatch.URLMappingHelper;
import org.apache.synapse.api.version.ContextVersionStrategy;
import org.apache.synapse.api.version.DefaultStrategy;
import org.apache.synapse.api.version.URLBasedVersionStrategy;
import org.apache.synapse.api.version.VersionStrategy;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.config.xml.rest.APIFactory;
import org.apache.synapse.config.xml.rest.APISerializer;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.builtin.CommentMediator;
import org.apache.synapse.mediators.builtin.LoopBackMediator;
import org.apache.synapse.mediators.builtin.PropertyMediator;
import org.apache.synapse.mediators.builtin.RespondMediator;
import org.apache.synapse.mediators.transform.PayloadFactoryMediator;
import org.apache.synapse.mediators.transform.pfutils.RegexTemplateProcessor;
import org.apache.synapse.mediators.transform.pfutils.TemplateProcessor;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.wso2.carbon.mediation.commons.rest.api.swagger.APIGenException;
import org.wso2.carbon.mediation.commons.rest.api.swagger.SwaggerConstants;

public class APIGenerator {
    private JsonObject swaggerJson;
    private static Log log = LogFactory.getLog(APIGenerator.class);

    public APIGenerator(JsonObject swaggerJson) {
        this.swaggerJson = swaggerJson;
    }

    public API generateSynapseAPI() throws APIGenException {
        String apiContext;
        if (this.swaggerJson.get("servers") == null || this.swaggerJson.get("servers").getAsJsonArray().size() == 0) {
            apiContext = "/default";
        } else {
            JsonObject firstServer = this.swaggerJson.getAsJsonArray("servers").get(0).getAsJsonObject();
            String serversString = firstServer.get("url").getAsString();
            if (serversString.contains("{") && serversString.contains("}")) {
                if (firstServer.has("variables")) {
                    JsonObject variables = firstServer.get("variables").getAsJsonObject();
                    serversString = this.replaceTemplates(serversString, variables);
                } else {
                    throw new APIGenException("Server url is templated, but variables cannot be found");
                }
            }
            try {
                URL url = new URL(serversString);
                apiContext = url.getPath();
            }
            catch (MalformedURLException e) {
                apiContext = serversString;
            }
            if (apiContext.equals("/")) {
                apiContext = "/default";
            }
            if (apiContext.lastIndexOf(47) == apiContext.length() - 1) {
                apiContext = apiContext.substring(0, apiContext.length() - 1);
            }
            if (!apiContext.startsWith("/")) {
                apiContext = "/" + apiContext;
            }
        }
        if (this.swaggerJson.get("info") == null) {
            throw new APIGenException("The \"info\" section of the swagger definition is mandatory for API generation");
        }
        JsonObject swaggerInfo = this.swaggerJson.getAsJsonObject("info");
        if (swaggerInfo.get("title") == null || swaggerInfo.get("title").getAsString().isEmpty()) {
            throw new APIGenException("The title of the swagger definition is mandatory for API generation");
        }
        String apiName = swaggerInfo.get("title").getAsString();
        String versionType = "";
        String version = "";
        JsonElement swaggerVersionElement = swaggerInfo.get("version");
        if (swaggerVersionElement != null && swaggerVersionElement.isJsonPrimitive() && swaggerVersionElement.getAsJsonPrimitive().isString()) {
            version = swaggerVersionElement.getAsString();
            if (apiContext.endsWith(version)) {
                versionType = "url";
                apiContext = apiContext.substring(0, apiContext.length() - version.length() - 1);
            } else {
                versionType = "context";
            }
        }
        API genAPI = new API(apiName, apiContext);
        if (versionType.equals("url")) {
            genAPI.setVersionStrategy((VersionStrategy)new URLBasedVersionStrategy(genAPI, version, ""));
        } else if (versionType.equals("context")) {
            genAPI.setVersionStrategy((VersionStrategy)new ContextVersionStrategy(genAPI, version, ""));
        } else {
            genAPI.setVersionStrategy((VersionStrategy)new DefaultStrategy(genAPI));
        }
        if (this.swaggerJson.get("paths") != null) {
            JsonObject pathsObj = this.swaggerJson.getAsJsonObject("paths");
            for (Map.Entry pathEntry : pathsObj.entrySet()) {
                if (!(pathEntry.getValue() instanceof JsonObject)) continue;
                this.createResource((String)pathEntry.getKey(), ((JsonElement)pathEntry.getValue()).getAsJsonObject(), genAPI, null);
            }
        }
        OMElement apiElement = APISerializer.serializeAPI((API)genAPI);
        if (log.isDebugEnabled()) {
            log.info((Object)("API generation completed : " + genAPI.getName() + " API: " + apiElement.toString()));
        }
        return genAPI;
    }

    private String replaceTemplates(String input, JsonObject variables) throws APIGenException {
        Matcher m = Pattern.compile("\\{(.*?)\\}").matcher(input);
        while (m.find()) {
            String temp = m.group(1);
            if (variables.has(temp) && variables.get(temp).getAsJsonObject().has("default")) {
                String realValue = variables.get(temp).getAsJsonObject().get("default").getAsString();
                input = input.replace("{" + temp + "}", realValue);
                continue;
            }
            throw new APIGenException("Variables cannot be found to replace the value {" + temp + "}");
        }
        return input;
    }

    public API generateSynapseAPI(API existingAPI) throws APIGenException {
        String apiContext;
        if (this.swaggerJson.get("servers") == null || this.swaggerJson.get("servers").getAsJsonArray().size() == 0) {
            apiContext = "/default";
        } else {
            String serversString = this.swaggerJson.getAsJsonArray("servers").get(0).getAsJsonObject().get("url").getAsString();
            try {
                URL url = new URL(serversString);
                apiContext = url.getPath();
            }
            catch (MalformedURLException e) {
                apiContext = serversString;
            }
        }
        if (apiContext.lastIndexOf(47) == apiContext.length() - 1) {
            apiContext = apiContext.substring(0, apiContext.length() - 1);
        }
        if (!apiContext.startsWith("/")) {
            apiContext = "/" + apiContext;
        }
        if (this.swaggerJson.get("info") == null) {
            throw new APIGenException("The \"info\" section of the swagger definition is mandatory for API generation");
        }
        JsonObject swaggerInfo = this.swaggerJson.getAsJsonObject("info");
        if (swaggerInfo.get("title") == null || swaggerInfo.get("title").getAsString().isEmpty()) {
            throw new APIGenException("The title of the swagger definition is mandatory for API generation");
        }
        String apiName = swaggerInfo.get("title").getAsString();
        String versionType = "";
        String version = "";
        JsonElement swaggerVersionElement = swaggerInfo.get("version");
        if (swaggerVersionElement != null && swaggerVersionElement.isJsonPrimitive() && swaggerVersionElement.getAsJsonPrimitive().isString()) {
            version = swaggerVersionElement.getAsString();
            if (apiContext.endsWith(version)) {
                versionType = "url";
                apiContext = apiContext.substring(0, apiContext.length() - version.length() - 1);
            } else {
                versionType = "context";
            }
        }
        API genAPI = new API(apiName, apiContext);
        if (versionType.equals("url")) {
            genAPI.setVersionStrategy((VersionStrategy)new URLBasedVersionStrategy(genAPI, version, ""));
        } else if (versionType.equals("context")) {
            genAPI.setVersionStrategy((VersionStrategy)new ContextVersionStrategy(genAPI, version, ""));
        } else {
            genAPI.setVersionStrategy((VersionStrategy)new DefaultStrategy(genAPI));
        }
        if (this.swaggerJson.get("paths") != null) {
            JsonObject pathsObj = this.swaggerJson.getAsJsonObject("paths");
            for (Map.Entry pathEntry : pathsObj.entrySet()) {
                if (!(pathEntry.getValue() instanceof JsonObject)) continue;
                this.createResource((String)pathEntry.getKey(), ((JsonElement)pathEntry.getValue()).getAsJsonObject(), genAPI, existingAPI);
            }
        }
        OMElement apiElement = APISerializer.serializeAPI((API)genAPI);
        if (log.isDebugEnabled()) {
            log.info((Object)("API generation completed : " + genAPI.getName() + " API: " + apiElement.toString()));
        }
        return genAPI;
    }

    public API generateUpdatedSynapseAPI(API existingAPI) throws APIGenException {
        API clonedAPI;
        if (existingAPI == null) {
            throw new APIGenException("Provided existing API is null");
        }
        API genAPI = this.generateSynapseAPI(existingAPI);
        try {
            clonedAPI = APIFactory.createAPI((OMElement)AXIOMUtil.stringToOM((String)APISerializer.serializeAPI((API)existingAPI).toString()));
        }
        catch (XMLStreamException e) {
            throw new APIGenException("Error occurred while cloning the existing API", e);
        }
        if (existingAPI.getVersionStrategy() instanceof DefaultStrategy) {
            genAPI.setVersionStrategy((VersionStrategy)new DefaultStrategy(genAPI));
        }
        if (StringUtils.isNotBlank((String)existingAPI.getSwaggerResourcePath())) {
            genAPI.setSwaggerResourcePath(existingAPI.getSwaggerResourcePath());
        }
        this.updateImplChanges(genAPI, clonedAPI);
        return genAPI;
    }

    private void createResource(String path, JsonObject resourceObj, API genAPI, API existingAPI) throws APIGenException {
        boolean noneURLStyleAdded = false;
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (existingAPI != null) {
            for (Resource resource : existingAPI.getResources()) {
                String resourceMapping;
                String string = resourceMapping = resource.getDispatcherHelper() != null ? resource.getDispatcherHelper().getString() : "/";
                if (!path.equals(resourceMapping)) continue;
                resources.add(resource);
            }
        }
        int i = 0;
        HashMap<String, Integer> methodMapping = new HashMap<String, Integer>();
        HashMap<Integer, Resource> createdResources = new HashMap<Integer, Resource>();
        for (Resource resource : resources) {
            for (String method : resource.getMethods()) {
                methodMapping.put(method, i);
            }
            ++i;
        }
        for (Map.Entry methodEntry : resourceObj.entrySet()) {
            Resource createdResource;
            String methodName;
            if (log.isDebugEnabled()) {
                log.info((Object)("Generating resource for path : " + path + ", method : " + (String)methodEntry.getKey()));
            }
            if (methodMapping.containsKey(methodName = ((String)methodEntry.getKey()).toUpperCase()) && (createdResource = (Resource)createdResources.get(methodMapping.get(methodName))) != null) {
                createdResource.addMethod(methodName);
                continue;
            }
            Resource resource = new Resource();
            resource.addMethod(methodName);
            Matcher matcher = SwaggerConstants.PATH_PARAMETER_PATTERN.matcher(path);
            ArrayList<String> pathParamList = new ArrayList<String>();
            while (matcher.find()) {
                pathParamList.add(matcher.group(1));
            }
            if (pathParamList.isEmpty()) {
                if (!"/".equals(path) || noneURLStyleAdded) {
                    resource.setDispatcherHelper((DispatcherHelper)new URLMappingHelper(path));
                }
                if ("/".equals(path)) {
                    noneURLStyleAdded = true;
                }
            } else {
                resource.setDispatcherHelper((DispatcherHelper)new URITemplateHelper(path));
            }
            resource.setInSequence(APIGenerator.getDefaultInSequence(pathParamList));
            resource.setOutSequence(APIGenerator.getDefaultOutSequence());
            genAPI.addResource(resource);
            if (!methodMapping.containsKey(methodName)) continue;
            createdResources.put((Integer)methodMapping.get(methodName), resource);
        }
    }

    private void updateImplChanges(API newAPI, API currentAPI) {
        String resourceMapping;
        String newVersion = newAPI.getVersion();
        VersionStrategy strategy = currentAPI.getVersionStrategy();
        if (strategy instanceof URLBasedVersionStrategy) {
            newAPI.setVersionStrategy((VersionStrategy)new URLBasedVersionStrategy(newAPI, newVersion, currentAPI.getVersionStrategy().getVersionParam()));
        } else if (strategy instanceof ContextVersionStrategy) {
            newAPI.setVersionStrategy((VersionStrategy)new ContextVersionStrategy(newAPI, newVersion, currentAPI.getVersionStrategy().getVersionParam()));
        }
        HashMap<String, HashMap> currentResourceList = new HashMap<String, HashMap>();
        for (Resource resource : currentAPI.getResources()) {
            resourceMapping = resource.getDispatcherHelper() != null ? resource.getDispatcherHelper().getString() : "/";
            HashMap resourceMap = currentResourceList.get(resourceMapping) != null ? (HashMap)currentResourceList.get(resourceMapping) : new HashMap();
            for (String method : resource.getMethods()) {
                resourceMap.put(method, resource);
            }
            currentResourceList.put(resourceMapping, resourceMap);
        }
        block2: for (Resource resource : newAPI.getResources()) {
            resourceMapping = resource.getDispatcherHelper() != null ? resource.getDispatcherHelper().getString() : "/";
            HashMap existingResources = (HashMap)currentResourceList.get(resourceMapping);
            if (existingResources == null) continue;
            for (String method : resource.getMethods()) {
                if (!existingResources.containsKey(method)) continue;
                this.compareAndUpdateResource((Resource)existingResources.get(method), resource);
                continue block2;
            }
        }
    }

    private void compareAndUpdateResource(Resource source, Resource target) {
        if (source.getInSequenceKey() != null) {
            target.setInSequenceKey(source.getInSequenceKey());
        } else if (source.getInSequence() != null) {
            target.setInSequence(source.getInSequence());
        }
        if (source.getOutSequenceKey() != null) {
            target.setOutSequenceKey(source.getOutSequenceKey());
        } else if (source.getOutSequence() != null) {
            target.setOutSequence(source.getOutSequence());
        }
        if (source.getFaultSequenceKey() != null) {
            target.setFaultSequenceKey(source.getFaultSequenceKey());
        } else if (source.getFaultSequence() != null) {
            target.setFaultSequence(source.getFaultSequence());
        }
    }

    private static SequenceMediator getDefaultInSequence(List<String> pathParams) throws APIGenException {
        SequenceMediator defaultInSeq = new SequenceMediator();
        defaultInSeq.setSequenceType(SequenceType.ANON);
        CommentMediator generatedComment = new CommentMediator();
        generatedComment.setCommentText("This is generated API skeleton.");
        defaultInSeq.addChild((Mediator)generatedComment);
        if (pathParams != null && pathParams.size() > 0) {
            for (String param : pathParams) {
                try {
                    PropertyMediator propertyMediator = new PropertyMediator();
                    propertyMediator.setExpression((SynapsePath)new SynapseXPath("get-property('uri.var." + param + "')"));
                    propertyMediator.setName(param);
                    defaultInSeq.addChild((Mediator)propertyMediator);
                }
                catch (JaxenException e) {
                    throw new APIGenException("Error occurred while creating property mediator for extracting path params", e);
                }
            }
        }
        CommentMediator logicGoesHereComment = new CommentMediator();
        logicGoesHereComment.setCommentText("Business Logic Goes Here");
        defaultInSeq.addChild((Mediator)logicGoesHereComment);
        PayloadFactoryMediator defaultPayload = new PayloadFactoryMediator();
        defaultPayload.setTemplateProcessor((TemplateProcessor)new RegexTemplateProcessor());
        defaultPayload.setType("json");
        defaultPayload.setFormat("{\"Response\" : \"Sample Response\"}");
        defaultInSeq.addChild((Mediator)defaultPayload);
        defaultInSeq.addChild((Mediator)new LoopBackMediator());
        return defaultInSeq;
    }

    private static SequenceMediator getDefaultOutSequence() {
        SequenceMediator defaultOutSeq = new SequenceMediator();
        defaultOutSeq.setSequenceType(SequenceType.ANON);
        defaultOutSeq.addChild((Mediator)new RespondMediator());
        return defaultOutSeq;
    }
}

