/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.commons.rest.api.swagger;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.axis2.AxisFault;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.api.API;
import org.apache.synapse.api.version.URLBasedVersionStrategy;
import org.wso2.carbon.mediation.commons.rest.api.swagger.APIGenException;
import org.wso2.carbon.mediation.commons.rest.api.swagger.GenericApiObjectDefinition;
import org.wso2.carbon.mediation.commons.rest.api.swagger.ServerConfig;
import org.wso2.carbon.mediation.commons.rest.api.swagger.SwaggerConstants;

public class OpenAPIProcessor {
    private API api;
    private ServerConfig serverConfig;
    private static final Log log = LogFactory.getLog(OpenAPIProcessor.class);

    public OpenAPIProcessor(API api, ServerConfig serverConfiguration) {
        this.api = api;
        this.serverConfig = serverConfiguration;
    }

    public OpenAPIProcessor(API api) {
        this.api = api;
    }

    public String getOpenAPISpecification(boolean isJSON) throws AxisFault {
        OpenAPI openAPI = new OpenAPI();
        this.addInfoSection(openAPI);
        this.addServersSection(openAPI);
        Map<String, Object> dataMap = GenericApiObjectDefinition.getPathMap(this.api);
        Paths paths = new Paths();
        for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
            PathItem pathItem = new PathItem();
            Map methodMap = (Map)entry.getValue();
            this.populateParameters(pathItem, methodMap);
            paths.put((Object)entry.getKey(), (Object)pathItem);
        }
        openAPI.setPaths(paths);
        try {
            if (isJSON) {
                return Json.mapper().writeValueAsString((Object)openAPI);
            }
            return Yaml.mapper().writeValueAsString((Object)openAPI);
        }
        catch (JsonProcessingException e) {
            log.error((Object)"Error occurred while creating the output JAML/JSON");
            return null;
        }
    }

    private void addPathQueryAndBodyParams(Operation operation, String paramType, String paramName) {
        switch (paramType) {
            case "path": {
                PathParameter pathParameter = new PathParameter();
                pathParameter.setName(paramName);
                pathParameter.setSchema((Schema)new StringSchema());
                operation.addParametersItem((Parameter)pathParameter);
                break;
            }
            case "query": {
                QueryParameter queryParameter = new QueryParameter();
                queryParameter.setName(paramName);
                queryParameter.setSchema((Schema)new StringSchema());
                operation.addParametersItem((Parameter)queryParameter);
                break;
            }
            case "body": {
                RequestBody requestBody = new RequestBody();
                requestBody.description("Sample Payload");
                requestBody.setRequired(Boolean.valueOf(false));
                MediaType mediaType = new MediaType();
                Schema bodySchema = new Schema();
                bodySchema.setType("object");
                HashMap<String, ObjectSchema> inputProperties = new HashMap<String, ObjectSchema>();
                ObjectSchema objectSchema = new ObjectSchema();
                bodySchema.setProperties(inputProperties);
                inputProperties.put("payload", objectSchema);
                mediaType.setSchema(bodySchema);
                Content content = new Content();
                content.addMediaType("application/json", mediaType);
                requestBody.setContent(content);
                operation.setRequestBody(requestBody);
            }
        }
    }

    private void updateServersSection(OpenAPI openAPI) throws AxisFault {
        List servers = openAPI.getServers();
        if (servers.size() > 0) {
            String basePath = this.api.getVersionStrategy() instanceof URLBasedVersionStrategy ? this.api.getContext() + "/" + this.api.getVersionStrategy().getVersion() : this.api.getContext();
            for (Server server : servers) {
                String urlString = server.getUrl();
                try {
                    URL url = new URL(urlString);
                    String apiContext = url.getPath();
                    if (basePath.equals(apiContext)) continue;
                    server.setUrl(urlString.replace(apiContext, basePath));
                }
                catch (MalformedURLException e) {
                    if (basePath.equals(urlString)) continue;
                    server.setUrl(basePath);
                }
            }
        } else {
            this.addServersSection(openAPI);
        }
    }

    private void addServersSection(OpenAPI openAPI) throws AxisFault {
        ArrayList<Server> servers = new ArrayList<Server>();
        String basePath = this.api.getVersionStrategy() instanceof URLBasedVersionStrategy ? this.api.getContext() + "/" + this.api.getVersionStrategy().getVersion() : this.api.getContext();
        if (this.serverConfig != null) {
            String host = this.serverConfig.getHost("http");
            Server httpServer = new Server();
            httpServer.setUrl("http://" + host + basePath);
            servers.add(httpServer);
            host = this.serverConfig.getHost("https");
            Server httpsServer = new Server();
            httpsServer.setUrl("https://" + host + basePath);
            servers.add(httpsServer);
            openAPI.setServers(servers);
        } else {
            String scheme = this.api.getProtocol() == 1 || this.api.getProtocol() == 0 && this.serverConfig != null ? "https" : "http";
            String host = StringUtils.isNotBlank((String)this.api.getHost()) && this.api.getPort() != -1 ? this.api.getHost() + ":" + this.api.getPort() : SwaggerConstants.DEFAULT_HOST + ":" + SwaggerConstants.DEFAULT_PORT;
            Server server = new Server();
            server.setUrl(scheme + "://" + host + basePath);
            openAPI.setServers(Arrays.asList(server));
        }
    }

    private void updateInfoSection(OpenAPI openAPI) {
        Info info = openAPI.getInfo();
        info.setTitle(this.api.getAPIName());
        if (StringUtils.isEmpty((String)info.getDescription())) {
            info.setDescription(this.api.getDescription() == null ? "API Definition of " + this.api.getAPIName() : this.api.getDescription());
        }
        info.setVersion(this.api.getVersion() != null && !this.api.getVersion().equals("") ? this.api.getVersion() : "1.0.0");
        openAPI.setInfo(info);
    }

    private void addInfoSection(OpenAPI openAPI) {
        Info info = new Info();
        info.setTitle(this.api.getAPIName());
        info.setDescription(this.api.getDescription() == null ? "API Definition of " + this.api.getAPIName() : this.api.getDescription());
        info.setVersion(this.api.getVersion() != null && !this.api.getVersion().equals("") ? this.api.getVersion() : "1.0.0");
        openAPI.setInfo(info);
    }

    private void addDefaultResponseAndPathItem(PathItem pathItem, Operation operation, Map.Entry methodEntry) {
        ApiResponses apiResponses = new ApiResponses();
        ApiResponse apiResponse = new ApiResponse();
        apiResponse.setDescription("Default response");
        apiResponses.addApiResponse("default", apiResponse);
        operation.setResponses(apiResponses);
        switch ((String)methodEntry.getKey()) {
            case "get": {
                pathItem.setGet(operation);
                break;
            }
            case "post": {
                pathItem.setPost(operation);
                break;
            }
            case "delete": {
                pathItem.setDelete(operation);
                break;
            }
            case "put": {
                pathItem.setPut(operation);
                break;
            }
            case "head": {
                pathItem.setHead(operation);
                break;
            }
            case "patch": {
                pathItem.setPatch(operation);
                break;
            }
            case "options": {
                pathItem.setOptions(operation);
            }
        }
    }

    public String getUpdatedSwaggerFromApi(String existingSwagger, boolean isJSONIn, boolean isJSONOut) throws APIGenException {
        if (this.api == null) {
            throw new APIGenException("Provided API is null");
        }
        if (StringUtils.isEmpty((String)existingSwagger)) {
            throw new APIGenException("Provided swagger definition is empty");
        }
        if (isJSONIn) {
            JsonNode jsonNodeTree = null;
            try {
                jsonNodeTree = new ObjectMapper().readTree(existingSwagger);
                existingSwagger = new YAMLMapper().writeValueAsString((Object)jsonNodeTree);
            }
            catch (JsonProcessingException e) {
                throw new APIGenException("Error occurred while converting the swagger to YAML format", e);
            }
        }
        OpenAPIV3Parser apiv3Parser = new OpenAPIV3Parser();
        SwaggerParseResult swaggerParseResult = apiv3Parser.readContents(existingSwagger);
        OpenAPI openAPI = swaggerParseResult.getOpenAPI();
        Paths paths = openAPI.getPaths();
        Paths newPaths = new Paths();
        Map<String, Object> dataMap = GenericApiObjectDefinition.getPathMap(this.api);
        for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
            PathItem pathItem;
            boolean pathItemExists = false;
            if (paths.containsKey((Object)entry.getKey())) {
                pathItem = (PathItem)paths.get((Object)entry.getKey());
                pathItemExists = true;
            } else {
                pathItem = new PathItem();
            }
            Map methodMap = (Map)entry.getValue();
            ArrayList<String> newMethodsList = new ArrayList<String>();
            for (Map.Entry methodEntry : methodMap.entrySet()) {
                Operation operation = null;
                boolean operationExists = false;
                if (pathItemExists) {
                    newMethodsList.add((String)methodEntry.getKey());
                    switch ((String)methodEntry.getKey()) {
                        case "get": {
                            operation = pathItem.getGet();
                            break;
                        }
                        case "post": {
                            operation = pathItem.getPost();
                            break;
                        }
                        case "delete": {
                            operation = pathItem.getDelete();
                            break;
                        }
                        case "put": {
                            operation = pathItem.getPut();
                            break;
                        }
                        case "head": {
                            operation = pathItem.getHead();
                            break;
                        }
                        case "patch": {
                            operation = pathItem.getPatch();
                            break;
                        }
                        case "options": {
                            operation = pathItem.getOptions();
                        }
                    }
                }
                if (operation == null) {
                    operation = new Operation();
                } else {
                    operationExists = true;
                }
                Object[] paramArr = (Object[])((Map)methodEntry.getValue()).get("parameters");
                if (operationExists) {
                    List parameters = operation.getParameters();
                    ArrayList<Parameter> newParameter = new ArrayList<Parameter>();
                    if (paramArr != null && paramArr.length > 0) {
                        for (Object o : paramArr) {
                            String paramType = (String)((Map)o).get("in");
                            String paramName = (String)((Map)o).get("name");
                            Optional<Parameter> existing = null;
                            switch (paramType) {
                                case "path": {
                                    existing = parameters.stream().filter(c -> c.getName().equals(paramName) && c instanceof PathParameter).findFirst();
                                    break;
                                }
                                case "query": {
                                    existing = parameters.stream().filter(c -> c.getName().equals(paramName) && c instanceof QueryParameter).findFirst();
                                }
                            }
                            if (existing == null || !existing.isPresent()) {
                                this.updatePathQueryAndBodyParams(operation, paramType, paramName, newParameter);
                            } else {
                                newParameter.add(existing.get());
                            }
                            this.updateDefaultResponseAndPathItem(pathItem, operation, methodEntry, operationExists);
                        }
                    } else {
                        this.updateDefaultResponseAndPathItem(pathItem, operation, methodEntry, operationExists);
                    }
                    if (newParameter.size() <= 0) continue;
                    parameters.removeIf(c -> !newParameter.contains(c) && c instanceof PathParameter);
                    continue;
                }
                this.populateParameters(pathItem, methodMap);
            }
            if (pathItemExists) {
                List<String> allMethodsList = Arrays.asList("get", "post", "put", "delete", "head", "options", "patch");
                List differences = allMethodsList.stream().filter(element -> !newMethodsList.contains(element)).collect(Collectors.toList());
                Iterator iterator = differences.iterator();
                while (iterator.hasNext()) {
                    String method;
                    switch (method = (String)iterator.next()) {
                        case "get": {
                            pathItem.setGet(null);
                            break;
                        }
                        case "post": {
                            pathItem.setPost(null);
                            break;
                        }
                        case "delete": {
                            pathItem.setDelete(null);
                            break;
                        }
                        case "put": {
                            pathItem.setPut(null);
                            break;
                        }
                        case "head": {
                            pathItem.setHead(null);
                            break;
                        }
                        case "patch": {
                            pathItem.setPatch(null);
                            break;
                        }
                        case "options": {
                            pathItem.setOptions(null);
                        }
                    }
                }
            }
            newPaths.put((Object)entry.getKey(), (Object)pathItem);
        }
        openAPI.setPaths(newPaths);
        this.updateInfoSection(openAPI);
        try {
            this.updateServersSection(openAPI);
        }
        catch (AxisFault axisFault) {
            throw new APIGenException("Error occurred while getting host details", axisFault);
        }
        try {
            if (isJSONOut) {
                return Json.mapper().writeValueAsString((Object)openAPI);
            }
            return Yaml.mapper().writeValueAsString((Object)openAPI);
        }
        catch (JsonProcessingException e) {
            throw new APIGenException("Error occurred while creating the output JAML/JSON", e);
        }
    }

    private void updatePathQueryAndBodyParams(Operation operation, String paramType, String paramName, List<Parameter> newParameters) {
        switch (paramType) {
            case "path": {
                PathParameter pathParameter = new PathParameter();
                pathParameter.setName(paramName);
                pathParameter.setSchema((Schema)new StringSchema());
                operation.addParametersItem((Parameter)pathParameter);
                newParameters.add((Parameter)pathParameter);
                break;
            }
            case "query": {
                QueryParameter queryParameter = new QueryParameter();
                queryParameter.setName(paramName);
                queryParameter.setSchema((Schema)new StringSchema());
                operation.addParametersItem((Parameter)queryParameter);
                newParameters.add((Parameter)queryParameter);
                break;
            }
            case "body": {
                if (operation.getRequestBody() != null) break;
                RequestBody requestBody = new RequestBody();
                requestBody.description("Sample Payload");
                requestBody.setRequired(Boolean.valueOf(false));
                MediaType mediaType = new MediaType();
                Schema bodySchema = new Schema();
                bodySchema.setType("object");
                HashMap<String, ObjectSchema> inputProperties = new HashMap<String, ObjectSchema>();
                ObjectSchema objectSchema = new ObjectSchema();
                bodySchema.setProperties(inputProperties);
                inputProperties.put("payload", objectSchema);
                mediaType.setSchema(bodySchema);
                Content content = new Content();
                content.addMediaType("application/json", mediaType);
                requestBody.setContent(content);
                operation.setRequestBody(requestBody);
            }
        }
    }

    private void updateDefaultResponseAndPathItem(PathItem pathItem, Operation operation, Map.Entry methodEntry, boolean isOperationExists) {
        if (operation.getResponses() == null) {
            ApiResponses apiResponses = new ApiResponses();
            ApiResponse apiResponse = new ApiResponse();
            apiResponse.setDescription("Default response");
            apiResponses.addApiResponse("default", apiResponse);
            operation.setResponses(apiResponses);
        }
        if (isOperationExists) {
            switch ((String)methodEntry.getKey()) {
                case "get": {
                    pathItem.setGet(operation);
                    break;
                }
                case "post": {
                    pathItem.setPost(operation);
                    break;
                }
                case "delete": {
                    pathItem.setDelete(operation);
                    break;
                }
                case "put": {
                    pathItem.setPut(operation);
                    break;
                }
                case "head": {
                    pathItem.setHead(operation);
                    break;
                }
                case "patch": {
                    pathItem.setPatch(operation);
                    break;
                }
                case "options": {
                    pathItem.setOptions(operation);
                }
            }
        }
    }

    private void populateParameters(PathItem pathItem, Map<String, Object> methodMap) {
        for (Map.Entry<String, Object> methodEntry : methodMap.entrySet()) {
            Operation operation = new Operation();
            Object[] paramArr = (Object[])((Map)methodEntry.getValue()).get("parameters");
            if (paramArr != null && paramArr.length > 0) {
                for (Object o : paramArr) {
                    String paramType = (String)((Map)o).get("in");
                    String paramName = (String)((Map)o).get("name");
                    this.addPathQueryAndBodyParams(operation, paramType, paramName);
                    this.addDefaultResponseAndPathItem(pathItem, operation, methodEntry);
                }
                continue;
            }
            this.addDefaultResponseAndPathItem(pathItem, operation, methodEntry);
        }
    }
}

