/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerConfigurationInformation;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;

public class AbstractServiceBusAdmin
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(AbstractServiceBusAdmin.class);

    protected SynapseConfiguration getSynapseConfiguration() {
        return (SynapseConfiguration)this.getAxisConfig().getParameter("synapse.config").getValue();
    }

    protected SynapseEnvironment getSynapseEnvironment() {
        return this.getSynapseEnvironment(this.getAxisConfig());
    }

    protected SynapseEnvironment getSynapseEnvironment(AxisConfiguration axisCfg) {
        return (SynapseEnvironment)axisCfg.getParameter("synapse.env").getValue();
    }

    protected MediationPersistenceManager getMediationPersistenceManager() {
        return ServiceBusUtils.getMediationPersistenceManager(this.getAxisConfig());
    }

    protected ServerConfigurationInformation getServerConfigurationInformation() {
        Parameter p = this.getAxisConfig().getParameter("synapse.server.config.info");
        if (p != null) {
            return (ServerConfigurationInformation)p.getValue();
        }
        return null;
    }

    protected ServerContextInformation getServerContextInformation() {
        Parameter p = this.getAxisConfig().getParameter("synapse.server.context.info");
        if (p != null) {
            return (ServerContextInformation)p.getValue();
        }
        return null;
    }

    protected Lock getLock() {
        Parameter p = this.getAxisConfig().getParameter("synapse.config.lock");
        if (p != null) {
            return (Lock)p.getValue();
        }
        log.warn((Object)"synapse.config.lock is null, Recreating a new lock");
        ReentrantLock lock = new ReentrantLock();
        try {
            this.getAxisConfig().addParameter("synapse.config.lock", (Object)lock);
            return lock;
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error while setting synapse.config.lock");
            return null;
        }
    }

    protected void lockSynapseConfiguration() {
        Lock lock = this.getLock();
        if (lock != null) {
            lock.lock();
        }
    }

    protected void unlockSynapseConfiguration() {
        Lock lock = this.getLock();
        if (lock != null) {
            lock.unlock();
        }
    }
}

