/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer.handler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.carbonext.TenantInfoConfigurator;
import org.wso2.carbon.context.PrivilegedCarbonContext;

public class CarbonTenantInfoConfigurator
implements TenantInfoConfigurator {
    private static final Log logger = LogFactory.getLog((String)CarbonTenantInfoConfigurator.class.getName());

    public boolean extractTenantInfo(MessageContext messageContext) {
        if (logger.isDebugEnabled()) {
            logger.info((Object)">>>>>>>>>>>>>>Extracting Tenant Info...");
        }
        PrivilegedCarbonContext cc = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        String tenantDomain = cc.getTenantDomain();
        int tenantId = cc.getTenantId();
        messageContext.setProperty("tenant.info.domain", (Object)tenantDomain);
        messageContext.setProperty("tenant.info.id", (Object)tenantId);
        if (logger.isDebugEnabled()) {
            logger.info((Object)("      tenant domain: " + tenantDomain));
            logger.info((Object)("      tenant id: " + tenantId));
            logger.info((Object)"<<<<<<<<<<<<<<<");
        }
        return true;
    }

    public boolean applyTenantInfo(MessageContext messageContext) {
        PrivilegedCarbonContext cc;
        if (logger.isDebugEnabled()) {
            logger.info((Object)">>>>>>>>>>>>>Applying Tenant Info...");
        }
        Object p = messageContext.getProperty("tenant.info.domain");
        String tenantDomain = "carbon.super";
        int tenantId = -1234;
        if (p != null) {
            tenantDomain = (String)p;
        }
        if ((p = messageContext.getProperty("tenant.info.id")) != null && p instanceof Integer) {
            tenantId = (Integer)p;
        }
        if ((cc = PrivilegedCarbonContext.getThreadLocalCarbonContext()).getTenantDomain() == null) {
            cc.setTenantDomain(tenantDomain);
        }
        if (cc.getTenantId() == -1) {
            cc.setTenantId(tenantId);
        }
        if (logger.isDebugEnabled()) {
            logger.info((Object)("      tenant domain: " + cc.getTenantDomain()));
            logger.info((Object)("      tenant id: " + cc.getTenantId()));
            logger.info((Object)"<<<<<<<<<<<<<<<");
        }
        return true;
    }
}

