/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.registry.persistence.dao;

import org.wso2.carbon.mediation.registry.persistence.dao.BaseDAO;
import org.wso2.carbon.mediation.registry.persistence.dataobject.BaseDO;
import org.wso2.carbon.mediation.registry.persistence.dataobject.RegistryEntryDO;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;

public class RegistryEntryDAO
extends BaseDAO {
    public RegistryEntryDAO(Registry registry) {
        super(registry);
    }

    @Override
    public void populateResource(Resource resource, BaseDO baseDO) {
        if (baseDO instanceof RegistryEntryDO) {
            RegistryEntryDO registryEntryDO = (RegistryEntryDO)baseDO;
            resource.setProperty("RegistryKey", registryEntryDO.getRegistryKey());
            resource.setProperty("ExpiryTime", String.valueOf(registryEntryDO.getExpiryTime()));
        }
    }

    @Override
    public BaseDO populateDataObject(Resource resource) {
        RegistryEntryDO registryEntryDO = new RegistryEntryDO();
        registryEntryDO.setExpiryTime(Long.parseLong(resource.getProperty("ExpiryTime")));
        registryEntryDO.setRegistryKey(resource.getProperty("RegistryKey"));
        return registryEntryDO;
    }

    public void addRegistryEntry(RegistryEntryDO registryEntryDO) {
        if (registryEntryDO != null && registryEntryDO.getRegistryKey() != null) {
            super.create(registryEntryDO.getRegistryKey(), registryEntryDO);
        } else {
            this.handleException("Invalid registry entry for add " + registryEntryDO);
        }
    }

    public void updateRegistryEntry(RegistryEntryDO registryEntryDO) {
        if (registryEntryDO != null && registryEntryDO.getRegistryKey() != null) {
            RegistryEntryDO storedEntry = this.getRegistryEntry(registryEntryDO.getRegistryKey());
            if (storedEntry != null) {
                storedEntry.setExpiryTime(registryEntryDO.getExpiryTime());
                super.update(registryEntryDO.getRegistryKey(), storedEntry);
            }
        } else {
            this.handleException("Invalid registry entry for update " + registryEntryDO);
        }
    }

    public void saveOrUpdateRegistryEntry(RegistryEntryDO registryEntryDO) {
        if (registryEntryDO != null && registryEntryDO.getRegistryKey() != null) {
            RegistryEntryDO storedEntry = this.getRegistryEntry(registryEntryDO.getRegistryKey());
            if (storedEntry != null) {
                storedEntry.setExpiryTime(registryEntryDO.getExpiryTime());
                super.update(registryEntryDO.getRegistryKey(), storedEntry);
            } else {
                super.create(registryEntryDO.getRegistryKey(), registryEntryDO);
            }
        } else {
            this.handleException("Invalid registry entry for save/update " + registryEntryDO);
        }
    }

    public RegistryEntryDO getRegistryEntry(String key) {
        return (RegistryEntryDO)super.get(key);
    }

    public void deleteRegistryEntry(String key) {
        super.delete(key);
    }
}

