/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.deployer;

import java.io.File;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.application.deployer.CarbonApplication;
import org.wso2.carbon.application.deployer.internal.ApplicationManager;
import org.wso2.carbon.utils.FileManipulator;

public class CappAxis2Deployer
extends AbstractDeployer {
    private static final Log log = LogFactory.getLog(CappAxis2Deployer.class);
    private AxisConfiguration axisConfig;
    private String cAppDir;

    public void init(ConfigurationContext configurationContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing Capp Axis2 Deployer..");
        }
        this.axisConfig = configurationContext.getAxisConfiguration();
        String appUnzipDir = AppDeployerUtils.getAppUnzipDir() + File.separator + AppDeployerUtils.getTenantIdString();
        FileManipulator.deleteDir((String)appUnzipDir);
    }

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        String artifactPath = deploymentFileData.getAbsolutePath();
        try {
            ApplicationManager.getInstance().deployCarbonApp(artifactPath, this.axisConfig);
        }
        catch (Exception e) {
            log.error((Object)("Error while deploying carbon application " + artifactPath), (Throwable)e);
        }
        super.deploy(deploymentFileData);
    }

    public void setDirectory(String s) {
        this.cAppDir = s;
    }

    public void setExtension(String s) {
    }

    public void undeploy(String filePath) throws DeploymentException {
        String tenantId = AppDeployerUtils.getTenantIdString();
        String artifactPath = AppDeployerUtils.formatPath(filePath);
        CarbonApplication existingApp = null;
        for (CarbonApplication carbonApp : ApplicationManager.getInstance().getCarbonApps(tenantId)) {
            if (!artifactPath.equals(carbonApp.getAppFilePath())) continue;
            existingApp = carbonApp;
            break;
        }
        if (existingApp != null) {
            ApplicationManager.getInstance().undeployCarbonApp(existingApp, this.axisConfig);
        } else {
            log.info((Object)("Undeploying Faulty Carbon Application On : " + filePath));
            this.removeFaultyCAppOnUndeploy(filePath);
        }
        super.undeploy(filePath);
    }

    private void removeFaultyCAppOnUndeploy(String filePath) {
        String tenantId = AppDeployerUtils.getTenantIdString();
        for (String faultyAppPath : ApplicationManager.getInstance().getFaultyCarbonApps(tenantId).keySet()) {
            if (!filePath.equals(faultyAppPath)) continue;
            ApplicationManager.getInstance().removeFaultyCarbonApp(tenantId, faultyAppPath);
            break;
        }
    }

    public void cleanup() throws DeploymentException {
        ApplicationManager.getInstance().cleanupCarbonApps(this.axisConfig);
    }
}

