/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.securevault.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.wso2.carbon.securevault.SecretCallbackHandlerService;
import org.wso2.carbon.securevault.SecretCallbackHandlerServiceImpl;
import org.wso2.carbon.securevault.SecretManagerInitializer;
import org.wso2.securevault.secret.SecretManager;

@Component(name="secret.manager.initializer.component", immediate=true)
public class SecretManagerInitializerComponent {
    private SecretManager secretManager = SecretManager.getInstance();
    private static final Log log = LogFactory.getLog(SecretManagerInitializerComponent.class);

    @Activate
    protected void activate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting 'SecretManagerInitializerComponent'");
        }
        SecretManagerInitializer secretManagerInitializer = new SecretManagerInitializer();
        SecretCallbackHandlerServiceImpl serviceImpl = secretManagerInitializer.init();
        ServiceRegistration registration = ctxt.getBundleContext().registerService(SecretCallbackHandlerService.class.getName(), (Object)serviceImpl, null);
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stopping 'SecretManagerInitializerComponent'");
        }
        this.secretManager.shoutDown();
    }
}

