/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.api;

import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.user.api.Claim;

public class ClaimMapping {
    protected Claim claim;
    protected String mappedAttribute;
    protected Map<String, String> mappedAttributes = new HashMap<String, String>();

    public ClaimMapping() {
    }

    public ClaimMapping(Claim claim, String mappedAttribute) {
        this.claim = claim;
        this.mappedAttribute = mappedAttribute;
    }

    public Claim getClaim() {
        return this.claim;
    }

    public void setClaim(Claim claim) {
        this.claim = claim;
    }

    public String getMappedAttribute() {
        return this.mappedAttribute;
    }

    public void setMappedAttribute(String mappedAttribute) {
        if (mappedAttribute != null) {
            int index = mappedAttribute.indexOf("/");
            if (index > 0) {
                String domainName = mappedAttribute.substring(0, index);
                if (domainName != null && mappedAttribute != null) {
                    this.mappedAttributes.put(domainName.toUpperCase(), mappedAttribute);
                }
            } else {
                this.mappedAttribute = mappedAttribute;
            }
        }
    }

    public void setMappedAttribute(String domainName, String mappedAttribute) {
        if (domainName != null && mappedAttribute != null) {
            this.mappedAttributes.put(domainName.toUpperCase(), mappedAttribute);
        }
        if (domainName == null) {
            this.mappedAttribute = mappedAttribute;
        }
    }

    public String getMappedAttribute(String domainName) {
        if (domainName != null) {
            return this.mappedAttributes.get(domainName.toUpperCase());
        }
        return null;
    }

    public Map<String, String> getMappedAttributes() {
        return this.mappedAttributes;
    }

    public void setMappedAttributes(Map<String, String> attrMap) {
        this.mappedAttributes = attrMap;
    }

    public void setMappedAttributeWithNoDomain(String mappedAttribute) {
        this.mappedAttribute = mappedAttribute;
    }

    public String getMappedAttributeWithNoDomain() {
        return this.mappedAttribute;
    }
}

