/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.database.utils.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import org.wso2.carbon.database.utils.jdbc.JdbcConstants;
import org.wso2.carbon.database.utils.jdbc.NamedPreparedStatement;
import org.wso2.carbon.database.utils.jdbc.NamedQueryFilter;
import org.wso2.carbon.database.utils.jdbc.RowMapper;
import org.wso2.carbon.database.utils.jdbc.TransactionManager;
import org.wso2.carbon.database.utils.jdbc.exceptions.DataAccessException;

public class NamedTemplate<T> {
    private static final Logger log = LoggerFactory.getLogger(NamedTemplate.class);

    public <T> int executeInsert(String query, NamedQueryFilter namedQueryFilter, T bean, boolean fetchInsertedId) throws DataAccessException {
        Connection connection = TransactionManager.getTransactionEntry().getConnection();
        try {
            if (fetchInsertedId) {
                int resultId;
                block40: {
                    try (NamedPreparedStatement namedPreparedStatement = new NamedPreparedStatement(connection, query);){
                        this.doInternalUpdate(namedQueryFilter, namedPreparedStatement);
                        this.logDebug("Mapping generated key (Auto Increment ID) to the object", new Object[0]);
                        try (ResultSet generatedKeys = namedPreparedStatement.getGeneratedKeys();){
                            if (generatedKeys.next()) {
                                resultId = generatedKeys.getInt(1);
                                this.logDebug("Newly inserted ID (Auto Increment ID) is {} for the bean {} ", resultId, bean);
                                break block40;
                            }
                            throw new SQLException(JdbcConstants.ErrorCodes.ERROR_CODE_AUTO_GENERATED_ID_FAILURE.getErrorMessage());
                        }
                    }
                }
                return resultId;
            }
            try (NamedPreparedStatement namedPreparedStatement = new NamedPreparedStatement(connection, query);){
                this.doInternalUpdate(namedQueryFilter, namedPreparedStatement);
            }
        }
        catch (SQLException e) {
            this.logDebug("Error in performing database insert: {} with parameters {}", query, namedQueryFilter);
            throw new DataAccessException(JdbcConstants.ErrorCodes.ERROR_CODE_DATABASE_QUERY_PERFORMING.getErrorMessage() + " " + query, JdbcConstants.ErrorCodes.ERROR_CODE_DATABASE_QUERY_PERFORMING.getErrorCode(), e);
        }
        return 0;
    }

    public <T> int executeBatchInsert(String query, NamedQueryFilter namedQueryFilter, T bean) throws DataAccessException {
        Connection connection = TransactionManager.getTransactionEntry().getConnection();
        try (NamedPreparedStatement namedPreparedStatement = new NamedPreparedStatement(connection, query);){
            this.doInternalBatchUpdate(namedQueryFilter, namedPreparedStatement);
        }
        catch (SQLException e) {
            this.logDebug("Error in performing database insert: {} with parameters {}", query, namedQueryFilter);
            throw new DataAccessException(JdbcConstants.ErrorCodes.ERROR_CODE_DATABASE_QUERY_PERFORMING_ERROR.getErrorMessage() + " " + query, e);
        }
        return 0;
    }

    public <T> List<T> executeQuery(String query, RowMapper<T> rowMapper) throws DataAccessException {
        return this.executeQuery(query, rowMapper, null);
    }

    public <T> List<T> executeQuery(String query, RowMapper<T> rowMapper, NamedQueryFilter namedQueryFilter) throws DataAccessException {
        ArrayList<T> result = new ArrayList<T>();
        Connection connection = TransactionManager.getTransactionEntry().getConnection();
        try (NamedPreparedStatement namedPreparedStatement = new NamedPreparedStatement(connection, query);){
            if (namedQueryFilter != null) {
                namedQueryFilter.filter(namedPreparedStatement);
            }
            try (ResultSet resultSet = namedPreparedStatement.executeQuery();){
                int i = 0;
                while (resultSet.next()) {
                    T row = rowMapper.mapRow(resultSet, i);
                    result.add(row);
                    ++i;
                }
            }
        }
        catch (SQLException e) {
            this.logDebug("There has been an error performing the database query. The query is {}, and the Parameters are {}", e, query, namedQueryFilter);
            throw new DataAccessException(JdbcConstants.ErrorCodes.ERROR_CODE_DATABASE_QUERY_PERFORMING_ERROR.getErrorMessage() + " " + query, e);
        }
        return result;
    }

    public <T> T fetchSingleRecord(String query, RowMapper<T> rowMapper, NamedQueryFilter namedQueryFilter) throws DataAccessException {
        T result = null;
        Connection connection = TransactionManager.getTransactionEntry().getConnection();
        try (NamedPreparedStatement namedPreparedStatement = new NamedPreparedStatement(connection, query);){
            if (namedQueryFilter != null) {
                namedQueryFilter.filter(namedPreparedStatement);
            }
            try (ResultSet resultSet = namedPreparedStatement.executeQuery();){
                if (resultSet.next()) {
                    result = rowMapper.mapRow(resultSet, 0);
                }
                if (!resultSet.isClosed() && resultSet.next()) {
                    this.logDebug("There are more records than one found for query: {} for the parameters {}", query, namedQueryFilter);
                    throw new DataAccessException(JdbcConstants.ErrorCodes.ERROR_CODE_MORE_RECORDS_IN_SINGLE_FETCH.getErrorMessage() + " " + query);
                }
            }
        }
        catch (SQLException e) {
            this.logDebug("There has been an error performing the database query. The query is {}, and the parameters are {}", e, query, rowMapper, namedQueryFilter);
            throw new DataAccessException(JdbcConstants.ErrorCodes.ERROR_CODE_DATABASE_QUERY_PERFORMING_ERROR.getErrorMessage() + " " + query, e);
        }
        return result;
    }

    public void executeUpdate(String query, NamedQueryFilter namedQueryFilter) throws DataAccessException {
        Connection connection = TransactionManager.getTransactionEntry().getConnection();
        try (NamedPreparedStatement namedPreparedStatement = new NamedPreparedStatement(connection, query);){
            if (namedQueryFilter != null) {
                namedQueryFilter.filter(namedPreparedStatement);
            }
            namedPreparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            this.logDebug("Error in performing database update: {} with parameters {}", query, namedQueryFilter);
            throw new DataAccessException(JdbcConstants.ErrorCodes.ERROR_CODE_DATABASE_QUERY_PERFORMING_ERROR.getErrorMessage() + " " + query, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(String query) throws DataAccessException {
        Connection connection = TransactionManager.getTransactionEntry().getConnection();
        try (NamedPreparedStatement namedPreparedStatement = new NamedPreparedStatement(connection, query);){
            int n = this.doInternalUpdate(null, namedPreparedStatement);
            return n;
        }
        catch (SQLException e) {
            this.logDebug("Error in performing database update: {}", query);
            throw new DataAccessException(JdbcConstants.ErrorCodes.ERROR_CODE_DATABASE_QUERY_PERFORMING_ERROR.getErrorMessage() + " " + query, e);
        }
    }

    private int doInternalUpdate(NamedQueryFilter namedQueryFilter, NamedPreparedStatement namedPreparedStatement) throws SQLException, DataAccessException {
        if (namedQueryFilter != null) {
            namedQueryFilter.filter(namedPreparedStatement);
        }
        return namedPreparedStatement.executeUpdate();
    }

    private <T> void doInternalBatchUpdate(NamedQueryFilter namedQueryFilter, NamedPreparedStatement namedPreparedStatement) throws SQLException, DataAccessException {
        if (namedQueryFilter != null) {
            namedQueryFilter.filter(namedPreparedStatement);
        }
        namedPreparedStatement.executeBatch();
    }

    private void logDebug(String s, Object ... params) {
        this.logDebug(s, null, params);
    }

    private void logDebug(String s, Exception e, Object ... params) {
        if (log.isDebugEnabled()) {
            log.debug(MessageFormatter.arrayFormat((String)s, (Object[])params).getMessage(), (Throwable)e);
        }
    }
}

