/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.view;

import com.google.auto.value.AutoValue;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.internal.view.StringPredicates;
import io.opentelemetry.sdk.metrics.view.AutoValue_InstrumentSelector;
import io.opentelemetry.sdk.metrics.view.MeterSelector;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class InstrumentSelector {
    public static Builder builder() {
        return new AutoValue_InstrumentSelector.Builder().setInstrumentNameFilter(StringPredicates.ALL).setMeterSelector(MeterSelector.builder().build());
    }

    @Nullable
    public abstract InstrumentType getInstrumentType();

    public abstract Predicate<String> getInstrumentNameFilter();

    public abstract MeterSelector getMeterSelector();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setInstrumentType(InstrumentType var1);

        public abstract Builder setInstrumentNameFilter(Predicate<String> var1);

        public final Builder setInstrumentNamePattern(Pattern instrumentNamePattern) {
            return this.setInstrumentNameFilter(StringPredicates.regex(instrumentNamePattern));
        }

        public final Builder setInstrumentName(String instrumentName) {
            return this.setInstrumentNameFilter(StringPredicates.exact(instrumentName));
        }

        public final Builder setInstrumentNameRegex(String regex) {
            return this.setInstrumentNamePattern(Pattern.compile(Objects.requireNonNull(regex, "regex")));
        }

        public abstract Builder setMeterSelector(MeterSelector var1);

        public abstract InstrumentSelector build();
    }
}

