/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.view;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import io.opentelemetry.sdk.metrics.internal.view.StringPredicates;
import io.opentelemetry.sdk.metrics.view.Aggregation;
import io.opentelemetry.sdk.metrics.view.View;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class ViewBuilder {
    @Nullable
    private String name = null;
    @Nullable
    private String description = null;
    private Aggregation aggregation = Aggregation.defaultAggregation();
    private AttributesProcessor processor = AttributesProcessor.noop();

    ViewBuilder() {
    }

    public ViewBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public ViewBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public ViewBuilder setAggregation(Aggregation aggregation) {
        this.aggregation = aggregation;
        return this;
    }

    public ViewBuilder setAttributesProcessor(AttributesProcessor processor) {
        this.processor = processor;
        return this;
    }

    public ViewBuilder filterAttributes(Predicate<String> keyFilter) {
        this.processor = this.processor.then(AttributesProcessor.filterByKeyName(keyFilter));
        return this;
    }

    public ViewBuilder filterAttributes(Pattern keyPattern) {
        this.processor = this.processor.then(AttributesProcessor.filterByKeyName(StringPredicates.regex(keyPattern)));
        return this;
    }

    public ViewBuilder appendAttributes(Attributes extraAttributes) {
        this.processor = this.processor.then(AttributesProcessor.append(extraAttributes));
        return this;
    }

    public ViewBuilder appendFilteredBaggageAttributes(Predicate<String> keyFilter) {
        this.processor = this.processor.then(AttributesProcessor.appendBaggageByKeyName(keyFilter));
        return this;
    }

    public ViewBuilder appendFilteredBaggageAttributesByPattern(Pattern keyPattern) {
        this.processor = this.processor.then(AttributesProcessor.appendBaggageByKeyName(StringPredicates.regex(keyPattern)));
        return this;
    }

    public ViewBuilder appendAllBaggageAttributes() {
        return this.appendFilteredBaggageAttributes(StringPredicates.ALL);
    }

    public View build() {
        return View.create(this.name, this.description, this.aggregation, this.processor);
    }
}

