/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.grpc;

import io.grpc.ManagedChannel;
import io.opentelemetry.exporter.internal.grpc.DefaultGrpcExporterBuilder;
import io.opentelemetry.exporter.internal.grpc.GrpcExporterBuilder;
import io.opentelemetry.exporter.internal.grpc.MarshalerServiceStub;
import io.opentelemetry.exporter.internal.grpc.OkHttpGrpcExporterBuilder;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import java.net.URI;
import java.util.function.Function;
import java.util.function.Supplier;

final class GrpcExporterUtil {
    private static final boolean USE_OKHTTP;

    static <T extends Marshaler> GrpcExporterBuilder<T> exporterBuilder(String type, long defaultTimeoutSecs, URI defaultEndpoint, Supplier<Function<ManagedChannel, MarshalerServiceStub<T, ?, ?>>> stubFactory, String grpcServiceName, String grpcEndpointPath) {
        if (USE_OKHTTP) {
            return new OkHttpGrpcExporterBuilder(type, grpcEndpointPath, defaultTimeoutSecs, defaultEndpoint);
        }
        return new DefaultGrpcExporterBuilder<T>(type, stubFactory.get(), defaultTimeoutSecs, defaultEndpoint, grpcServiceName);
    }

    private GrpcExporterUtil() {
    }

    static {
        boolean useOkhttp = true;
        try {
            Class.forName("io.grpc.stub.AbstractStub");
            useOkhttp = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        USE_OKHTTP = useOkhttp;
    }
}

