/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.restatom.collections;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Person;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.context.BaseResponseContext;
import org.apache.abdera.protocol.server.context.EmptyResponseContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.apache.abdera.protocol.server.impl.AbstractEntityCollectionAdapter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.spi.CmisRegistry;
import org.xcmis.spi.Connection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCmisCollection<T>
extends AbstractEntityCollectionAdapter<T> {
    private static final Log LOG = ExoLogger.getLogger(AbstractCmisCollection.class);

    public void deleteEntry(String resourceName, RequestContext request) throws ResponseContextException {
        throw new UnsupportedOperationException();
    }

    public Object getContent(T entry, RequestContext request) throws ResponseContextException {
        return null;
    }

    public ResponseContext postEntry(RequestContext request) {
        throw new UnsupportedOperationException();
    }

    public T postEntry(String title, IRI id, String summary, Date updated, List<Person> authors, Content content, RequestContext request) throws ResponseContextException {
        throw new UnsupportedOperationException();
    }

    public void putEntry(T entry, String title, Date updated, List<Person> authors, String summary, Content content, RequestContext request) throws ResponseContextException {
        throw new UnsupportedOperationException();
    }

    protected void addPageLinks(String id, Feed feed, String atomdocType, int maxItems, int skipCount, int total, boolean hasMore, RequestContext request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("repoid", this.getRepositoryId(request));
        params.put("atomdoctype", atomdocType);
        params.put("id", id);
        params.put("skipCount", "0");
        params.put("maxItems", Integer.toString(skipCount == 0 ? maxItems : (maxItems < skipCount ? maxItems : skipCount)));
        feed.addLink(request.absoluteUrlFor((Object)"feed", params), "first", "application/atom+xml;type=feed", null, null, -1L);
        if (skipCount > 0) {
            params.put("maxItems", Integer.toString(maxItems < skipCount ? maxItems : skipCount));
            params.put("skipCount", Integer.toString(maxItems < skipCount ? skipCount - maxItems : 0));
            feed.addLink(request.absoluteUrlFor((Object)"feed", params), "previous", "application/atom+xml;type=feed", null, null, -1L);
        }
        if (hasMore) {
            params.put("skipCount", Integer.toString(skipCount + maxItems));
            params.put("maxItems", Integer.toString(maxItems));
            feed.addLink(request.absoluteUrlFor((Object)"feed", params), "next", "application/atom+xml;type=feed", null, null, -1L);
            if (total > 0) {
                int pages = (total - skipCount) / maxItems;
                int rem = (total - skipCount) % maxItems;
                if (rem == 0) {
                    skipCount = total - maxItems;
                } else if (pages != 0) {
                    skipCount += pages * maxItems;
                }
                params.put("skipCount", Integer.toString(skipCount));
                params.put("maxItems", Integer.toString(maxItems));
                feed.addLink(request.absoluteUrlFor((Object)"feed", params), "last", "application/atom+xml;type=feed", null, null, -1L);
            }
        }
    }

    protected ResponseContext buildCreateEntryResponse(String link, Entry entry) {
        Document doc = entry.getDocument();
        BaseResponseContext rc = new BaseResponseContext((Base)doc);
        rc.setLocation(link);
        rc.setContentLocation(rc.getLocation().toString());
        rc.setStatus(201);
        return rc;
    }

    protected ResponseContext buildGetEntryResponse(RequestContext request, Entry entry) throws ResponseContextException {
        Document doc = entry.getDocument();
        BaseResponseContext rc = new BaseResponseContext((Base)doc);
        return rc;
    }

    protected ResponseContext buildGetFeedResponse(Feed feed) {
        Document document = feed.getDocument();
        BaseResponseContext rc = new BaseResponseContext((Base)document);
        return rc;
    }

    protected ResponseContext createErrorResponse(String msg, int status) {
        LOG.error((Object)msg);
        return new EmptyResponseContext(status, msg);
    }

    protected ResponseContext createErrorResponse(Throwable t, int status) {
        LOG.error((Object)t.getMessage(), t);
        return new EmptyResponseContext(status, t.getMessage());
    }

    protected String getObjectTypeLink(String id, RequestContext request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("repoid", this.getRepositoryId(request));
        params.put("atomdoctype", "typebyid");
        params.put("id", id);
        String type = request.absoluteUrlFor((Object)"ENTRY", params);
        return type;
    }

    protected String getRepositoryId(RequestContext request) {
        return request.getTarget().getParameter("repoid");
    }

    protected String getServiceLink(RequestContext request) {
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("repoid", this.getRepositoryId(request));
        String service = request.absoluteUrlFor((Object)"SERVICE", p);
        return service;
    }

    protected Connection getConnection(RequestContext request) {
        return CmisRegistry.getInstance().getConnection(this.getRepositoryId(request));
    }

    protected boolean getBooleanParameter(RequestContext request, String name, boolean defaultValue) {
        String param = request.getParameter(name);
        if (param != null && param.length() > 0) {
            return Boolean.parseBoolean(param);
        }
        return defaultValue;
    }

    protected Integer getIntegerParameter(RequestContext request, String name, Integer defaultValue) throws ResponseContextException {
        Integer result;
        String param = request.getParameter(name);
        if (param != null && param.length() > 0) {
            try {
                result = new Integer(param);
            }
            catch (NumberFormatException nfe) {
                String msg = "Invalid parameter for name '" + name + "' with value: '" + name + "'";
                throw new ResponseContextException(msg, 400);
            }
        } else {
            result = defaultValue;
        }
        return result;
    }
}

