/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.restatom.abdera;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ExtensibleElementWrapper;
import org.apache.abdera.parser.stax.FOMExtensibleElement;
import org.xcmis.restatom.AtomCMIS;
import org.xcmis.restatom.AtomUtils;
import org.xcmis.restatom.abdera.ChoiceBooleanElement;
import org.xcmis.restatom.abdera.ChoiceDateTimeElement;
import org.xcmis.restatom.abdera.ChoiceDecimalElement;
import org.xcmis.restatom.abdera.ChoiceHtmlElement;
import org.xcmis.restatom.abdera.ChoiceIdElement;
import org.xcmis.restatom.abdera.ChoiceIntegerElement;
import org.xcmis.restatom.abdera.ChoiceStringElement;
import org.xcmis.restatom.abdera.ChoiceUriElement;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.model.Choice;
import org.xcmis.spi.model.DateResolution;
import org.xcmis.spi.model.Precision;
import org.xcmis.spi.model.PropertyDefinition;
import org.xcmis.spi.model.PropertyType;
import org.xcmis.spi.model.Updatability;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyDefinitionTypeElement
extends ExtensibleElementWrapper {
    public PropertyDefinitionTypeElement(Element internal) {
        super(internal);
    }

    public PropertyDefinitionTypeElement(Factory factory, QName qname) {
        super(factory, qname);
    }

    public PropertyDefinition<?> getPropertyDefinition() {
        PropertyType propertyType;
        String propertyTypeName = this.getSimpleExtension(AtomCMIS.PROPERTY_TYPE);
        try {
            propertyType = PropertyType.fromValue((String)propertyTypeName);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidArgumentException("Unable to parse Property Definition element. Unsupported property type: " + propertyTypeName);
        }
        PropertyDefinition propDef = null;
        switch (propertyType) {
            case BOOLEAN: {
                PropertyDefinition defImpl = new PropertyDefinition();
                FOMExtensibleElement defValueElement = (FOMExtensibleElement)this.getExtension(AtomCMIS.DEFAULT_VALUE);
                if (defValueElement != null) {
                    List elements = defValueElement.getExtensions(AtomCMIS.VALUE);
                    Object[] arrayDefs = new Boolean[elements.size()];
                    int i = 0;
                    for (Element element : elements) {
                        arrayDefs[i] = Boolean.parseBoolean(element.getText());
                        ++i;
                    }
                    defImpl.setDefaultValue(arrayDefs);
                }
                List choicesElements = this.getExtensions(AtomCMIS.CHOICE);
                for (FOMExtensibleElement choiceElement : choicesElements) {
                    defImpl.getChoices().add(new ChoiceBooleanElement((Element)choiceElement).getChoice());
                }
                propDef = defImpl;
                break;
            }
            case DATETIME: {
                PropertyDefinition defImpl = new PropertyDefinition();
                FOMExtensibleElement defValueElement = (FOMExtensibleElement)this.getExtension(AtomCMIS.DEFAULT_VALUE);
                if (defValueElement != null) {
                    List elements = defValueElement.getExtensions(AtomCMIS.VALUE);
                    Object[] arrayDefs = new Calendar[elements.size()];
                    int i = 0;
                    for (Element element : elements) {
                        arrayDefs[i] = AtomUtils.parseCalendar(element.getText());
                        ++i;
                    }
                    defImpl.setDefaultValue(arrayDefs);
                }
                List choicesElements = this.getExtensions(AtomCMIS.CHOICE);
                for (FOMExtensibleElement choiceElement : choicesElements) {
                    defImpl.getChoices().add(new ChoiceDateTimeElement((Element)choiceElement).getChoice());
                }
                defImpl.setDateResolution(DateResolution.fromValue((String)this.getSimpleExtension(AtomCMIS.RESOLUTION)));
                propDef = defImpl;
                break;
            }
            case DECIMAL: {
                PropertyDefinition defImpl = new PropertyDefinition();
                FOMExtensibleElement defValueElement = (FOMExtensibleElement)this.getExtension(AtomCMIS.DEFAULT_VALUE);
                if (defValueElement != null) {
                    List elements = defValueElement.getExtensions(AtomCMIS.VALUE);
                    Object[] arrayDefs = new BigDecimal[elements.size()];
                    int i = 0;
                    for (Element element : elements) {
                        arrayDefs[i] = new BigDecimal(element.getText());
                        ++i;
                    }
                    defImpl.setDefaultValue(arrayDefs);
                }
                List choicesElements = this.getExtensions(AtomCMIS.CHOICE);
                for (FOMExtensibleElement choiceElement : choicesElements) {
                    defImpl.getChoices().add(new ChoiceDecimalElement((Element)choiceElement).getChoice());
                }
                defImpl.setMaxDecimal(new BigDecimal(this.getSimpleExtension(AtomCMIS.MAX_VALUE)));
                defImpl.setMinDecimal(new BigDecimal(this.getSimpleExtension(AtomCMIS.MIN_VALUE)));
                defImpl.setDecimalPrecision(Precision.fromValue((int)Integer.parseInt(this.getSimpleExtension(AtomCMIS.PRECISION))));
                propDef = defImpl;
                break;
            }
            case HTML: {
                PropertyDefinition defImpl = new PropertyDefinition();
                FOMExtensibleElement defValueElement = (FOMExtensibleElement)this.getExtension(AtomCMIS.DEFAULT_VALUE);
                if (defValueElement != null) {
                    List elements = defValueElement.getExtensions(AtomCMIS.VALUE);
                    Object[] arrayDefs = new String[elements.size()];
                    int i = 0;
                    for (Element element : elements) {
                        arrayDefs[i] = element.getText();
                        ++i;
                    }
                    defImpl.setDefaultValue(arrayDefs);
                }
                List choicesElements = this.getExtensions(AtomCMIS.CHOICE);
                for (FOMExtensibleElement choiceElement : choicesElements) {
                    defImpl.getChoices().add(new ChoiceHtmlElement((Element)choiceElement).getChoice());
                }
                propDef = defImpl;
                break;
            }
            case ID: {
                PropertyDefinition defImpl = new PropertyDefinition();
                FOMExtensibleElement defValueElement = (FOMExtensibleElement)this.getExtension(AtomCMIS.DEFAULT_VALUE);
                if (defValueElement != null) {
                    List elements = defValueElement.getExtensions(AtomCMIS.VALUE);
                    Object[] arrayDefs = new String[elements.size()];
                    int i = 0;
                    for (Element element : elements) {
                        arrayDefs[i] = element.getText();
                        ++i;
                    }
                    defImpl.setDefaultValue(arrayDefs);
                }
                List choicesElements = this.getExtensions(AtomCMIS.CHOICE);
                for (FOMExtensibleElement choiceElement : choicesElements) {
                    defImpl.getChoices().add(new ChoiceIdElement((Element)choiceElement).getChoice());
                }
                propDef = defImpl;
                break;
            }
            case STRING: {
                PropertyDefinition defImpl = new PropertyDefinition();
                FOMExtensibleElement defValueElement = (FOMExtensibleElement)this.getExtension(AtomCMIS.DEFAULT_VALUE);
                if (defValueElement != null) {
                    List elements = defValueElement.getExtensions(AtomCMIS.VALUE);
                    Object[] arrayDefs = new String[elements.size()];
                    int i = 0;
                    for (Element element : elements) {
                        arrayDefs[i] = element.getText();
                        ++i;
                    }
                    defImpl.setDefaultValue(arrayDefs);
                }
                List choicesElements = this.getExtensions(AtomCMIS.CHOICE);
                for (FOMExtensibleElement choiceElement : choicesElements) {
                    defImpl.getChoices().add(new ChoiceStringElement((Element)choiceElement).getChoice());
                }
                defImpl.setMaxLength(Integer.parseInt(this.getSimpleExtension(AtomCMIS.MAX_LENGTH)));
                propDef = defImpl;
                break;
            }
            case INTEGER: {
                PropertyDefinition defImpl = new PropertyDefinition();
                FOMExtensibleElement defValueElement = (FOMExtensibleElement)this.getExtension(AtomCMIS.DEFAULT_VALUE);
                if (defValueElement != null) {
                    List elements = defValueElement.getExtensions(AtomCMIS.VALUE);
                    Object[] arrayDefs = new BigInteger[elements.size()];
                    int i = 0;
                    for (Element element : elements) {
                        arrayDefs[i] = new BigInteger(element.getText());
                        ++i;
                    }
                    defImpl.setDefaultValue(arrayDefs);
                }
                List choicesElements = this.getExtensions(AtomCMIS.CHOICE);
                for (FOMExtensibleElement choiceElement : choicesElements) {
                    defImpl.getChoices().add(new ChoiceIntegerElement((Element)choiceElement).getChoice());
                }
                defImpl.setMaxInteger(new BigInteger(this.getSimpleExtension(AtomCMIS.MAX_VALUE)));
                defImpl.setMinInteger(new BigInteger(this.getSimpleExtension(AtomCMIS.MIN_VALUE)));
                propDef = defImpl;
                break;
            }
            case URI: {
                PropertyDefinition defImpl = new PropertyDefinition();
                FOMExtensibleElement defValueElement = (FOMExtensibleElement)this.getExtension(AtomCMIS.DEFAULT_VALUE);
                if (defValueElement != null) {
                    List elements = defValueElement.getExtensions(AtomCMIS.VALUE);
                    Object[] arrayDefs = new String[elements.size()];
                    int i = 0;
                    for (Element element : elements) {
                        arrayDefs[i] = element.getText();
                        ++i;
                    }
                    defImpl.setDefaultValue(arrayDefs);
                }
                List choicesElements = this.getExtensions(AtomCMIS.CHOICE);
                for (FOMExtensibleElement choiceElement : choicesElements) {
                    defImpl.getChoices().add(new ChoiceUriElement((Element)choiceElement).getChoice());
                }
                propDef = defImpl;
                break;
            }
            default: {
                throw new InvalidArgumentException("Unknown property type " + propertyType.value());
            }
        }
        propDef.setId(this.getSimpleExtension(AtomCMIS.ID));
        if (this.getSimpleExtension(AtomCMIS.LOCAL_NAME) != null) {
            propDef.setLocalName(this.getSimpleExtension(AtomCMIS.LOCAL_NAME));
        }
        if (this.getSimpleExtension(AtomCMIS.LOCAL_NAMESPACE) != null) {
            propDef.setLocalNamespace(this.getSimpleExtension(AtomCMIS.LOCAL_NAMESPACE));
        }
        if (this.getSimpleExtension(AtomCMIS.DISPLAY_NAME) != null) {
            propDef.setDisplayName(this.getSimpleExtension(AtomCMIS.DISPLAY_NAME));
        }
        propDef.setQueryName(this.getSimpleExtension(AtomCMIS.QUERY_NAME));
        if (this.getSimpleExtension(AtomCMIS.DESCRIPTION) != null) {
            propDef.setDescription(this.getSimpleExtension(AtomCMIS.DESCRIPTION));
        }
        propDef.setPropertyType(propertyType);
        String cardinality = this.getSimpleExtension(AtomCMIS.CARDINALITY);
        try {
            propDef.setMultivalued("multi".equalsIgnoreCase(cardinality));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidArgumentException("Unable to parse Property Definition element. Unsupported 'cardinality' attribute: " + cardinality);
        }
        String updatability = this.getSimpleExtension(AtomCMIS.UPDATABILITY);
        try {
            propDef.setUpdatability(Updatability.fromValue((String)updatability));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidArgumentException("Unable to parse Property Definition element. Unsupported 'updatability' attribute: " + updatability);
        }
        propDef.setInherited(this.getSimpleExtension(AtomCMIS.INHERITED) == null ? false : Boolean.parseBoolean(this.getSimpleExtension(AtomCMIS.INHERITED)));
        propDef.setRequired(Boolean.parseBoolean(this.getSimpleExtension(AtomCMIS.REQUIRED)));
        propDef.setQueryable(Boolean.parseBoolean(this.getSimpleExtension(AtomCMIS.QUERYABLE)));
        propDef.setOrderable(Boolean.parseBoolean(this.getSimpleExtension(AtomCMIS.ORDERABLE)));
        propDef.setOpenChoice(Boolean.valueOf(this.getSimpleExtension(AtomCMIS.OPEN_CHOICE) == null ? false : Boolean.parseBoolean(this.getSimpleExtension(AtomCMIS.OPEN_CHOICE))));
        return propDef;
    }

    public void build(PropertyDefinition<?> propdef) {
        if (propdef != null) {
            this.addSimpleExtension(AtomCMIS.ID, propdef.getId());
            this.addSimpleExtension(AtomCMIS.PROPERTY_TYPE, propdef.getPropertyType().value());
            this.addSimpleExtension(AtomCMIS.CARDINALITY, propdef.isMultivalued() ? "multi" : "single");
            this.addSimpleExtension(AtomCMIS.UPDATABILITY, propdef.getUpdatability().value());
            this.addSimpleExtension(AtomCMIS.QUERY_NAME, propdef.getQueryName());
            if (propdef.getLocalName() != null) {
                this.addSimpleExtension(AtomCMIS.LOCAL_NAME, propdef.getLocalName());
            }
            if (propdef.getLocalNamespace() != null) {
                this.addSimpleExtension(AtomCMIS.LOCAL_NAMESPACE, propdef.getLocalNamespace());
            }
            if (propdef.getDisplayName() != null) {
                this.addSimpleExtension(AtomCMIS.DISPLAY_NAME, propdef.getDisplayName());
            }
            if (propdef.getDescription() != null) {
                this.addSimpleExtension(AtomCMIS.DESCRIPTION, propdef.getDescription());
            }
            this.addSimpleExtension(AtomCMIS.INHERITED, propdef.getInherited() == null ? "false" : Boolean.toString(propdef.getInherited()));
            this.addSimpleExtension(AtomCMIS.REQUIRED, Boolean.toString(propdef.isRequired()));
            this.addSimpleExtension(AtomCMIS.QUERYABLE, Boolean.toString(propdef.isQueryable()));
            this.addSimpleExtension(AtomCMIS.ORDERABLE, Boolean.toString(propdef.isOrderable()));
            if (propdef.isOpenChoice() != null && propdef.isOpenChoice().booleanValue()) {
                this.addSimpleExtension(AtomCMIS.OPEN_CHOICE, Boolean.toString(propdef.isOpenChoice()));
            }
            PropertyType propertyType = propdef.getPropertyType();
            switch (propertyType) {
                case BOOLEAN: {
                    PropertyDefinition<?> defImpl = propdef;
                    if (defImpl.getDefaultValue() != null && ((Boolean[])defImpl.getDefaultValue()).length != 0) {
                        FOMExtensibleElement defValueElement = (FOMExtensibleElement)this.addExtension(AtomCMIS.DEFAULT_VALUE);
                        for (Boolean el : (Boolean[])defImpl.getDefaultValue()) {
                            defValueElement.addSimpleExtension(AtomCMIS.VALUE, el.toString());
                        }
                    }
                    if (defImpl.getChoices() == null || defImpl.getChoices().size() == 0) break;
                    List choiceList = defImpl.getChoices();
                    for (Choice choice : choiceList) {
                        FOMExtensibleElement choiceElement = (FOMExtensibleElement)this.addExtension(AtomCMIS.CHOICE);
                        new ChoiceBooleanElement((Element)choiceElement).build((Choice<Boolean>)choice);
                    }
                    break;
                }
                case DATETIME: {
                    PropertyDefinition<?> defImpl = propdef;
                    if (defImpl.getDefaultValue() != null && ((Calendar[])defImpl.getDefaultValue()).length != 0) {
                        FOMExtensibleElement defValueElement = (FOMExtensibleElement)this.addExtension(AtomCMIS.DEFAULT_VALUE);
                        for (Calendar el : (Calendar[])defImpl.getDefaultValue()) {
                            defValueElement.addSimpleExtension(AtomCMIS.VALUE, el.toString());
                        }
                    }
                    if (defImpl.getChoices() != null && defImpl.getChoices().size() != 0) {
                        List choiceList = defImpl.getChoices();
                        for (Choice choice : choiceList) {
                            FOMExtensibleElement choiceElement = (FOMExtensibleElement)this.addExtension(AtomCMIS.CHOICE);
                            new ChoiceDateTimeElement((Element)choiceElement).build((Choice<Calendar>)choice);
                        }
                    }
                    if (defImpl.getDateResolution() == null) break;
                    this.addSimpleExtension(AtomCMIS.RESOLUTION, defImpl.getDateResolution().value());
                    break;
                }
                case DECIMAL: {
                    PropertyDefinition<?> defImpl = propdef;
                    if (defImpl.getDefaultValue() != null && ((BigDecimal[])defImpl.getDefaultValue()).length != 0) {
                        FOMExtensibleElement defValueElement = (FOMExtensibleElement)this.addExtension(AtomCMIS.DEFAULT_VALUE);
                        for (BigDecimal el : (BigDecimal[])defImpl.getDefaultValue()) {
                            defValueElement.addSimpleExtension(AtomCMIS.VALUE, el.toString());
                        }
                    }
                    if (defImpl.getChoices() != null && defImpl.getChoices().size() != 0) {
                        List choiceList = defImpl.getChoices();
                        for (Choice choice : choiceList) {
                            FOMExtensibleElement choiceElement = (FOMExtensibleElement)this.addExtension(AtomCMIS.CHOICE);
                            new ChoiceDecimalElement((Element)choiceElement).build((Choice<BigDecimal>)choice);
                        }
                    }
                    if (defImpl.getMaxDecimal() != null) {
                        this.addSimpleExtension(AtomCMIS.MAX_VALUE, defImpl.getMaxDecimal().toString());
                    }
                    if (defImpl.getMinDecimal() != null) {
                        this.addSimpleExtension(AtomCMIS.MIN_VALUE, defImpl.getMinDecimal().toString());
                    }
                    if (defImpl.getDecimalPrecision() == null) break;
                    String precision = Integer.toString(defImpl.getDecimalPrecision().getValue());
                    this.addSimpleExtension(AtomCMIS.PRECISION, precision);
                    break;
                }
                case HTML: {
                    PropertyDefinition<?> defImpl = propdef;
                    if (defImpl.getDefaultValue() != null && ((String[])defImpl.getDefaultValue()).length != 0) {
                        FOMExtensibleElement defValueElement = (FOMExtensibleElement)this.addExtension(AtomCMIS.DEFAULT_VALUE);
                        for (String el : (String[])defImpl.getDefaultValue()) {
                            defValueElement.addSimpleExtension(AtomCMIS.VALUE, el.toString());
                        }
                    }
                    if (defImpl.getChoices() == null || defImpl.getChoices().size() == 0) break;
                    List choiceList = defImpl.getChoices();
                    for (Choice choice : choiceList) {
                        FOMExtensibleElement choiceElement = (FOMExtensibleElement)this.addExtension(AtomCMIS.CHOICE);
                        new ChoiceHtmlElement((Element)choiceElement).build((Choice<String>)choice);
                    }
                    break;
                }
                case ID: {
                    PropertyDefinition<?> defImpl = propdef;
                    if (defImpl.getDefaultValue() != null && ((String[])defImpl.getDefaultValue()).length != 0) {
                        FOMExtensibleElement defValueElement = (FOMExtensibleElement)this.addExtension(AtomCMIS.DEFAULT_VALUE);
                        for (String el : (String[])defImpl.getDefaultValue()) {
                            defValueElement.addSimpleExtension(AtomCMIS.VALUE, el.toString());
                        }
                    }
                    if (defImpl.getChoices() == null || defImpl.getChoices().size() == 0) break;
                    List choiceList = defImpl.getChoices();
                    for (Choice choice : choiceList) {
                        FOMExtensibleElement choiceElement = (FOMExtensibleElement)this.addExtension(AtomCMIS.CHOICE);
                        new ChoiceIdElement((Element)choiceElement).build((Choice<String>)choice);
                    }
                    break;
                }
                case STRING: {
                    PropertyDefinition<?> defImpl = propdef;
                    if (defImpl.getDefaultValue() != null && ((String[])defImpl.getDefaultValue()).length != 0) {
                        FOMExtensibleElement defValueElement = (FOMExtensibleElement)this.addExtension(AtomCMIS.DEFAULT_VALUE);
                        for (String el : (String[])defImpl.getDefaultValue()) {
                            defValueElement.addSimpleExtension(AtomCMIS.VALUE, el.toString());
                        }
                    }
                    if (defImpl.getChoices() != null && defImpl.getChoices().size() != 0) {
                        List choiceList = defImpl.getChoices();
                        for (Choice choice : choiceList) {
                            FOMExtensibleElement choiceElement = (FOMExtensibleElement)this.addExtension(AtomCMIS.CHOICE);
                            new ChoiceStringElement((Element)choiceElement).build((Choice<String>)choice);
                        }
                    }
                    this.addSimpleExtension(AtomCMIS.MAX_LENGTH, Integer.toString(defImpl.getMaxLength()));
                    break;
                }
                case INTEGER: {
                    PropertyDefinition<?> defImpl = propdef;
                    if (defImpl.getDefaultValue() != null && ((BigInteger[])defImpl.getDefaultValue()).length != 0) {
                        FOMExtensibleElement defValueElement = (FOMExtensibleElement)this.addExtension(AtomCMIS.DEFAULT_VALUE);
                        for (BigInteger el : (BigInteger[])defImpl.getDefaultValue()) {
                            defValueElement.addSimpleExtension(AtomCMIS.VALUE, el.toString());
                        }
                    }
                    if (defImpl.getChoices() != null && defImpl.getChoices().size() != 0) {
                        List choiceList = defImpl.getChoices();
                        for (Choice choice : choiceList) {
                            FOMExtensibleElement choiceElement = (FOMExtensibleElement)this.addExtension(AtomCMIS.CHOICE);
                            new ChoiceIntegerElement((Element)choiceElement).build((Choice<BigInteger>)choice);
                        }
                    }
                    if (defImpl.getMaxInteger() != null) {
                        this.addSimpleExtension(AtomCMIS.MAX_VALUE, defImpl.getMaxInteger().toString());
                    }
                    if (defImpl.getMinInteger() == null) break;
                    this.addSimpleExtension(AtomCMIS.MIN_VALUE, defImpl.getMinInteger().toString());
                    break;
                }
                case URI: {
                    PropertyDefinition<?> defImpl = propdef;
                    if (defImpl.getDefaultValue() != null && ((String[])defImpl.getDefaultValue()).length != 0) {
                        FOMExtensibleElement defValueElement = (FOMExtensibleElement)this.addExtension(AtomCMIS.DEFAULT_VALUE);
                        for (String el : (String[])defImpl.getDefaultValue()) {
                            defValueElement.addSimpleExtension(AtomCMIS.VALUE, el.toString());
                        }
                    }
                    if (defImpl.getChoices() == null || defImpl.getChoices().size() == 0) break;
                    List choiceList = defImpl.getChoices();
                    for (Choice choice : choiceList) {
                        FOMExtensibleElement choiceElement = (FOMExtensibleElement)this.addExtension(AtomCMIS.CHOICE);
                        new ChoiceUriElement((Element)choiceElement).build((Choice<String>)choice);
                    }
                    break;
                }
                default: {
                    throw new InvalidArgumentException("Unknown property type " + propertyType.value());
                }
            }
        }
    }
}

