/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.restatom;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Link;
import org.apache.abdera.model.Service;
import org.apache.abdera.model.Workspace;
import org.apache.abdera.parser.stax.FOMExtensibleElement;
import org.apache.abdera.protocol.server.CollectionInfo;
import org.apache.abdera.protocol.server.Provider;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.WorkspaceInfo;
import org.apache.abdera.protocol.server.context.BaseResponseContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.apache.abdera.protocol.server.servlet.ServletRequestContext;
import org.apache.commons.fileupload.FileItem;
import org.xcmis.restatom.AbderaFactory;
import org.xcmis.restatom.AtomCMIS;
import org.xcmis.restatom.CmisCollectionInfo;
import org.xcmis.restatom.ProviderImpl;
import org.xcmis.restatom.WorkspaceManagerImpl;
import org.xcmis.restatom.abdera.AccessControlEntryTypeElement;
import org.xcmis.restatom.abdera.AllowableActionsElement;
import org.xcmis.restatom.abdera.RepositoryInfoTypeElement;
import org.xcmis.restatom.abdera.UriTemplateTypeElement;
import org.xcmis.restatom.collections.AbstractCmisCollection;
import org.xcmis.restatom.types.CmisUriTemplateType;
import org.xcmis.spi.CmisRegistry;
import org.xcmis.spi.Connection;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.UpdateConflictException;
import org.xcmis.spi.model.AccessControlEntry;
import org.xcmis.spi.model.AccessControlPropagation;
import org.xcmis.spi.model.AllowableActions;
import org.xcmis.spi.model.CapabilityChanges;
import org.xcmis.spi.model.RepositoryCapabilities;
import org.xcmis.spi.model.RepositoryInfo;
import org.xcmis.spi.model.RepositoryShortInfo;
import org.xcmis.spi.model.UnfileObject;

@Path(value="cmisatom")
public class AtomCmisService {
    protected ProviderImpl provider;

    public AtomCmisService(ProviderImpl provider) {
        this.provider = provider;
    }

    @PUT
    @Path(value="{repositoryId}/objacl/{objectId}")
    @Produces(value={"application/cmisacl+xml"})
    public Response addACL(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId, @PathParam(value="objectId") String objectId) {
        Connection connection = null;
        try {
            connection = CmisRegistry.getInstance().getConnection(repositoryId);
            RequestContext request = this.initRequestContext(httpRequest);
            Document doc = request.getDocument();
            List listEl = doc.getRoot().getElements();
            ArrayList<AccessControlEntry> listACE = new ArrayList<AccessControlEntry>();
            for (AccessControlEntryTypeElement el : listEl) {
                listACE.add(el.getACE());
            }
            ArrayList removeACL = new ArrayList();
            connection.applyACL(objectId, listACE, removeACL, AccessControlPropagation.REPOSITORYDETERMINED);
            List list = connection.getACL(objectId, false);
            FOMExtensibleElement accessControlListTypeElement = (FOMExtensibleElement)AbderaFactory.getInstance().getFactory().newElement(AtomCMIS.ACL);
            for (AccessControlEntry accessControlEntry : list) {
                AccessControlEntryTypeElement ace = (AccessControlEntryTypeElement)accessControlListTypeElement.addExtension(AtomCMIS.PERMISSION);
                ace.build(accessControlEntry);
            }
            Response response = Response.ok((Object)accessControlListTypeElement).header("Cache-Control", (Object)"no-cache").build();
            return response;
        }
        catch (IOException io) {
            throw new WebApplicationException((Throwable)io, this.createErrorResponse(io, 500));
        }
        catch (Throwable t) {
            throw new WebApplicationException(t, this.createErrorResponse(t, 500));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @POST
    @Path(value="{repositoryId}/types")
    @RolesAllowed(value={"administrators"})
    public Response addType(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        return this.createItem(repositoryId, httpRequest);
    }

    @POST
    @Path(value="{repositoryId}/policies/{objectId}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Response applyPolicy(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        return this.createItem(repositoryId, httpRequest);
    }

    @POST
    @Path(value="{repositoryId}/checkedout")
    public Response checkOut(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) throws Exception {
        return this.createItem(repositoryId, httpRequest);
    }

    @POST
    @Path(value="{repositoryId}/children/{folderId}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Response createChild(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        return this.createItem(repositoryId, httpRequest);
    }

    @POST
    @Path(value="{repositoryId}/object/{folderId}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Response createChildObj(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        return this.createItem(repositoryId, httpRequest);
    }

    @POST
    @Path(value="{repositoryId}/relationships/{objectId}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Response createRelationship(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        return this.createItem(repositoryId, httpRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{repositoryId}/file/{objectId}")
    public Response deleteContentStream(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        RequestContext request = this.initRequestContext(httpRequest);
        Connection connection = null;
        try {
            connection = CmisRegistry.getInstance().getConnection(repositoryId);
            AbstractCmisCollection<?> collection = this.getCollection(request, connection);
            ResponseContext abderaResponse = collection.deleteMedia(request);
            Response response = Response.status((int)abderaResponse.getStatus()).entity((Object)abderaResponse).build();
            return response;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @DELETE
    @Path(value="{repositoryId}/object/{objectId}")
    public Response deleteObject(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        return this.deleteItem(repositoryId, httpRequest);
    }

    @DELETE
    @Path(value="{repositoryId}/foldertree/{folderId}")
    public Response deleteFolderTree(@PathParam(value="repositoryId") String repositoryId, @PathParam(value="folderId") String folderId, @QueryParam(value="unfileObject") String unfileNonfolderObjects, @DefaultValue(value="false") @QueryParam(value="continueOnFailure") boolean continueOnFailure) {
        return this.deleteDescendants(repositoryId, folderId, unfileNonfolderObjects, continueOnFailure);
    }

    @DELETE
    @Path(value="{repositoryId}/descendants/{folderId}")
    public Response deleteDescendants(@PathParam(value="repositoryId") String repositoryId, @PathParam(value="folderId") String folderId, @QueryParam(value="unfileObject") String unfileNonfolderObjects, @DefaultValue(value="false") @QueryParam(value="continueOnFailure") boolean continueOnFailure) {
        UnfileObject unfileObject;
        try {
            unfileObject = unfileNonfolderObjects == null ? UnfileObject.DELETE : UnfileObject.fromValue((String)unfileNonfolderObjects);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unsupported 'unfileObject' attribute: " + unfileNonfolderObjects);
        }
        Connection connection = null;
        try {
            connection = CmisRegistry.getInstance().getConnection(repositoryId);
            Boolean deleteAllVersions = true;
            connection.deleteTree(folderId, deleteAllVersions, unfileObject, Boolean.valueOf(continueOnFailure));
            Response response = Response.noContent().build();
            return response;
        }
        catch (UpdateConflictException uce) {
            throw new WebApplicationException((Throwable)uce, this.createErrorResponse(uce, 409));
        }
        catch (ObjectNotFoundException onfe) {
            throw new WebApplicationException((Throwable)onfe, this.createErrorResponse(onfe, 404));
        }
        catch (InvalidArgumentException iae) {
            throw new WebApplicationException((Throwable)iae, this.createErrorResponse(iae, 400));
        }
        catch (Throwable t) {
            throw new WebApplicationException(t, this.createErrorResponse(t, 500));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @DELETE
    @Path(value="{repositoryId}/types/{typeId}")
    @RolesAllowed(value={"administrators"})
    public Response deleteType(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        return this.deleteItem(repositoryId, httpRequest);
    }

    @GET
    @Path(value="{repositoryId}/objacl/{objectId}")
    @Produces(value={"application/cmisacl+xml"})
    public Response getACL(@PathParam(value="repositoryId") String repositoryId, @PathParam(value="objectId") String objectId, @DefaultValue(value="true") @QueryParam(value="onlyBasicPermissions") boolean onlyBasicPermissions) {
        Connection connection = null;
        try {
            connection = CmisRegistry.getInstance().getConnection(repositoryId);
            List list = connection.getACL(objectId, onlyBasicPermissions);
            FOMExtensibleElement accessControlListTypeElement = (FOMExtensibleElement)AbderaFactory.getInstance().getFactory().newElement(AtomCMIS.ACL);
            for (AccessControlEntry accessControlEntry : list) {
                AccessControlEntryTypeElement ace = (AccessControlEntryTypeElement)accessControlListTypeElement.addExtension(AtomCMIS.PERMISSION);
                ace.build(accessControlEntry);
            }
            Response response = Response.ok((Object)accessControlListTypeElement).header("Cache-Control", (Object)"no-cache").build();
            return response;
        }
        catch (InvalidArgumentException iae) {
            throw new WebApplicationException((Throwable)iae, this.createErrorResponse(iae, 400));
        }
        catch (Throwable others) {
            throw new WebApplicationException(others, this.createErrorResponse(others, 500));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @GET
    @Path(value="{repositoryId}/allowableactions/{objectId}")
    @Produces(value={"application/atom+xml;type=allowableActions"})
    public Response getAllowableActions(@PathParam(value="repositoryId") String repositoryId, @PathParam(value="objectId") String objectId) {
        Connection connection = null;
        try {
            connection = CmisRegistry.getInstance().getConnection(repositoryId);
            AllowableActions result = connection.getAllowableActions(objectId);
            AllowableActionsElement el = (AllowableActionsElement)AbderaFactory.getInstance().getFactory().newElement(AtomCMIS.ALLOWABLE_ACTIONS);
            el.build(result);
            Response response = Response.ok((Object)((Object)el)).header("Cache-Control", (Object)"no-cache").build();
            return response;
        }
        catch (ObjectNotFoundException onfe) {
            throw new WebApplicationException((Throwable)onfe, this.createErrorResponse(onfe, 404));
        }
        catch (InvalidArgumentException iae) {
            throw new WebApplicationException((Throwable)iae, this.createErrorResponse(iae, 400));
        }
        catch (Throwable others) {
            throw new WebApplicationException(others, this.createErrorResponse(others, 500));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @GET
    @Path(value="{repositoryId}/typedescendants")
    @Produces(value={"application/cmistree+xml"})
    public Response getAllTypeDescendants(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        return this.getFeed(repositoryId, httpRequest);
    }

    @GET
    @Path(value="{repositoryId}/types")
    @Produces(value={"application/atom+xml;type=entry"})
    public Response getAllTypes(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        return this.getTypes(httpRequest, repositoryId);
    }

    @GET
    @Path(value="{repositoryId}/versions/{versionSeriesId:.+}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Response getAllVersions(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        return this.getFeed(repositoryId, httpRequest);
    }

    @GET
    @Path(value="{repositoryId}/policies/{objectId}")
    public Response getAppliedPolicies(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        return this.getFeed(repositoryId, httpRequest);
    }

    @GET
    @Path(value="{repositoryId}/changes")
    public Response getContentChanges(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        return this.getFeed(repositoryId, httpRequest);
    }

    @GET
    @Path(value="{repositoryId}/checkedout")
    public Response getCheckedOut(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        return this.getFeed(repositoryId, httpRequest);
    }

    @GET
    @Path(value="{repositoryId}/children/{folderId}")
    @Produces(value={"application/atom+xml;type=feed"})
    public Response getChildren(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        return this.getFeed(repositoryId, httpRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{repositoryId}/file/{documentId}")
    public Response getContentStream(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        RequestContext request = this.initRequestContext(httpRequest);
        Connection connection = null;
        try {
            connection = CmisRegistry.getInstance().getConnection(repositoryId);
            AbstractCmisCollection<?> collection = this.getCollection(request, connection);
            ResponseContext abderaResponse = collection.getMedia(request);
            Response.ResponseBuilder builder = Response.status((int)abderaResponse.getStatus());
            this.copyAbderaHeaders(builder, abderaResponse);
            builder.entity((Object)abderaResponse);
            Response response = builder.build();
            return response;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @GET
    @Path(value="{repositoryId}/descendants/{folderId}")
    @Produces(value={"application/cmistree+xml"})
    public Response getDescendants(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        return this.getFeed(repositoryId, httpRequest);
    }

    @GET
    @Path(value="{repositoryId}/foldertree/{folderId}")
    @Produces(value={"application/atom+xml;type=feed"})
    public Response getFolderTree(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        return this.getFeed(repositoryId, httpRequest);
    }

    @GET
    @Path(value="{repositoryId}/object/{objectId}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Response getObjectById(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        return this.getEntry(repositoryId, httpRequest);
    }

    @GET
    @Path(value="{repositoryId}/objectbypath")
    @Produces(value={"application/atom+xml;type=entry"})
    public Response getObjectByPath(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        return this.getEntry(repositoryId, httpRequest);
    }

    @GET
    @Path(value="{repositoryId}/parents/{objectId}")
    public Response getObjectParents(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        return this.getFeed(repositoryId, httpRequest);
    }

    @GET
    @Path(value="{repositoryId}/relationships/{objectId}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Response getRelationships(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        return this.getFeed(repositoryId, httpRequest);
    }

    @GET
    @Path(value="{repositoryId}/alternate/{documentId}/{streamId}")
    public Response getRendition(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId, @PathParam(value="documentId") String documentId) {
        return this.getContentStream(httpRequest, repositoryId);
    }

    @GET
    public Response getRepositories(@Context HttpServletRequest httpRequest, @Context UriInfo uriInfo) {
        String repositoryId = httpRequest.getParameter("repositoryId");
        if (repositoryId != null && !repositoryId.isEmpty()) {
            return this.makeRepositoryInfoResponse(httpRequest, uriInfo.getBaseUri(), repositoryId);
        }
        Service service = AbderaFactory.getInstance().getFactory().newService();
        service.declareNS("http://docs.oasis-open.org/ns/cmis/restatom/200908/", "cmisra");
        Set shortInfos = CmisRegistry.getInstance().getStorageInfos();
        RequestContext request = this.initRequestContext(httpRequest);
        if (shortInfos != null && !shortInfos.isEmpty()) {
            for (RepositoryShortInfo info : shortInfos) {
                Workspace ws = service.addWorkspace(info.getRepositoryId());
                ws.setTitle(info.getRepositoryName());
                RepositoryInfoTypeElement repoInfoElement = (RepositoryInfoTypeElement)ws.addExtension(AtomCMIS.REPOSITORY_INFO);
                repoInfoElement.addSimpleExtension(AtomCMIS.REPOSITORY_ID, info.getRepositoryId());
                repoInfoElement.addSimpleExtension(AtomCMIS.REPOSITORY_NAME, info.getRepositoryName());
                repoInfoElement.addSimpleExtension(AtomCMIS.ROOT_FOLDER_ID, info.getRootFolderId());
                String repoPath = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path(this.getClass()).path(info.getRepositoryId()).build(new Object[0]).toString();
                Collection<CollectionInfo> collectionsInfo = this.getCollectionsInfo(request);
                for (CollectionInfo collectionInfo : collectionsInfo) {
                    CmisCollectionInfo cmisCollectionInfo = (CmisCollectionInfo)collectionInfo;
                    String collectionType = cmisCollectionInfo.getCollectionType();
                    if ("root".equals(collectionType)) {
                        ws.addCollection(((CmisCollectionInfo)collectionInfo).asCollectionElement(request, repoPath, info.getRootFolderId()));
                        continue;
                    }
                    ws.addCollection(((CmisCollectionInfo)collectionInfo).asCollectionElement(request, repoPath, new String[0]));
                }
                this.includeURITemplates(ws, repoPath);
            }
        }
        return Response.ok().entity((Object)service).header("Cache-Control", (Object)"no-cache").type("application/atom+xml").build();
    }

    @GET
    @Path(value="{repositoryId}")
    public Response getRepositoryInfo(@Context HttpServletRequest httpRequest, @Context UriInfo uriInfo, @PathParam(value="repositoryId") String repositoryId) {
        String queryRepositoryId = httpRequest.getParameter("repositoryId");
        if (queryRepositoryId != null && !queryRepositoryId.isEmpty()) {
            return this.makeRepositoryInfoResponse(httpRequest, uriInfo.getBaseUri(), queryRepositoryId);
        }
        return this.makeRepositoryInfoResponse(httpRequest, uriInfo.getBaseUri(), repositoryId);
    }

    private Response makeRepositoryInfoResponse(HttpServletRequest httpRequest, URI baseUri, String repositoryId) {
        Service service = AbderaFactory.getInstance().getFactory().newService();
        service.declareNS("http://docs.oasis-open.org/ns/cmis/core/200908/", "cmis");
        service.declareNS("http://docs.oasis-open.org/ns/cmis/restatom/200908/", "cmisra");
        this.addCmisRepository(httpRequest, service, repositoryId, baseUri);
        Document serviceDocument = service.getDocument();
        serviceDocument.setCharset("utf-8");
        BaseResponseContext abderaResponse = new BaseResponseContext((Base)serviceDocument);
        abderaResponse.setStatus(200);
        return Response.ok((Object)abderaResponse).header("Cache-Control", (Object)"no-cache").type("application/atom+xml").build();
    }

    @GET
    @Path(value="{repositoryId}/typebyid/{typeId}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Response getTypeById(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        return this.getEntry(repositoryId, httpRequest);
    }

    @GET
    @Path(value="{repositoryId}/typedescendants/{typeId}")
    @Produces(value={"application/cmistree+xml"})
    public Response getTypeDescendants(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        return this.getFeed(repositoryId, httpRequest);
    }

    @GET
    @Path(value="{repositoryId}/types/{typeId}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Response getTypes(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        return this.getFeed(repositoryId, httpRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{repositoryId}/query")
    public Response query(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        RequestContext request = this.initRequestContext(httpRequest);
        Connection connection = null;
        try {
            connection = CmisRegistry.getInstance().getConnection(repositoryId);
            AbstractCmisCollection<?> collection = this.getCollection(request, connection);
            ResponseContext abderaResponse = collection.getFeed(request);
            Response.ResponseBuilder builder = Response.status((int)(abderaResponse.getStatus() == 200 ? 201 : abderaResponse.getStatus()));
            this.copyAbderaHeaders(builder, abderaResponse);
            builder.header("Cache-Control", (Object)"no-cache");
            Response response = builder.entity((Object)abderaResponse).build();
            return response;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @GET
    @Path(value="{repositoryId}/query")
    public Response queryGET(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        return this.getFeed(repositoryId, httpRequest);
    }

    @DELETE
    @Path(value="{repositoryId}/policies/{objectId}")
    public Response removePolicy(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        return this.deleteItem(repositoryId, httpRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{repositoryId}/file/{objectId}")
    public Response setContentStream(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        RequestContext request = this.initRequestContext(httpRequest);
        Connection connection = null;
        try {
            connection = CmisRegistry.getInstance().getConnection(repositoryId);
            AbstractCmisCollection<?> collection = this.getCollection(request, connection);
            ResponseContext abderaResponse = collection.putMedia(request);
            Response.ResponseBuilder builder = Response.status((int)abderaResponse.getStatus());
            this.copyAbderaHeaders(builder, abderaResponse);
            Response response = builder.entity((Object)abderaResponse).build();
            return response;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{repositoryId}/file/{objectId}")
    @Consumes(value={"multipart/form-data"})
    public Response setContentStream(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId, @QueryParam(value="Content-Type") String contentType, Iterator<FileItem> files) {
        FileItem file;
        if (files.hasNext() && !(file = files.next()).isFormField()) {
            Response response;
            block10: {
                if (contentType == null) {
                    contentType = file.getContentType();
                }
                RequestContext request = this.initRequestContext(httpRequest);
                Connection connection = null;
                try {
                    connection = CmisRegistry.getInstance().getConnection(repositoryId);
                    AbstractCmisCollection<?> collection = this.getCollection(request, connection);
                    collection.putMedia(null, new MimeType(contentType), null, file.getInputStream(), request);
                    response = Response.status((int)201).build();
                    if (connection == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        throw new WebApplicationException((Throwable)ioe, this.createErrorResponse(ioe, 500));
                    }
                    catch (ResponseContextException rce) {
                        throw new WebApplicationException((Throwable)rce, this.createErrorResponse(rce, rce.getResponseContext().getStatus()));
                    }
                    catch (MimeTypeParseException mte) {
                        throw new WebApplicationException((Throwable)mte, this.createErrorResponse(mte, 400));
                    }
                }
                connection.close();
            }
            return response;
        }
        throw new WebApplicationException((Throwable)new InvalidArgumentException("Content of document is missing."), 400);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{repositoryId}/object/{objectId}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Response updateProperties(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        RequestContext request = this.initRequestContext(httpRequest);
        Connection connection = null;
        try {
            connection = CmisRegistry.getInstance().getConnection(repositoryId);
            AbstractCmisCollection<?> collection = this.getCollection(request, connection);
            ResponseContext abderaResponse = collection.putEntry(request);
            Response.ResponseBuilder builder = Response.status((int)abderaResponse.getStatus());
            this.copyAbderaHeaders(builder, abderaResponse);
            Response response = builder.entity((Object)abderaResponse).build();
            return response;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private void copyAbderaHeaders(Response.ResponseBuilder responseBuilder, ResponseContext abderaResponse) {
        for (String headerName : abderaResponse.getHeaderNames()) {
            for (Object v : abderaResponse.getHeaders(headerName)) {
                responseBuilder.header(headerName, (Object)v.toString());
            }
        }
    }

    @POST
    @Path(value="{repositoryId}/unfiled")
    public Response unfile(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) throws Exception {
        return this.createItem(repositoryId, httpRequest);
    }

    @GET
    @Path(value="{repositoryId}/unfiled")
    public Response getUnfiled(@Context HttpServletRequest httpRequest, @PathParam(value="repositoryId") String repositoryId) {
        return this.getFeed(repositoryId, httpRequest);
    }

    private Workspace addCmisRepository(HttpServletRequest httpRequest, Service service, String repositoryId, URI baseUri) {
        Link treeLink;
        RepositoryInfo repoInfo;
        Connection connection = null;
        try {
            connection = CmisRegistry.getInstance().getConnection(repositoryId);
            repoInfo = connection.getStorage().getRepositoryInfo();
        }
        catch (InvalidArgumentException iae) {
            throw new WebApplicationException((Throwable)iae, this.createErrorResponse(iae, 400));
        }
        catch (Throwable others) {
            throw new WebApplicationException(others, this.createErrorResponse(others, 500));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        Workspace ws = service.addWorkspace(repositoryId);
        ws.setTitle(repoInfo.getRepositoryName());
        RepositoryInfoTypeElement repoInfoElement = (RepositoryInfoTypeElement)ws.addExtension(AtomCMIS.REPOSITORY_INFO);
        repoInfoElement.build(repoInfo);
        String repoPath = UriBuilder.fromUri((URI)baseUri).path(this.getClass()).path(repositoryId).build(new Object[0]).toString();
        RequestContext request = this.initRequestContext(httpRequest);
        Collection<CollectionInfo> collectionsInfo = this.getCollectionsInfo(request);
        for (CollectionInfo collectionInfo : collectionsInfo) {
            CmisCollectionInfo cmisCollectionInfo = (CmisCollectionInfo)collectionInfo;
            String collectionType = cmisCollectionInfo.getCollectionType();
            if ("root".equals(collectionType)) {
                ws.addCollection(((CmisCollectionInfo)collectionInfo).asCollectionElement(request, repoPath, repoInfo.getRootFolderId()));
                continue;
            }
            ws.addCollection(((CmisCollectionInfo)collectionInfo).asCollectionElement(request, repoPath, new String[0]));
        }
        this.includeURITemplates(ws, repoPath);
        Factory factory = AbderaFactory.getInstance().getFactory();
        Link typeTypeDescendantsLink = factory.newLink((Element)ws);
        typeTypeDescendantsLink.setTitle("Type descendants");
        typeTypeDescendantsLink.setRel("http://docs.oasis-open.org/ns/cmis/link/200908/typedescendants");
        typeTypeDescendantsLink.setMimeType("application/cmistree+xml");
        typeTypeDescendantsLink.setHref(repoPath + "/typedescendants");
        RepositoryCapabilities capabilities = repoInfo.getCapabilities();
        if (capabilities.isCapabilityGetDescendants()) {
            Link descendantsLink = factory.newLink((Element)ws);
            descendantsLink.setTitle("Root folder descendants");
            descendantsLink.setRel("http://docs.oasis-open.org/ns/cmis/link/200908/rootdescendants");
            descendantsLink.setMimeType("application/cmistree+xml");
            descendantsLink.setHref(repoPath + "/descendants/" + repoInfo.getRootFolderId());
        }
        if (capabilities.isCapabilityGetFolderTree()) {
            treeLink = factory.newLink((Element)ws);
            treeLink.setTitle("Root folder tree");
            treeLink.setRel("http://docs.oasis-open.org/ns/cmis/link/200908/foldertree");
            treeLink.setMimeType("application/cmistree+xml");
            treeLink.setHref(repoPath + "/foldertree/" + repoInfo.getRootFolderId());
        }
        if (CapabilityChanges.NONE != capabilities.getCapabilityChanges()) {
            treeLink = factory.newLink((Element)ws);
            treeLink.setTitle("Changes log");
            treeLink.setRel("http://docs.oasis-open.org/ns/cmis/link/200908/changes");
            treeLink.setMimeType("application/atom+xml;type=feed");
            treeLink.setHref(repoPath + "/changes");
        }
        return ws;
    }

    private void includeURITemplates(Workspace ws, String repoPath) {
        CmisUriTemplateType objectById = new CmisUriTemplateType();
        objectById.setMediatype("application/atom+xml;type=entry");
        objectById.setTemplate(repoPath + "/object/{id}?" + "filter={filter}&" + "includeAllowableActions={includeAllowableActions}&" + "includePolicyIds={includePolicyIds}&" + "includeRelationships={includeRelationships}&" + "includeACL={includeACL}&" + "renditionFilter={renditionFilter}");
        objectById.setType("objectbyid");
        UriTemplateTypeElement objectByIdElement = (UriTemplateTypeElement)ws.addExtension(AtomCMIS.URITEMPLATE);
        objectByIdElement.build(objectById);
        CmisUriTemplateType objectByPath = new CmisUriTemplateType();
        objectByPath.setMediatype("application/atom+xml;type=entry");
        objectByPath.setTemplate(repoPath + "/objectbypath?" + "path={path}&" + "filter={filter}&" + "includeAllowableActions={includeAllowableActions}&" + "includePolicyIds={includePolicyIds}&" + "includeRelationships={includeRelationships}&" + "includeACL={includeACL}&" + "renditionFilter={renditionFilter}");
        objectByPath.setType("objectbypath");
        UriTemplateTypeElement folderByPathElement = (UriTemplateTypeElement)ws.addExtension(AtomCMIS.URITEMPLATE);
        folderByPathElement.build(objectByPath);
        CmisUriTemplateType query = new CmisUriTemplateType();
        query.setMediatype("application/atom+xml;type=feed");
        query.setTemplate(repoPath + "/query?" + "q={q}&" + "searchAllVersions={searchAllVersions}&" + "maxItems={maxItems}&" + "skipCount={skipCount}&" + "includeAllowableActions={includeAllowableActions}&" + "includeRelationships={includeRelationships}");
        query.setType("query");
        UriTemplateTypeElement queryElement = (UriTemplateTypeElement)ws.addExtension(AtomCMIS.URITEMPLATE);
        queryElement.build(query);
        CmisUriTemplateType typeById = new CmisUriTemplateType();
        typeById.setMediatype("application/atom+xml;type=entry");
        typeById.setTemplate(repoPath + "/typebyid/{id}");
        typeById.setType("typebyid");
        UriTemplateTypeElement typeByIdElement = (UriTemplateTypeElement)ws.addExtension(AtomCMIS.URITEMPLATE);
        typeByIdElement.build(typeById);
        CmisUriTemplateType changes = new CmisUriTemplateType();
        changes.setMediatype("application/atom+xml;type=feed");
        changes.setTemplate(repoPath + "/changes?" + "changeLogToken={changeLogToken}&" + "includeProperties={includeProperties}&" + "includePolicyIds={includePolicyIds}&" + "includeACL={includeACL}&" + "filter={filter}&" + "maxItems={maxItems}");
        changes.setType("changes");
        UriTemplateTypeElement changesElement = (UriTemplateTypeElement)ws.addExtension(AtomCMIS.URITEMPLATE);
        changesElement.build(changes);
    }

    protected Response createErrorResponse(Throwable t, int status) {
        return Response.status((int)status).entity((Object)t.getMessage()).type("text/plain").build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response createItem(String repositoryId, HttpServletRequest httpRequest) {
        RequestContext request = this.initRequestContext(httpRequest);
        Connection connection = null;
        try {
            connection = CmisRegistry.getInstance().getConnection(repositoryId);
            AbstractCmisCollection<?> collection = this.getCollection(request, connection);
            ResponseContext abderaResponse = collection.postEntry(request);
            Response.ResponseBuilder builder = Response.status((int)abderaResponse.getStatus());
            this.copyAbderaHeaders(builder, abderaResponse);
            Response response = builder.entity((Object)abderaResponse).build();
            return response;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response deleteItem(String repositoryId, HttpServletRequest httpRequest) {
        RequestContext request = this.initRequestContext(httpRequest);
        Connection connection = null;
        try {
            connection = CmisRegistry.getInstance().getConnection(repositoryId);
            AbstractCmisCollection<?> collection = this.getCollection(request, connection);
            ResponseContext abderaResponse = collection.deleteEntry(request);
            Response.ResponseBuilder builder = Response.status((int)abderaResponse.getStatus());
            this.copyAbderaHeaders(builder, abderaResponse);
            Response response = builder.entity((Object)abderaResponse).build();
            return response;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    protected AbstractCmisCollection<?> getCollection(RequestContext request, Connection connection) {
        WorkspaceManagerImpl wm = (WorkspaceManagerImpl)this.provider.getWorkspaceManager(request);
        AbstractCmisCollection<?> collection = wm.getCollectionAdapter(request, connection);
        return collection;
    }

    protected Collection<CollectionInfo> getCollectionsInfo(RequestContext request) {
        Collection workspaces = this.provider.getWorkspaceManager(request).getWorkspaces(request);
        Collection collections = ((WorkspaceInfo)workspaces.iterator().next()).getCollections(request);
        return collections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response getEntry(String repositoryId, HttpServletRequest httpRequest) {
        RequestContext request = this.initRequestContext(httpRequest);
        Connection connection = null;
        try {
            connection = CmisRegistry.getInstance().getConnection(repositoryId);
            AbstractCmisCollection<?> collection = this.getCollection(request, connection);
            ResponseContext abderaResponse = collection.getEntry(request);
            Response.ResponseBuilder builder = Response.status((int)abderaResponse.getStatus());
            this.copyAbderaHeaders(builder, abderaResponse);
            builder.header("Cache-Control", (Object)"no-cache");
            Response response = builder.entity((Object)abderaResponse).build();
            return response;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response getFeed(String repositoryId, HttpServletRequest httpRequest) {
        RequestContext request = this.initRequestContext(httpRequest);
        Connection connection = null;
        try {
            connection = CmisRegistry.getInstance().getConnection(repositoryId);
            AbstractCmisCollection<?> collection = this.getCollection(request, connection);
            ResponseContext abderaResponse = collection.getFeed(request);
            Response.ResponseBuilder builder = Response.status((int)abderaResponse.getStatus());
            this.copyAbderaHeaders(builder, abderaResponse);
            builder.header("Cache-Control", (Object)"no-cache");
            Response response = builder.entity((Object)abderaResponse).build();
            return response;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private RequestContext initRequestContext(HttpServletRequest httpRequest) {
        return new ServletRequestContext((Provider)this.provider, httpRequest){

            public String getTargetPath() {
                String uri = this.getUri().toString();
                String bpath = this.getTargetBasePath();
                return uri.substring(bpath.length());
            }
        };
    }
}

