/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.restatom.abdera;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.codec.binary.Base64InputStream;
import org.xcmis.restatom.abdera.ContentFileInputStream;

class ContentOutputStream
extends FilterOutputStream {
    private static final int MAX_BUFFER_SIZE = 204800;
    private int outBufLength = 0;
    private boolean isFoundStart;
    private boolean isXmlWrapped;
    private boolean isFoundEnd;
    private boolean isFirstWrite = true;
    private boolean overflow;
    private boolean isPrevCycleFull;
    private ByteArrayOutputStream byteTempBufStream;
    private File file;
    private OutputStream outFile;
    private boolean isClosed;

    public ContentOutputStream() {
        super(null);
        this.out = new ByteArrayOutputStream(204800);
        this.byteTempBufStream = new ByteArrayOutputStream();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.isFoundEnd) {
            return;
        }
        if (this.isFirstWrite) {
            this.isFirstWrite = false;
            boolean bl = this.isXmlWrapped = b[0] == 60;
        }
        if (!this.isXmlWrapped) {
            this.writeInternal(b, off, len);
        } else {
            if (!this.isFoundStart) {
                int indexOfStart = -1;
                for (int i = 0; i < len; ++i) {
                    if (b[i] != 62) continue;
                    indexOfStart = i;
                    break;
                }
                if (indexOfStart != -1) {
                    this.isFoundStart = true;
                    off = indexOfStart + 1;
                    len -= off;
                }
            }
            if (this.isFoundStart) {
                boolean isNotFullBlock;
                boolean bl = isNotFullBlock = len < b.length;
                if (isNotFullBlock) {
                    if (this.isPrevCycleFull) {
                        this.writeInternal(this.byteTempBufStream.toByteArray(), 0, -1);
                        this.byteTempBufStream.reset();
                    }
                    this.isPrevCycleFull = false;
                    this.writeEnd(b, off, len);
                } else {
                    if (this.isPrevCycleFull) {
                        this.writeInternal(this.byteTempBufStream.toByteArray(), 0, -1);
                    }
                    this.isPrevCycleFull = true;
                    this.byteTempBufStream.reset();
                    this.byteTempBufStream.write(b, off, len);
                }
            }
        }
    }

    private void writeEnd(byte[] b, int off, int len) throws IOException {
        int offForEnd = len < 30 ? off : off + len - 30;
        int lenForEnd = len < 30 ? len : 30;
        for (int indexOfEnd = offForEnd; indexOfEnd < offForEnd + lenForEnd; ++indexOfEnd) {
            if (b[indexOfEnd] != 60) continue;
            this.isFoundEnd = true;
            len = indexOfEnd - off;
        }
        this.writeInternal(b, off, len);
    }

    private void writeInternal(byte[] b, int off, int len) throws IOException {
        if (len == -1) {
            len = b.length;
        }
        if (!this.overflow) {
            this.outBufLength += len;
            boolean bl = this.overflow = this.outBufLength > 204800;
        }
        if (!this.overflow) {
            this.out.write(b, off, len);
        } else {
            if (this.outFile == null) {
                this.file = File.createTempFile("cmisatom-base64-", null);
                this.outFile = new FileOutputStream(this.file);
                if (this.outBufLength != len) {
                    this.outFile.write(((ByteArrayOutputStream)this.out).toByteArray());
                }
            }
            this.outFile.write(b, off, len);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            this.isClosed = true;
            if (this.isPrevCycleFull) {
                this.writeEnd(this.byteTempBufStream.toByteArray(), 0, this.byteTempBufStream.toByteArray().length);
            }
            if (this.overflow) {
                this.outFile.close();
            }
            super.close();
        }
    }

    public InputStream getInputStream() throws IOException {
        ContentFileInputStream input = null;
        if (this.overflow) {
            try {
                input = new ContentFileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        } else {
            ByteArrayInputStream bytesInput = new ByteArrayInputStream(((ByteArrayOutputStream)this.out).toByteArray());
            input = new Base64InputStream((InputStream)bytesInput);
        }
        return input;
    }
}

