/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.restatom.collections;

import java.util.List;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.xcmis.restatom.AtomCMIS;
import org.xcmis.restatom.collections.FolderDescentantsCollection;
import org.xcmis.spi.Connection;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.ItemsTree;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.model.CmisObject;
import org.xcmis.spi.model.IncludeRelationships;

public class FolderTreeCollection
extends FolderDescentantsCollection {
    public FolderTreeCollection(Connection connection) {
        super(connection);
        this.setHref("/foldertree");
    }

    @Override
    public String getTitle(RequestContext request) {
        return "Folder Tree";
    }

    @Override
    protected void addFeedDetails(Feed feed, RequestContext request) throws ResponseContextException {
        try {
            List tree;
            IncludeRelationships includeRelationships;
            boolean includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions", false);
            boolean includePathSegments = this.getBooleanParameter(request, "includePathSegment", false);
            String propertyFilter = request.getParameter("filter");
            String renditionFilter = request.getParameter("renditionFilter");
            try {
                includeRelationships = request.getParameter("includeRelationships") == null || request.getParameter("includeRelationships").length() == 0 ? IncludeRelationships.NONE : IncludeRelationships.fromValue((String)request.getParameter("includeRelationships"));
            }
            catch (IllegalArgumentException iae) {
                String msg = "Invalid parameter " + request.getParameter("includeRelationships");
                throw new ResponseContextException(msg, 400);
            }
            int depth = this.getIntegerParameter(request, "depth", -1);
            Connection connection = this.getConnection(request);
            String objectId = this.getId(request);
            if (!objectId.equals(connection.getStorage().getRepositoryInfo().getRootFolderId())) {
                CmisObject parent = connection.getFolderParent(objectId, true, null);
                feed.addLink(this.getObjectLink(this.getId(parent), request), "up", "application/atom+xml;type=entry", null, null, -1L);
            }
            if ((tree = connection.getFolderTree(objectId, depth, includeAllowableActions, includeRelationships, includePathSegments, true, propertyFilter, renditionFilter)).size() > 0) {
                Element numItems = feed.addExtension(AtomCMIS.NUM_ITEMS);
                numItems.setText(Integer.toString(tree.size()));
                for (ItemsTree oifContainer : tree) {
                    Entry e = feed.addEntry();
                    IRI feedIri = new IRI(this.getFeedIriForEntry(oifContainer.getContainer(), request));
                    this.addEntryDetails(request, e, feedIri, (CmisObject)oifContainer.getContainer());
                    if (((CmisObject)oifContainer.getContainer()).getPathSegment() != null) {
                        Element pathSegment = e.addExtension(AtomCMIS.PATH_SEGMENT);
                        pathSegment.setText(((CmisObject)oifContainer.getContainer()).getPathSegment());
                    }
                    if (oifContainer.getChildren() == null || oifContainer.getChildren().size() <= 0) continue;
                    this.addChildren(e, oifContainer.getChildren(), feedIri, request);
                }
            }
        }
        catch (ObjectNotFoundException onfe) {
            throw new ResponseContextException(this.createErrorResponse(onfe, 404));
        }
        catch (InvalidArgumentException iae) {
            throw new ResponseContextException(this.createErrorResponse(iae, 400));
        }
        catch (Throwable t) {
            throw new ResponseContextException(this.createErrorResponse(t, 500));
        }
    }
}

