/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.RAMDirectory;
import org.xcmis.search.config.SearchServiceConfiguration;
import org.xcmis.search.content.IndexModificationException;
import org.xcmis.search.lucene.AbstractLuceneQueryableIndexStorage;
import org.xcmis.search.lucene.index.FieldNames;
import org.xcmis.search.lucene.index.IndexException;
import org.xcmis.search.lucene.index.IndexTransactionException;
import org.xcmis.search.lucene.index.LuceneIndexTransaction;

public class InMemoryLuceneQueryableIndexStorage
extends AbstractLuceneQueryableIndexStorage {
    private final RAMDirectory ramDirectory = new RAMDirectory();
    private IndexReader indexReader;

    public InMemoryLuceneQueryableIndexStorage(SearchServiceConfiguration serviceConfuguration) throws IndexException {
        super(serviceConfuguration);
        this.initDirectory();
    }

    private void initDirectory() throws IndexException {
        try {
            IndexWriter.MaxFieldLength fieldLength = new IndexWriter.MaxFieldLength(10000);
            IndexWriter iw = new IndexWriter((Directory)this.ramDirectory, (Analyzer)new SimpleAnalyzer(), true, fieldLength);
            iw.close();
        }
        catch (IOException e) {
            throw new IndexException(e.getLocalizedMessage(), e);
        }
    }

    protected IndexReader getIndexReader() throws IndexException {
        try {
            if (this.indexReader == null) {
                this.indexReader = IndexReader.open((Directory)this.ramDirectory);
            } else if (!this.indexReader.isCurrent()) {
                this.indexReader = this.indexReader.reopen();
            }
        }
        catch (CorruptIndexException e) {
            throw new IndexException(e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            throw new IndexException(e.getLocalizedMessage(), e);
        }
        return this.indexReader;
    }

    protected synchronized Object save(LuceneIndexTransaction indexTransaction) throws IndexException, IndexTransactionException {
        try {
            IndexWriter writer = new IndexWriter((Directory)this.ramDirectory, (Analyzer)new StandardAnalyzer(), IndexWriter.MaxFieldLength.UNLIMITED);
            for (String string : indexTransaction.getRemovedDocuments()) {
                writer.deleteDocuments(new Term(FieldNames.UUID, string));
            }
            for (Map.Entry entry : indexTransaction.getAddedDocuments().entrySet()) {
                writer.updateDocument(new Term(FieldNames.UUID, (String)entry.getKey()), (Document)entry.getValue());
            }
            writer.commit();
            writer.close();
        }
        catch (CorruptIndexException e) {
            throw new IndexModificationException(e.getLocalizedMessage(), e);
        }
        catch (LockObtainFailedException e) {
            throw new IndexModificationException(e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            throw new IndexModificationException(e.getLocalizedMessage(), e);
        }
        return new Object();
    }
}

