/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.index;

import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.xcmis.search.lucene.index.FSIndexTransactionService;
import org.xcmis.search.lucene.index.FileSystemTransactionLog;
import org.xcmis.search.lucene.index.IndexTransaction;
import org.xcmis.search.lucene.index.IndexTransactionException;
import org.xcmis.search.lucene.index.IndexTransactionModificationReport;
import org.xcmis.search.lucene.index.IndexTransactionService;
import org.xcmis.search.lucene.index.LoggedIndexTransaction;
import org.xcmis.search.lucene.index.LuceneIndexTransaction;
import org.xcmis.search.lucene.index.TransactionLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggedIndexTransactionImpl
extends LuceneIndexTransaction
implements LoggedIndexTransaction<Document> {
    private boolean isTransactionLogged;
    private final TransactionLog transactionLog;

    public LoggedIndexTransactionImpl(IndexTransaction<Document> indexTransaction, TransactionLog transactionLog) {
        super(indexTransaction.getAddedDocuments(), indexTransaction.getRemovedDocuments());
        this.transactionLog = transactionLog;
        this.isTransactionLogged = true;
    }

    public LoggedIndexTransactionImpl(Map<String, Document> addedDocuments, Set<String> deletedDocuments, IndexTransactionService indexTransactionService) {
        super(addedDocuments, deletedDocuments);
        this.transactionLog = new FileSystemTransactionLog(addedDocuments.keySet(), deletedDocuments, (FSIndexTransactionService)indexTransactionService);
    }

    @Override
    public IndexTransaction<Document> apply(IndexTransactionModificationReport report) {
        return new LoggedIndexTransactionImpl(super.apply(report), this.transactionLog);
    }

    @Override
    public void end() throws IndexTransactionException {
        if (!this.isTransactionLogged) {
            throw new IndexTransactionException("Transaction not started");
        }
        this.transactionLog.removeLog();
    }

    @Override
    public TransactionLog getTransactionLog() {
        return this.transactionLog;
    }

    @Override
    public void log() throws IndexTransactionException {
        if (this.isTransactionLogged) {
            throw new IndexTransactionException("Transaction already started");
        }
        this.transactionLog.log();
        this.isTransactionLogged = true;
    }
}

