/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.xcmis.search.InvalidQueryException;
import org.xcmis.search.SearchServiceException;
import org.xcmis.search.Startable;
import org.xcmis.search.config.SearchServiceConfiguration;
import org.xcmis.search.content.ContentEntry;
import org.xcmis.search.content.ContentModificationListener;
import org.xcmis.search.content.IndexModificationException;
import org.xcmis.search.content.command.InvocationContext;
import org.xcmis.search.content.command.index.ModifyIndexCommand;
import org.xcmis.search.content.command.query.ProcessQueryCommand;
import org.xcmis.search.content.interceptors.ContentReaderInterceptor;
import org.xcmis.search.content.interceptors.InterceptorChain;
import org.xcmis.search.content.interceptors.QueryProcessorInterceptor;
import org.xcmis.search.content.interceptors.QueryableIndexStorage;
import org.xcmis.search.model.Query;
import org.xcmis.search.query.QueryExecutionException;
import org.xcmis.search.query.Searcher;
import org.xcmis.search.query.optimize.CriteriaBasedOptimizer;
import org.xcmis.search.query.plan.SimplePlaner;
import org.xcmis.search.result.ScoredRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchService
implements Startable,
ContentModificationListener,
Searcher {
    protected final SearchServiceConfiguration configuration;
    private final InterceptorChain interceptorChain;
    private InvocationContext defaultInvocationContext;

    public SearchService(SearchServiceConfiguration configuration) throws SearchServiceException {
        Validate.notNull((Object)configuration, (String)"The configuration argument may not be null");
        Validate.notNull((Object)configuration.getContentReader(), (String)"The configuration.getContentReader()  may not be null");
        this.configuration = configuration;
        this.interceptorChain = new InterceptorChain(configuration.getContentReader());
        this.defaultInvocationContext = configuration.getDefaultInvocationContext();
        this.addQueryableIndexStorageInterceptor(this.interceptorChain);
        this.interceptorChain.addBeforeInterceptor(new QueryProcessorInterceptor(new SimplePlaner(), new CriteriaBasedOptimizer()), QueryableIndexStorage.class);
    }

    @Override
    public List<ScoredRow> execute(Query query) throws InvalidQueryException, QueryExecutionException {
        if (this.defaultInvocationContext == null) {
            throw new QueryExecutionException("DefaultInvocationContext can't be null");
        }
        return this.execute(query, Collections.EMPTY_MAP);
    }

    @Override
    public List<ScoredRow> execute(Query query, Map<String, Object> bindVariablesValues) throws InvalidQueryException, QueryExecutionException {
        if (this.defaultInvocationContext == null) {
            throw new QueryExecutionException("DefaultInvocationContext can't be null");
        }
        return this.execute(query, bindVariablesValues, this.defaultInvocationContext);
    }

    @Override
    public List<ScoredRow> execute(Query query, Map<String, Object> bindVariablesValues, InvocationContext invocationContext) throws InvalidQueryException, QueryExecutionException {
        ProcessQueryCommand processQueryCommand = new ProcessQueryCommand(query, bindVariablesValues);
        try {
            return (List)this.interceptorChain.invoke(invocationContext, processQueryCommand);
        }
        catch (Throwable e) {
            throw new InvalidQueryException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void start() {
        this.interceptorChain.start();
    }

    @Override
    public void stop() {
        this.interceptorChain.stop();
    }

    @Override
    public void update(ContentEntry addedEntry, String removedEntry) throws IndexModificationException {
        ArrayList<ContentEntry> addedEntries = new ArrayList<ContentEntry>(1);
        if (addedEntry != null) {
            addedEntries.add(addedEntry);
        }
        HashSet<String> removedSet = new HashSet<String>(1);
        if (removedEntry != null) {
            removedSet.add(removedEntry);
        }
        this.update(addedEntries, removedSet);
    }

    @Override
    public void update(List<ContentEntry> addedEntries, Set<String> removedEntries) throws IndexModificationException {
        this.update(addedEntries, removedEntries, this.defaultInvocationContext);
    }

    @Override
    public void update(List<ContentEntry> addedEntries, Set<String> removedEntries, InvocationContext invocationContext) throws IndexModificationException {
        ModifyIndexCommand modifyIndexCommand = new ModifyIndexCommand(addedEntries, removedEntries);
        try {
            this.interceptorChain.invoke(invocationContext, modifyIndexCommand);
        }
        catch (IndexModificationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IndexModificationException(e.getLocalizedMessage(), e);
        }
    }

    protected void addQueryableIndexStorageInterceptor(InterceptorChain interceptorChain) throws SearchServiceException {
        String className = this.configuration.getIndexConfuguration().getQueryableIndexStorage();
        try {
            Class<?> queryableIndexStorageClass = Class.forName(className);
            if (!QueryableIndexStorage.class.isAssignableFrom(queryableIndexStorageClass)) {
                throw new SearchServiceException(className + "is no assignable from " + QueryableIndexStorage.class);
            }
            Constructor<?> constructor = queryableIndexStorageClass.getConstructor(this.configuration.getClass());
            QueryableIndexStorage queryableIndexStorage = (QueryableIndexStorage)constructor.newInstance(this.configuration);
            interceptorChain.addBeforeInterceptor(queryableIndexStorage, ContentReaderInterceptor.class);
        }
        catch (ClassNotFoundException e) {
            throw new SearchServiceException(e.getLocalizedMessage(), e);
        }
        catch (SecurityException e) {
            throw new SearchServiceException(e.getLocalizedMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new SearchServiceException(e.getLocalizedMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new SearchServiceException(e.getLocalizedMessage(), e);
        }
        catch (InstantiationException e) {
            throw new SearchServiceException(e.getLocalizedMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new SearchServiceException(e.getLocalizedMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new SearchServiceException(e.getTargetException());
        }
    }
}

