/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.search.config.IndexConfiguration;
import org.xcmis.search.config.IndexConfigurationException;
import org.xcmis.search.lucene.index.IndexException;
import org.xcmis.search.lucene.index.IndexInfo;
import org.xcmis.search.lucene.index.IndexTransaction;
import org.xcmis.search.lucene.index.LuceneIndexDataKeeperFactory;
import org.xcmis.search.lucene.index.LuceneIndexDataManager;
import org.xcmis.search.lucene.index.PersistedIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentIndexDataKeeperFactory
extends LuceneIndexDataKeeperFactory {
    private static final Log LOG = ExoLogger.getLogger(PersistentIndexDataKeeperFactory.class);
    private final File indexDir;
    private final IndexInfo indexNames;
    private final IndexConfiguration indexConfuguration;

    public PersistentIndexDataKeeperFactory(IndexConfiguration indexConfuguration) throws IndexException, IndexConfigurationException {
        this.indexConfuguration = indexConfuguration;
        this.indexDir = new File(indexConfuguration.getIndexDir());
        if (this.indexDir.isFile()) {
            throw new IndexException("Fail to create directory : " + this.indexDir.getAbsolutePath() + " file already exists.");
        }
        if (!this.indexDir.exists() && !this.indexDir.mkdirs()) {
            throw new IndexException("Fail to create directory : " + this.indexDir.getAbsolutePath());
        }
        this.indexNames = new IndexInfo("indexes");
    }

    @Override
    public LuceneIndexDataManager createNewIndexDataKeeper(IndexTransaction<Document> changes) throws IndexException {
        FSDirectory dir;
        String newIndexName = this.indexNames.newName();
        try {
            dir = FSDirectory.getDirectory((File)new File(this.indexDir, newIndexName));
            this.indexNames.addName(newIndexName);
            this.indexNames.write(this.indexDir);
        }
        catch (IOException e) {
            throw new IndexException(e.getLocalizedMessage(), e);
        }
        PersistedIndex persistedIndex = new PersistedIndex((Directory)dir);
        persistedIndex.save(changes);
        return persistedIndex;
    }

    public File getIndexDir() {
        return this.indexDir;
    }

    public List<PersistedIndex> init() throws IndexException {
        ArrayList<PersistedIndex> result = new ArrayList<PersistedIndex>();
        if (this.indexNames.exists(this.indexDir)) {
            this.indexNames.read(this.indexDir);
        }
        for (int i = 0; i < this.indexNames.size(); ++i) {
            File sub = new File(this.indexDir, this.indexNames.getName(i));
            if (!sub.exists()) {
                LOG.debug((Object)("index does not exist anymore: " + sub.getAbsolutePath()));
                continue;
            }
            try {
                FSDirectory dir = FSDirectory.getDirectory((File)sub);
                result.add(new PersistedIndex((Directory)dir));
                continue;
            }
            catch (IOException e) {
                throw new IndexException(e.getLocalizedMessage(), e);
            }
        }
        return result;
    }

    @Override
    public LuceneIndexDataManager merge(Collection<LuceneIndexDataManager> chains) throws IndexException {
        FSDirectory dir;
        try {
            String newIndexName = this.indexNames.newName();
            dir = FSDirectory.getDirectory((File)new File(this.indexDir, newIndexName));
            IndexWriter writer = new IndexWriter((Directory)dir, (Analyzer)new StandardAnalyzer(), IndexWriter.MaxFieldLength.UNLIMITED);
            ArrayList dirs = new ArrayList();
            for (LuceneIndexDataManager luceneIndexDataManager : chains) {
                dirs.add(luceneIndexDataManager.getDirectory());
            }
            Directory[] dirsToMerge = new Directory[dirs.size()];
            writer.addIndexesNoOptimize(dirs.toArray(dirsToMerge));
            writer.optimize();
            writer.close();
            this.indexNames.addName(newIndexName);
            this.indexNames.write(this.indexDir);
        }
        catch (IOException e) {
            throw new IndexException(e.getLocalizedMessage(), e);
        }
        return new PersistedIndex((Directory)dir);
    }
}

