/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.Validate;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopFieldDocs;
import org.xcmis.search.QueryObjectModelVisitor;
import org.xcmis.search.VisitException;
import org.xcmis.search.Visitors;
import org.xcmis.search.config.IndexConfiguration;
import org.xcmis.search.config.SearchServiceConfiguration;
import org.xcmis.search.content.ContentEntry;
import org.xcmis.search.content.command.InvocationContext;
import org.xcmis.search.content.command.index.ModifyIndexCommand;
import org.xcmis.search.content.command.query.ExecuteSelectorCommand;
import org.xcmis.search.content.interceptors.QueryableIndexStorage;
import org.xcmis.search.lucene.LuceneQueryBuilder;
import org.xcmis.search.lucene.content.VirtualTableResolver;
import org.xcmis.search.lucene.index.FieldNames;
import org.xcmis.search.lucene.index.IndexException;
import org.xcmis.search.lucene.index.IndexTransactionException;
import org.xcmis.search.lucene.index.LuceneIndexTransaction;
import org.xcmis.search.lucene.index.LuceneIndexer;
import org.xcmis.search.lucene.search.UUIDFieldSelector;
import org.xcmis.search.model.Limit;
import org.xcmis.search.model.QueryElement;
import org.xcmis.search.model.constraint.Constraint;
import org.xcmis.search.model.operand.FullTextSearchScore;
import org.xcmis.search.model.operand.Length;
import org.xcmis.search.model.operand.LowerCase;
import org.xcmis.search.model.operand.NodeDepth;
import org.xcmis.search.model.operand.NodeLocalName;
import org.xcmis.search.model.operand.NodeName;
import org.xcmis.search.model.operand.PropertyValue;
import org.xcmis.search.model.operand.UpperCase;
import org.xcmis.search.model.ordering.Order;
import org.xcmis.search.model.ordering.Ordering;
import org.xcmis.search.result.ScoredRow;
import org.xcmis.search.value.NameConverter;
import org.xcmis.search.value.PathSplitter;
import org.xcmis.spi.utils.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLuceneQueryableIndexStorage
extends QueryableIndexStorage {
    private static final Logger LOG = Logger.getLogger(AbstractLuceneQueryableIndexStorage.class);
    protected static final int MAX_FETCH_SIZE = 32768;
    protected final NameConverter nameConverter;
    protected final PathSplitter pathSplitter;
    protected final VirtualTableResolver tableResolver;
    protected LuceneIndexer nodeIndexer;
    protected IndexConfiguration indexConfuguration;

    public AbstractLuceneQueryableIndexStorage(SearchServiceConfiguration serviceConfiguration) throws IndexException {
        super(serviceConfiguration);
        Validate.notNull((Object)serviceConfiguration.getTableResolver(), (String)"The TableResolver may not be null in SearchServiceConfiguration");
        Validate.notNull((Object)serviceConfiguration.getNameConverter(), (String)"The NameConverter may not be null in SearchServiceConfiguration");
        Validate.notNull((Object)serviceConfiguration.getPathSplitter(), (String)"The PathSplitter may not be null in SearchServiceConfiguration");
        Validate.notNull((Object)serviceConfiguration.getIndexConfuguration(), (String)"The TableResolver  argument may not be null in SearchServiceConfiguration");
        Validate.notNull((Object)serviceConfiguration.getIndexConfuguration().getRootParentUuid(), (String)"The RootParentUuid  argument may not be null in IndexConfiguration");
        Validate.notNull((Object)serviceConfiguration.getIndexConfuguration().getRootUuid(), (String)"The RootUuid may not be null in IndexConfiguration");
        Validate.notNull((Object)serviceConfiguration.getIndexConfuguration().getTikaConfiguration(), (String)"The TikaConfiguration may not be null in IndexConfiguration");
        this.tableResolver = serviceConfiguration.getTableResolver();
        this.nameConverter = serviceConfiguration.getNameConverter();
        this.pathSplitter = serviceConfiguration.getPathSplitter();
        this.indexConfuguration = serviceConfiguration.getIndexConfuguration();
        this.nodeIndexer = new LuceneIndexer(this.indexConfuguration);
    }

    public Query getConstrainQuery(Constraint constraint, Map<String, Object> bindVariablesValues) throws VisitException, IndexException {
        LuceneQueryBuilder luceneQueryBuilder = new LuceneQueryBuilder(this.getIndexReader(), this.nameConverter, this.pathSplitter, bindVariablesValues, this.indexConfuguration);
        Visitors.visit((QueryElement)constraint, (QueryObjectModelVisitor)luceneQueryBuilder);
        return luceneQueryBuilder.getQuery();
    }

    @Override
    public Object visitExecuteSelectorCommand(InvocationContext ctx, ExecuteSelectorCommand command) throws Throwable {
        AbstractList resultNodes = new ArrayList();
        Query query = (Query)ctx.getTableResolver().resolve(command.getSelector().getName(), true);
        if (command.getConstrains().size() > 0) {
            BooleanQuery booleanQuery = new BooleanQuery();
            for (Constraint constrain : command.getConstrains()) {
                booleanQuery.add(this.getConstrainQuery(constrain, command.getBindVariablesValues()), BooleanClause.Occur.MUST);
            }
            booleanQuery.add(query, BooleanClause.Occur.MUST);
            query = booleanQuery;
        }
        IndexSearcher searcher = null;
        try {
            IndexReader indexReader = this.getIndexReader();
            if (indexReader != null) {
                searcher = new IndexSearcher(indexReader);
                Limit limit = command.getLimit();
                int hits = Math.min(32768, limit.getOffset() + limit.getRowLimit());
                TopFieldDocs topDocs = searcher.search(query, null, hits, this.getSort(command.getOrderings()));
                resultNodes = new LinkedList();
                for (int i = limit.getOffset(); i < topDocs.scoreDocs.length; ++i) {
                    Document doc = searcher.doc(topDocs.scoreDocs[i].doc, (FieldSelector)new UUIDFieldSelector());
                    String id = doc.get(FieldNames.UUID);
                    resultNodes.add(new ScoredRow(command.getAlias().getName(), id, topDocs.scoreDocs[i].score));
                }
            }
        }
        catch (CorruptIndexException e) {
            throw new IndexException(e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            throw new IndexException(e.getLocalizedMessage(), e);
        }
        finally {
            try {
                if (searcher != null) {
                    searcher.close();
                }
            }
            catch (IOException e) {
                throw new IndexException(e.getLocalizedMessage(), e);
            }
        }
        return resultNodes;
    }

    @Override
    public Object visitModifyIndexCommand(InvocationContext ctx, ModifyIndexCommand command) throws Throwable {
        HashMap<String, Document> addedDocuments = new HashMap<String, Document>();
        for (ContentEntry entry : command.getAddedDocuments()) {
            addedDocuments.put(entry.getIdentifier(), this.nodeIndexer.createDocument(entry));
        }
        LuceneIndexTransaction indexTransaction = new LuceneIndexTransaction(addedDocuments, command.getDeletedDocuments());
        return this.save(indexTransaction);
    }

    protected abstract IndexReader getIndexReader() throws IndexException;

    protected abstract Object save(LuceneIndexTransaction var1) throws IndexException, IndexTransactionException;

    private Sort getSort(List<Ordering> list) throws VisitException {
        if (list.size() > 0) {
            SortField[] fields = new SortField[list.size()];
            SortFieldVisitor sortVisitor = new SortFieldVisitor();
            int i = 0;
            for (Ordering ordering : list) {
                Visitors.visitAll((QueryElement)ordering, (QueryObjectModelVisitor)sortVisitor);
                fields[i++] = sortVisitor.getSortField();
            }
            return new Sort(fields);
        }
        return new Sort();
    }

    private class SortFieldVisitor
    extends Visitors.AbstractModelVisitor {
        private Order order;
        private SortField sortField;

        private SortFieldVisitor() {
        }

        public SortField getSortField() {
            return this.sortField;
        }

        public void visit(FullTextSearchScore node) throws VisitException {
            this.sortField = new SortField(null, 0, this.order == Order.ASCENDING);
        }

        public void visit(Length node) throws VisitException {
            throw new NotImplementedException();
        }

        public void visit(LowerCase node) throws VisitException {
            throw new NotImplementedException();
        }

        public void visit(NodeDepth depth) throws VisitException {
            throw new NotImplementedException();
        }

        public void visit(NodeLocalName node) throws VisitException {
            super.visit(node);
        }

        public void visit(NodeName node) throws VisitException {
            throw new NotImplementedException();
        }

        public void visit(Ordering node) throws VisitException {
            this.order = node.getOrder();
        }

        public void visit(PropertyValue node) throws VisitException {
            this.sortField = new SortField(FieldNames.createPropertyFieldName(node.getPropertyName()), this.order == Order.DESCENDING);
        }

        public void visit(UpperCase node) throws VisitException {
            throw new NotImplementedException();
        }
    }
}

