/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.index;

import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.xcmis.search.lucene.index.FSIndexTransactionService;
import org.xcmis.search.lucene.index.TransactionLog;
import org.xcmis.search.lucene.index.TransactionLogException;
import org.xcmis.spi.utils.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemTransactionLog
implements TransactionLog {
    public static final int LOG_DIR_COUNT = 2;
    private static final int ADDED_DOCUMENTS = 1;
    private static final Logger LOG = Logger.getLogger(FileSystemTransactionLog.class);
    private static final int REMOVED_DOCUMENTS = 3;
    private static final int UUID_SIZE = 32;
    private Set<String> addedDocumentsUuids;
    private File file;
    private Set<String> removedDocumentsUuids;
    private final FSIndexTransactionService storage;

    public FileSystemTransactionLog(File srcFile, FSIndexTransactionService storage) throws TransactionLogException {
        this.storage = storage;
        this.file = srcFile;
        if (!this.file.exists()) {
            throw new TransactionLogException("File not exist " + this.file.getAbsolutePath());
        }
    }

    public FileSystemTransactionLog(Set<String> addedDocumentsUuids, Set<String> removedDocumentsUuids, FSIndexTransactionService storage) {
        this.addedDocumentsUuids = addedDocumentsUuids;
        this.removedDocumentsUuids = removedDocumentsUuids;
        this.storage = storage;
    }

    @Override
    public Set<String> getAddedList() throws TransactionLogException {
        if (this.addedDocumentsUuids == null) {
            this.load();
        }
        return this.addedDocumentsUuids;
    }

    @Override
    public Set<String> getRemovedList() throws TransactionLogException {
        if (this.removedDocumentsUuids == null) {
            this.load();
        }
        return this.removedDocumentsUuids;
    }

    @Override
    public void load() throws TransactionLogException {
        this.addedDocumentsUuids = new HashSet<String>();
        this.removedDocumentsUuids = new HashSet<String>();
        FileInputStream in = null;
        try {
            int type;
            in = new FileInputStream(this.file);
            block14: while ((type = in.read()) != -1) {
                byte[] buf = new byte[32];
                if (in.read(buf) != 32) {
                    throw new TransactionLogException(" TransactionLog file is corrupted. Unexpected end of file: " + this.file.getAbsolutePath());
                }
                String uuid = new String(buf);
                switch (type) {
                    case 1: {
                        this.addedDocumentsUuids.add(uuid);
                        continue block14;
                    }
                    case 3: {
                        this.removedDocumentsUuids.add(uuid);
                        continue block14;
                    }
                }
                throw new TransactionLogException(" TransactionLog file is corrupted. Unexpected type of record " + type + ". file : " + this.file.getAbsolutePath());
            }
        }
        catch (EOFException e) {
            throw new TransactionLogException(" TransactionLog file is uncomplete: " + this.file.getAbsolutePath());
        }
        catch (IOException e) {
            throw new TransactionLogException("TransactionLog read exception: " + e.getMessage(), e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOG.warn("Can not close log file " + this.file.getAbsolutePath());
                }
            }
        }
    }

    @Override
    public void log() throws TransactionLogException {
        OutputStream out = null;
        try {
            String fileName = UUID.randomUUID().toString();
            File dir = new File(this.storage.getStorageDir().getAbsoluteFile() + this.buildPathFromName(fileName, 2));
            this.file = this.storage.getLockFactory().createFile(dir, fileName, 2);
            out = new BufferedOutputStream(new FileOutputStream(this.file));
            this.writeSet(out, this.addedDocumentsUuids, 1);
            this.writeSet(out, this.removedDocumentsUuids, 3);
            out.flush();
        }
        catch (IOException e) {
            throw new TransactionLogException("TransactionLog write exception: " + e.getMessage(), e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    LOG.warn("Can not close log file" + this.file.getAbsolutePath());
                }
            }
        }
    }

    @Override
    public void removeLog() throws TransactionLogException {
        if (!this.file.exists()) {
            LOG.warn("TransactionLog file not exist. " + this.file.getAbsolutePath());
        }
        if (!this.removeLogFile(this.file)) {
            throw new TransactionLogException("TransactionLog file was not delete. " + this.file.getAbsolutePath());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Transaction log removed " + this.file.getAbsolutePath());
        }
    }

    private String buildPathFromName(String fileName, int dirCount) {
        char[] chs = fileName.toCharArray();
        String path = "";
        for (int i = 1; i <= dirCount; ++i) {
            path = path + File.separator + chs[chs.length - i];
        }
        return path;
    }

    private boolean removeLogFile(File file) throws TransactionLogException {
        File dir = file.getParentFile();
        if (!file.delete()) {
            return false;
        }
        this.storage.getLockFactory().removeDirectory(dir, 2);
        return true;
    }

    private void writeSet(OutputStream out, Set<String> keys, int flag) throws IOException {
        for (String key : keys) {
            out.write(flag);
            out.write(key.getBytes());
        }
    }
}

