/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.index;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.NotImplementedException;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumberTools;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.sax.BodyContentHandler;
import org.xcmis.search.config.IndexConfiguration;
import org.xcmis.search.content.ContentEntry;
import org.xcmis.search.content.ContentIndexer;
import org.xcmis.search.content.Property;
import org.xcmis.search.lucene.index.ExtendedNumberTools;
import org.xcmis.search.lucene.index.FieldNames;
import org.xcmis.spi.utils.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneIndexer
implements ContentIndexer<Document> {
    private final IndexConfiguration indexConfiguration;
    private final AutoDetectParser parser;
    private static final Logger LOG = Logger.getLogger(LuceneIndexer.class);

    public LuceneIndexer(IndexConfiguration indexConfiguration) {
        this.parser = new AutoDetectParser(indexConfiguration.getTikaConfiguration());
        this.indexConfiguration = indexConfiguration;
    }

    @Override
    public Document createDocument(ContentEntry contentEntry) {
        int i;
        Document doc = new Document();
        doc.add((Fieldable)new Field(FieldNames.UUID, contentEntry.getIdentifier(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
        if (contentEntry.getParentIdentifiers().length == 0) {
            doc.add((Fieldable)new Field(FieldNames.PARENT, this.indexConfiguration.getRootParentUuid(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
            doc.add((Fieldable)new Field(FieldNames.LABEL, "", Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
        } else {
            for (i = 0; i < contentEntry.getParentIdentifiers().length; ++i) {
                String parentIdetifier = contentEntry.getParentIdentifiers()[i];
                doc.add((Fieldable)new Field(FieldNames.PARENT, parentIdetifier, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
                doc.add((Fieldable)new Field(FieldNames.LABEL, contentEntry.getName(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
            }
        }
        for (i = 0; i < contentEntry.getTableNames().length; ++i) {
            doc.add((Fieldable)new Field(FieldNames.TABLE_NAME, contentEntry.getTableNames()[i], Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
        }
        for (i = 0; i < contentEntry.getProperties().length; ++i) {
            Property property = contentEntry.getProperties()[i];
            if (!this.isIndexed(property.getName())) continue;
            this.addProperty(doc, property);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBinaryProperty(Document doc, String propName, Property.BinaryValue data) {
        if (data.getMimeType() != null && this.parser != null) {
            InputStream is = data.getValue();
            try {
                Metadata metadata = new Metadata();
                metadata.set("Content-Type", data.getMimeType());
                if (data.getEncoding() != null) {
                    metadata.set("Content-Encoding", data.getEncoding());
                }
                BodyContentHandler handler = new BodyContentHandler();
                this.parser.parse(is, (ContentHandler)handler, metadata);
                Field f = new Field(FieldNames.createFullTextFieldName(propName), handler.toString(), Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.NO);
                doc.add((Fieldable)f);
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Binary value indexer IO error " + e, (Throwable)e);
                }
            }
            catch (SAXException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Binary value indexer IO error " + e, (Throwable)e);
                }
            }
            catch (TikaException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Binary value indexer IO error " + (Object)((Object)e), (Throwable)e);
                }
            }
            finally {
                block26: {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            if (!LOG.isDebugEnabled()) break block26;
                            LOG.warn("Binary value indexer IO error " + e, (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    private void addBooleanValue(Document doc, String fieldName, Boolean internalValue) {
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, internalValue.toString(), false));
    }

    private void addCalendarValue(Document doc, String fieldName, Calendar value) {
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, DateTools.dateToString((Date)value.getTime(), (DateTools.Resolution)DateTools.Resolution.MILLISECOND), false));
    }

    private void addDoubleValue(Document doc, String fieldName, Double doubleValue) {
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, ExtendedNumberTools.doubleToString(doubleValue), false));
    }

    private void addLengthField(Document doc, String propName, Property.ContentValue value) {
        doc.add((Fieldable)new Field(FieldNames.createFieldLengthName(propName), NumberTools.longToString((long)value.getLength()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
    }

    private void addLongValue(Document doc, String fieldName, Long longValue) {
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, NumberTools.longToString((long)longValue), false));
    }

    private void addMVPName(Document doc, String propName) {
        doc.add((Fieldable)new Field(FieldNames.MVP, propName, Field.Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.NO));
    }

    private void addProperty(Document doc, Property propertyData) {
        String propName = propertyData.getName();
        this.addPropertyName(doc, propName);
        Collection data = propertyData.getValue();
        for (Property.ContentValue value : data) {
            switch (propertyData.getType()) {
                case BINARY: {
                    this.addBinaryProperty(doc, propName, (Property.BinaryValue)value);
                    break;
                }
                case BOOLEAN: {
                    this.addBooleanValue(doc, propName, Boolean.parseBoolean(value.getValue().toString()));
                    break;
                }
                case NAME: 
                case PATH: 
                case STRING: {
                    this.addStringValue(doc, propName, value.getValue().toString(), true);
                    break;
                }
                case LONG: {
                    this.addLongValue(doc, propName, Long.parseLong(value.getValue().toString()));
                    break;
                }
                case DOUBLE: {
                    this.addDoubleValue(doc, propName, Double.parseDouble(value.getValue().toString()));
                    break;
                }
                case DATE: {
                    this.addCalendarValue(doc, propName, (Calendar)value.getValue());
                    break;
                }
                default: {
                    throw new NotImplementedException();
                }
            }
            this.addLengthField(doc, propName, value);
        }
        if (data.size() > 1) {
            this.addMVPName(doc, propName);
        }
    }

    private void addPropertyName(Document doc, String propertyName) {
        doc.add((Fieldable)new Field(FieldNames.PROPERTIES_SET, propertyName, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
    }

    private void addStringValue(Document doc, String fieldName, String stringValue, boolean tokenized) {
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, stringValue, false));
        if (tokenized && stringValue.length() != 0) {
            doc.add((Fieldable)new Field(FieldNames.createFullTextFieldName(fieldName), stringValue, Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.NO));
        }
    }

    private Field createFieldWithoutNorms(String fieldName, String internalValue, boolean store) {
        Field field = new Field(FieldNames.createPropertyFieldName(fieldName), internalValue, store ? Field.Store.YES : Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO);
        return field;
    }

    private boolean isIndexed(String propertyName) {
        return true;
    }
}

