/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.index;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.apache.lucene.document.Document;
import org.xcmis.search.config.IndexConfiguration;
import org.xcmis.search.config.IndexConfigurationException;
import org.xcmis.search.lucene.IndexRecoveryTool;
import org.xcmis.search.lucene.index.CacheableIndexDataManager;
import org.xcmis.search.lucene.index.CompositeTransactionLog;
import org.xcmis.search.lucene.index.FSIndexTransactionService;
import org.xcmis.search.lucene.index.IndexException;
import org.xcmis.search.lucene.index.IndexTransaction;
import org.xcmis.search.lucene.index.IndexTransactionException;
import org.xcmis.search.lucene.index.IndexTransactionModificationReport;
import org.xcmis.search.lucene.index.LoggedIndexTransactionImpl;
import org.xcmis.search.lucene.index.ReadWriteDirectoryFactory;
import org.xcmis.search.lucene.index.TransactionLog;
import org.xcmis.search.lucene.index.TransactionLogException;
import org.xcmis.spi.utils.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionableIndexDataManager
extends CacheableIndexDataManager {
    protected static final String TRANSACTION_LOG_STORAGE_NAME = "logs";
    private final Logger log = Logger.getLogger(TransactionableIndexDataManager.class);
    private final IndexRecoveryTool indexRecoveryTool;
    private final FSIndexTransactionService transactionService;

    public TransactionableIndexDataManager(IndexConfiguration indexConfuguration, IndexRecoveryTool indexRecoveryTool) throws IndexException, IndexConfigurationException {
        super(indexConfuguration);
        this.indexRecoveryTool = indexRecoveryTool;
        File indexDir = new File(indexConfuguration.getIndexDir());
        if (!indexDir.exists() && !indexDir.mkdirs()) {
            throw new IndexException("Fail to create index directory : " + indexDir.getAbsolutePath());
        }
        File storageDir = new File(indexDir, TRANSACTION_LOG_STORAGE_NAME);
        if (!storageDir.exists() && !storageDir.mkdirs()) {
            throw new IndexException("Fail to create directory : " + storageDir.getAbsolutePath());
        }
        this.transactionService = new FSIndexTransactionService(storageDir, new ReadWriteDirectoryFactory());
    }

    @Override
    public IndexTransactionModificationReport save(IndexTransaction<Document> changes) throws IndexException, IndexTransactionException {
        boolean removeTransaction = changes.getRemovedDocuments().size() > 0 && changes.getAddedDocuments().size() == 0;
        LoggedIndexTransactionImpl loggedIndexTransaction = new LoggedIndexTransactionImpl(changes.getAddedDocuments(), changes.getRemovedDocuments(), this.transactionService);
        loggedIndexTransaction.log();
        IndexTransactionModificationReport result = super.save(loggedIndexTransaction);
        if (removeTransaction) {
            loggedIndexTransaction.end();
        }
        return result;
    }

    @Override
    public void start() {
        super.start();
        try {
            if (this.transactionService.hasUncommitedTransactions()) {
                List<TransactionLog> logs = this.transactionService.getTransactionLogs();
                CompositeTransactionLog compositeTransactionLog = new CompositeTransactionLog(logs);
                HashSet<String> compromisedUuids = new HashSet<String>();
                compromisedUuids.addAll(compositeTransactionLog.getAddedList());
                compromisedUuids.addAll(compositeTransactionLog.getRemovedList());
                this.indexRecoveryTool.recover(compromisedUuids.iterator());
                for (TransactionLog transactionLog : logs) {
                    transactionLog.removeLog();
                }
            }
        }
        catch (TransactionLogException e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        catch (IndexException e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void stop() {
        super.stop();
    }
}

