/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.index.merge;

import java.util.Collection;
import org.xcmis.search.lucene.index.LuceneIndexDataManager;
import org.xcmis.search.lucene.index.merge.AggregatePolicy;
import org.xcmis.search.lucene.index.merge.InheritanceAggregationPolicy;
import org.xcmis.spi.utils.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxTotalDocumentCountAggregatePolicy
extends InheritanceAggregationPolicy {
    public static final int DEFAULT_MAX_DOCUMENT_COUNT = 6000;
    private final Logger log = Logger.getLogger(MaxTotalDocumentCountAggregatePolicy.class);

    public MaxTotalDocumentCountAggregatePolicy(AggregatePolicy superAggregatePolicy) {
        super(superAggregatePolicy);
    }

    @Override
    public Collection<LuceneIndexDataManager> findIndexDataManagerToAggrigate(Collection<LuceneIndexDataManager> aggregateCandidat, long requiredCandidatCount, long reguiredTotalCandidatSize) {
        long totalDocuments = 0L;
        for (LuceneIndexDataManager luceneIndexDataManager : aggregateCandidat) {
            totalDocuments += luceneIndexDataManager.getDocumentCount();
        }
        if (totalDocuments > 6000L) {
            // empty if block
        }
        return super.findIndexDataManagerToAggrigate(aggregateCandidat, requiredCandidatCount, reguiredTotalCandidatSize);
    }
}

