/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.index.merge;

import java.util.ArrayList;
import java.util.Collection;
import org.xcmis.search.lucene.index.LuceneIndexDataManager;
import org.xcmis.search.lucene.index.merge.ModificationTimeAggregatePolicy;
import org.xcmis.spi.utils.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PendingAggregatePolicy
extends ModificationTimeAggregatePolicy {
    private final Logger log = Logger.getLogger(PendingAggregatePolicy.class);
    private static final int DEFAULT_MIN_AGGREGATE_TIME = 1000;
    private int minAggregateTime = 1000;
    private long lastFindFinishedTime;

    public int getMinAggregateTime() {
        return this.minAggregateTime;
    }

    public void setMinAggregateTime(int minAggregateTime) {
        this.minAggregateTime = minAggregateTime;
    }

    @Override
    public Collection<LuceneIndexDataManager> findIndexDataManagerToAggrigate(Collection<LuceneIndexDataManager> aggregateCandidat, long requiredCandidatCount, long reguiredTotalCandidatSize) {
        if (requiredCandidatCount == 0L && reguiredTotalCandidatSize == 0L && System.currentTimeMillis() - this.lastFindFinishedTime < 1000L) {
            return new ArrayList<LuceneIndexDataManager>();
        }
        Collection<LuceneIndexDataManager> indexDataManagerToAggrigate = super.findIndexDataManagerToAggrigate(aggregateCandidat, requiredCandidatCount, reguiredTotalCandidatSize);
        this.lastFindFinishedTime = System.currentTimeMillis();
        return indexDataManagerToAggrigate;
    }
}

