/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.query.plan;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.xcmis.search.InvalidQueryException;
import org.xcmis.search.QueryObjectModelVisitor;
import org.xcmis.search.VisitException;
import org.xcmis.search.Visitors;
import org.xcmis.search.content.ColumnDoesNotExistOnTable;
import org.xcmis.search.content.Schema;
import org.xcmis.search.content.TableDoesntExistException;
import org.xcmis.search.model.Limit;
import org.xcmis.search.model.Query;
import org.xcmis.search.model.QueryElement;
import org.xcmis.search.model.column.Column;
import org.xcmis.search.model.constraint.And;
import org.xcmis.search.model.constraint.Constraint;
import org.xcmis.search.model.ordering.Ordering;
import org.xcmis.search.model.source.Join;
import org.xcmis.search.model.source.Selector;
import org.xcmis.search.model.source.SelectorName;
import org.xcmis.search.model.source.Source;
import org.xcmis.search.query.QueryExecutionContext;
import org.xcmis.search.query.plan.JoinAlgorithm;
import org.xcmis.search.query.plan.QueryExecutionPlan;
import org.xcmis.search.query.plan.QueryExecutionPlaner;
import org.xcmis.search.query.validate.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePlaner
implements QueryExecutionPlaner {
    @Override
    public QueryExecutionPlan createPlan(QueryExecutionContext context, Query query) {
        try {
            HashMap<SelectorName, Schema.Table> querySelectorsMap = new HashMap<SelectorName, Schema.Table>();
            QueryExecutionPlan plan = this.createSelectorPlan(context, query.getSource(), querySelectorsMap);
            plan = this.createConstrainPlan(context, query.getConstraint(), querySelectorsMap, plan);
            plan = this.createProject(context, query.getColumns(), querySelectorsMap, plan);
            plan = this.createSorting(context, query.getOrderings(), plan);
            plan = this.createLimits(context, query.getLimits(), plan);
            Visitors.visitAll((QueryElement)query, (QueryObjectModelVisitor)new Validator(context, querySelectorsMap));
            return plan;
        }
        catch (VisitException e) {
            context.getExecutionExceptions().addException((Throwable)new InvalidQueryException(e.getLocalizedMessage(), e.getCause()));
            return null;
        }
    }

    protected QueryExecutionPlan createConstrainPlan(QueryExecutionContext context, Constraint constraint, Map<SelectorName, Schema.Table> querySelectorsMap, QueryExecutionPlan executionPlan) {
        LinkedList<Constraint> andableConstraints = new LinkedList<Constraint>();
        this.separateAndConstraints(constraint, andableConstraints);
        for (Constraint andedConstrain : andableConstraints) {
            QueryExecutionPlan.WhereExecutionPlan whereExecutionPlan = new QueryExecutionPlan.WhereExecutionPlan(executionPlan);
            whereExecutionPlan.setConstraint(andedConstrain);
            whereExecutionPlan.addSelectors(Visitors.getSelectorsReferencedBy((QueryElement)andedConstrain));
            executionPlan = whereExecutionPlan;
        }
        return executionPlan;
    }

    protected QueryExecutionPlan createSelectorPlan(final QueryExecutionContext context, Source source, final Map<SelectorName, Schema.Table> querySelectorsMap) throws VisitException {
        final Stack stepsStack = new Stack();
        Visitors.visit((QueryElement)source, (QueryObjectModelVisitor)new Visitors.AbstractModelVisitor(){

            public void visit(Join node) throws VisitException {
                QueryExecutionPlan.JoinExecutionPlan joinPlan = new QueryExecutionPlan.JoinExecutionPlan();
                joinPlan.setJoinType(node.getType());
                joinPlan.setJoinAlgorithm(JoinAlgorithm.NESTED_LOOP);
                joinPlan.setJoinCondition(node.getJoinCondition());
                node.getLeft().accept((QueryObjectModelVisitor)this);
                joinPlan.setLeftPlan((QueryExecutionPlan.SourceExecutionPlan)stepsStack.pop());
                node.getRight().accept((QueryObjectModelVisitor)this);
                joinPlan.setRightPlan((QueryExecutionPlan.SourceExecutionPlan)stepsStack.pop());
            }

            public void visit(Selector selector) {
                QueryExecutionPlan.SelectorExecutionPlan selectorPlan = new QueryExecutionPlan.SelectorExecutionPlan();
                if (selector.hasAlias()) {
                    selectorPlan.addSelector(selector.getAlias());
                    selectorPlan.setAlias(selector.getAlias());
                    selectorPlan.setName(selector.getName());
                } else {
                    selectorPlan.addSelector(selector.getName());
                    selectorPlan.setName(selector.getName());
                }
                Schema.Table table = context.getSchema().getTable(selector.getName());
                if (table != null) {
                    if (querySelectorsMap.put(selector.getAliasOrName(), table) != null) {
                        // empty if block
                    }
                    selectorPlan.setColumns(table.getColumns());
                } else {
                    context.getExecutionExceptions().addException(new TableDoesntExistException("Table " + selector.getName() + " doesnt exist"));
                }
                stepsStack.push(selectorPlan);
            }
        });
        return (QueryExecutionPlan)stepsStack.pop();
    }

    protected QueryExecutionPlan createSorting(QueryExecutionContext context, List<Ordering> orderings, QueryExecutionPlan executionPlan) {
        if (!orderings.isEmpty()) {
            QueryExecutionPlan.SortExecutionPlan sortExecutionPlan = new QueryExecutionPlan.SortExecutionPlan(executionPlan);
            sortExecutionPlan.setOrderings(orderings);
            for (Ordering ordering : orderings) {
                sortExecutionPlan.addSelectors(Visitors.getSelectorsReferencedBy((QueryElement)ordering));
            }
            return sortExecutionPlan;
        }
        return executionPlan;
    }

    protected QueryExecutionPlan createProject(QueryExecutionContext context, List<Column> columns, Map<SelectorName, Schema.Table> selectors, QueryExecutionPlan executionPlan) {
        if (columns == null) {
            columns = Collections.emptyList();
        }
        QueryExecutionPlan.ProjectExecutionPlan projectPlan = new QueryExecutionPlan.ProjectExecutionPlan(executionPlan);
        if (columns.isEmpty() || columns.size() == 1 && ((Column)columns.get(0)).getPropertyName().equals("*")) {
            columns = new LinkedList();
            for (Map.Entry<SelectorName, Schema.Table> entry : selectors.entrySet()) {
                SelectorName tableName = entry.getKey();
                Schema.Table table = entry.getValue();
                projectPlan.addSelector(tableName);
                for (Schema.Column column : table.getColumns()) {
                    String columnName;
                    String propertyName = columnName = column.getName();
                    columns.add(new Column(tableName, propertyName, columnName));
                }
            }
        } else {
            for (Column column : columns) {
                if (column.isFunction()) continue;
                SelectorName tableName = column.getSelectorName();
                projectPlan.addSelector(tableName);
                Schema.Table table = selectors.get(tableName);
                if (table == null) {
                    context.getExecutionExceptions().addException(new TableDoesntExistException("Table " + tableName + " doesnt exist"));
                    continue;
                }
                String columnName = column.getPropertyName();
                String name = columnName;
                if (table.getColumn(name) != null) continue;
                context.getExecutionExceptions().addException(new ColumnDoesNotExistOnTable("Column  " + name + " on " + tableName + " doesnt exist"));
            }
        }
        projectPlan.setColumns(columns);
        return projectPlan;
    }

    protected QueryExecutionPlan createLimits(QueryExecutionContext context, Limit limit, QueryExecutionPlan executionPlan) {
        if (limit != null && !limit.isUnlimited()) {
            QueryExecutionPlan.LimitExecutionPlan limitExecutionPlan = new QueryExecutionPlan.LimitExecutionPlan(executionPlan);
            limitExecutionPlan.setLimit(limit);
            return limitExecutionPlan;
        }
        return executionPlan;
    }

    protected void separateAndConstraints(Constraint constraint, List<Constraint> andableConstraints) {
        if (constraint == null) {
            return;
        }
        if (constraint instanceof And) {
            And and = (And)constraint;
            this.separateAndConstraints(and.getLeft(), andableConstraints);
            this.separateAndConstraints(and.getRight(), andableConstraints);
        } else {
            andableConstraints.add(constraint);
        }
    }
}

